/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ui;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsPlugin;
import org.eclipse.ui.externaltools.internal.ui.BuilderPropertyPage;
import org.eclipse.ui.externaltools.internal.ui.ExternalToolsUIMessages;

class BuilderLabelProvider
extends LabelProvider {
    private static final String IMG_BUILDER = "icons/full/obj16/builder.png";
    private static final String IMG_INVALID_BUILD_TOOL = "icons/full/obj16/invalid_build_tool.png";
    IDebugModelPresentation debugModelPresentation = DebugUITools.newDebugModelPresentation();
    private final Image builderImage = ExternalToolsPlugin.getDefault().getImageDescriptor("icons/full/obj16/builder.png").createImage();
    private final Image invalidBuildToolImage = ExternalToolsPlugin.getDefault().getImageDescriptor("icons/full/obj16/invalid_build_tool.png").createImage();

    BuilderLabelProvider() {
    }

    public String getText(Object element) {
        if (element instanceof ICommand) {
            return this.getCommandText((ICommand)element);
        }
        if (element instanceof ILaunchConfiguration || element instanceof ILaunchConfigurationType) {
            return this.getDebugModelText(element);
        }
        if (element instanceof BuilderPropertyPage.ErrorConfig) {
            return ExternalToolsUIMessages.BuilderPropertyPage_invalidBuildTool;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ICommand) {
            return this.getCommandImage();
        }
        if (element instanceof ILaunchConfiguration || element instanceof ILaunchConfigurationType) {
            return this.getDebugModelImage(element);
        }
        if (element instanceof BuilderPropertyPage.ErrorConfig) {
            return this.invalidBuildToolImage;
        }
        return super.getImage(element);
    }

    public String getCommandText(ICommand command) {
        String builderID = command.getBuilderName();
        return this.getBuilderName(builderID);
    }

    private String getBuilderName(String builderID) {
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.resources", "builders", builderID);
        String builderName = extension != null ? extension.getLabel() : NLS.bind((String)ExternalToolsUIMessages.BuilderPropertyPage_missingBuilder, (Object[])new Object[]{builderID});
        return builderName;
    }

    public Image getCommandImage() {
        return this.builderImage;
    }

    public String getDebugModelText(Object element) {
        if (element instanceof ILaunchConfiguration) {
            try {
                String disabledBuilderName = ((ILaunchConfiguration)element).getAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", null);
                if (disabledBuilderName != null) {
                    return this.getBuilderName(disabledBuilderName);
                }
            }
            catch (CoreException coreException) {}
        }
        return this.debugModelPresentation.getText(element);
    }

    public Image getDebugModelImage(Object element) {
        if (element instanceof ILaunchConfiguration) {
            try {
                String disabledBuilderName = ((ILaunchConfiguration)element).getAttribute("org.eclipse.ui.externaltools.ATTR_DISABLED_BUILDER", null);
                if (disabledBuilderName != null) {
                    return this.builderImage;
                }
            }
            catch (CoreException coreException) {}
        }
        return this.debugModelPresentation.getImage(element);
    }

    public void dispose() {
        this.builderImage.dispose();
        this.invalidBuildToolImage.dispose();
    }
}

