/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyDataDecryptorFactoryBuilder {
    private static final int X25519_KEY_SIZE = 32;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private OperatorHelper contentHelper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadHelper = new JceAEADUtil(this.contentHelper);
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private JcaKeyFingerprintCalculator fingerprintCalculator = new JcaKeyFingerprintCalculator();

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.contentHelper = this.helper;
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.contentHelper = this.helper;
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(Provider provider) {
        this.contentHelper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    public JcePublicKeyDataDecryptorFactoryBuilder setContentProvider(String string) {
        this.contentHelper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.aeadHelper = new JceAEADUtil(this.contentHelper);
        return this;
    }

    private int getExpectedPayloadSize(PrivateKey privateKey) {
        if (privateKey instanceof DHKey) {
            DHKey dHKey = (DHKey)((Object)privateKey);
            return (dHKey.getParams().getP().bitLength() + 7) / 8;
        }
        if (privateKey instanceof RSAKey) {
            RSAKey rSAKey = (RSAKey)((Object)privateKey);
            return (rSAKey.getModulus().bitLength() + 7) / 8;
        }
        return -1;
    }

    public PublicKeyDataDecryptorFactory build(final PrivateKey privateKey) {
        return new PublicKeyDataDecryptorFactory(){
            final int expectedPayLoadSize;
            {
                this.expectedPayLoadSize = JcePublicKeyDataDecryptorFactoryBuilder.this.getExpectedPayloadSize(privateKey);
            }

            @Override
            public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
                if (n == 18) {
                    throw new PGPException("ECDH requires use of PGPPrivateKey for decryption");
                }
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, privateKey, this.expectedPayLoadSize, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
            }
        };
    }

    public PublicKeyDataDecryptorFactory build(final PGPPrivateKey pGPPrivateKey) {
        return new PublicKeyDataDecryptorFactory(){

            @Override
            public byte[] recoverSessionData(int n, byte[][] byArray) throws PGPException {
                if (n == 18) {
                    return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter, pGPPrivateKey, byArray);
                }
                PrivateKey privateKey = JcePublicKeyDataDecryptorFactoryBuilder.this.keyConverter.getPrivateKey(pGPPrivateKey);
                int n2 = JcePublicKeyDataDecryptorFactoryBuilder.this.getExpectedPayloadSize(privateKey);
                return JcePublicKeyDataDecryptorFactoryBuilder.this.decryptSessionData(n, privateKey, n2, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.contentHelper.createDataDecryptor(bl, n, byArray);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
            }

            @Override
            public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
                return JcePublicKeyDataDecryptorFactoryBuilder.this.aeadHelper.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
            }
        };
    }

    private byte[] decryptSessionData(JcaPGPKeyConverter jcaPGPKeyConverter, PGPPrivateKey pGPPrivateKey, byte[][] byArray) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
        byte[] byArray2 = byArray[0];
        int n = (((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF) + 7) / 8;
        if (2 + n + 1 > byArray2.length) {
            throw new PGPException("encoded length out of range");
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 2, byArray3, 0, n);
        int n2 = byArray2[n + 2] & 0xFF;
        if (2 + n + 1 + n2 > byArray2.length) {
            throw new PGPException("encoded length out of range");
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray2, 2 + n + 1, byArray4, 0, n2);
        try {
            Object object;
            PublicKey publicKey;
            Object object2;
            KeyAgreement keyAgreement;
            if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                keyAgreement = this.helper.createKeyAgreement(RFC6637Utils.getXDHAlgorithm(publicKeyPacket));
                object2 = this.helper.createKeyFactory("XDH");
                if (byArray3.length != 33 || 64 != byArray3[0]) {
                    throw new IllegalArgumentException("Invalid Curve25519 public key");
                }
                publicKey = object2.generatePublic(new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(EdECObjectIdentifiers.id_X25519), Arrays.copyOfRange((byte[])byArray3, (int)1, (int)byArray3.length)).getEncoded()));
            } else {
                object2 = ECNamedCurveTable.getByOIDLazy((ASN1ObjectIdentifier)eCDHPublicBCPGKey.getCurveOID());
                object = object2.getCurve().decodePoint(byArray3);
                keyAgreement = this.helper.createKeyAgreement(RFC6637Utils.getAgreementAlgorithm(publicKeyPacket));
                publicKey = jcaPGPKeyConverter.getPublicKey(new PGPPublicKey(new PublicKeyPacket(18, new Date(), new ECDHPublicBCPGKey(eCDHPublicBCPGKey.getCurveOID(), (ECPoint)object, (int)eCDHPublicBCPGKey.getHashAlgorithm(), (int)eCDHPublicBCPGKey.getSymmetricKeyAlgorithm())), this.fingerprintCalculator));
            }
            object2 = RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, this.fingerprintCalculator);
            object = jcaPGPKeyConverter.getPrivateKey(pGPPrivateKey);
            keyAgreement.init((Key)object, (AlgorithmParameterSpec)new UserKeyingMaterialSpec((byte[])object2));
            keyAgreement.doPhase(publicKey, true);
            SecretKey secretKey = keyAgreement.generateSecret(RFC6637Utils.getKeyEncryptionOID(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm()).getId());
            Cipher cipher = this.helper.createKeyWrapper(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            cipher.init(4, secretKey);
            Key key = cipher.unwrap(byArray4, "Session", 3);
            return PGPPad.unpadSessionData(key.getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PGPException("error setting asymmetric cipher", noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PGPException("error setting asymmetric cipher", invalidAlgorithmParameterException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("error setting asymmetric cipher", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new PGPException("error setting asymmetric cipher", iOException);
        }
    }

    private void updateWithMPI(Cipher cipher, int n, byte[] byArray) {
        if (n > 0) {
            if (byArray.length - 2 > n) {
                cipher.update(byArray, 3, byArray.length - 3);
            } else {
                if (n > byArray.length - 2) {
                    cipher.update(new byte[n - (byArray.length - 2)]);
                }
                cipher.update(byArray, 2, byArray.length - 2);
            }
        } else {
            cipher.update(byArray, 2, byArray.length - 2);
        }
    }

    private byte[] decryptSessionData(int n, PrivateKey privateKey, int n2, byte[][] byArray) throws PGPException {
        Cipher cipher = this.helper.createPublicKeyCipher(n);
        try {
            cipher.init(2, privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("error setting asymmetric cipher", invalidKeyException);
        }
        if (n == 2 || n == 1) {
            this.updateWithMPI(cipher, n2, byArray[0]);
        } else {
            this.updateWithMPI(cipher, n2, byArray[0]);
            this.updateWithMPI(cipher, n2, byArray[1]);
        }
        try {
            return cipher.doFinal();
        }
        catch (Exception exception) {
            throw new PGPException("exception decrypting session data", exception);
        }
    }
}

