/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class IOConsolePartition
implements ITypedRegion {
    public static final String OUTPUT_PARTITION_TYPE = ConsolePlugin.getUniqueIdentifier() + ".io_console_output_partition_type";
    public static final String INPUT_PARTITION_TYPE = ConsolePlugin.getUniqueIdentifier() + ".io_console_input_partition_type";
    private int offset;
    private int length;
    private final String type;
    private boolean readOnly;
    private IOConsoleOutputStream outputStream;
    private IOConsoleInputStream inputStream;

    public IOConsolePartition(int offset, IOConsoleOutputStream outputStream) {
        this.outputStream = outputStream;
        this.offset = offset;
        this.type = OUTPUT_PARTITION_TYPE;
        this.readOnly = true;
    }

    public IOConsolePartition(int offset, IOConsoleInputStream inputStream) {
        this.inputStream = inputStream;
        this.offset = offset;
        this.type = INPUT_PARTITION_TYPE;
        this.readOnly = false;
    }

    @Deprecated
    public IOConsolePartition(IOConsoleOutputStream outputStream, int length) {
        this(0, outputStream);
        this.setLength(length);
    }

    @Deprecated
    public IOConsolePartition(IOConsoleInputStream inputStream, String text) {
        this(0, inputStream);
        this.setLength(text == null ? 0 : text.length());
    }

    public String getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public StyleRange getStyleRange(int rangeOffset, int rangeLength) {
        return new StyleRange(rangeOffset, rangeLength, this.getColor(), null, this.getFontStyle());
    }

    private int getFontStyle() {
        if (this.type.equals(INPUT_PARTITION_TYPE)) {
            return this.inputStream != null ? this.inputStream.getFontStyle() : 0;
        }
        return this.outputStream.getFontStyle();
    }

    public Color getColor() {
        if (this.type.equals(INPUT_PARTITION_TYPE)) {
            return this.inputStream != null ? this.inputStream.getColor() : null;
        }
        return this.outputStream.getColor();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    @Deprecated
    IOConsoleOutputStream getStream() {
        return this.outputStream;
    }

    IOConsoleOutputStream getOutputStream() {
        return this.outputStream;
    }

    IOConsoleInputStream getInputStream() {
        return this.inputStream;
    }

    boolean belongsTo(IOConsoleInputStream in) {
        return this.inputStream == in;
    }

    boolean belongsTo(IOConsoleOutputStream out) {
        return this.outputStream == out;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append(INPUT_PARTITION_TYPE.equals(this.type) ? "[Input" : "[Output");
        if (!this.readOnly) {
            sb.append("+");
        }
        sb.append("]");
        sb.append(" Offset: ");
        sb.append(this.offset);
        sb.append(" Length: ");
        sb.append(this.length);
        return sb.toString();
    }
}

