/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.events;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.core.filter.ITmfFilter;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterRootNode;

public class TmfEventsTableHeader
extends Composite {
    private static final Image COLLAPSED = Activator.getDefault().getImageFromPath("icons/ovr16/collapsed_ovr.gif");
    private static final Image EXPANDED = Activator.getDefault().getImageFromPath("icons/ovr16/expanded_ovr.gif");
    private static final Image DELETE = Activator.getDefault().getImageFromPath("icons/elcl16/delete_button.gif");
    private static final Image DELETE_SMALL = Activator.getDefault().getImageFromPath("icons/ovr16/delete_ovr.gif");
    private static final int DEFAULT_MARGIN = 3;
    private static final int COLLAPSED_IMAGE_MARGIN = 2;
    private static final int COLLAPSED_RIGHT_MARGIN = 32;
    private static final RGB LABEL_BACKGROUND = new RGB(255, 255, 192);
    private static final String TOOLTIP_KEY = "toolTip";
    private final IEventsTableHeaderListener fListener;
    private final RowLayout fLayout;
    private final Color fLabelBackground;
    private boolean fCollapsed = false;

    public TmfEventsTableHeader(Composite parent, int style, IEventsTableHeaderListener listener) {
        super(parent, style);
        this.fListener = listener;
        this.fLayout = new RowLayout();
        this.fLayout.marginTop = 0;
        this.fLayout.marginBottom = 0;
        this.fLayout.marginLeft = TmfEventsTableHeader.EXPANDED.getBounds().width;
        this.setLayout((Layout)this.fLayout);
        this.fLabelBackground = new Color((Device)this.getDisplay(), LABEL_BACKGROUND);
        this.getParent().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TmfEventsTableHeader.this.getParent().layout();
            }
        });
        this.addPaintListener(e -> {
            if (this.fCollapsed) {
                e.gc.drawImage(COLLAPSED, 0, 0);
            } else {
                e.gc.drawImage(EXPANDED, 0, 0);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TmfEventsTableHeader.this.toggle();
            }
        });
        this.addDisposeListener(e -> this.fLabelBackground.dispose());
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height = this.fCollapsed && this.getChildren().length > 0 ? TmfEventsTableHeader.EXPANDED.getBounds().height : hHint;
        return super.computeSize(this.getParent().getSize().x, height, changed);
    }

    public void addFilter(ITmfFilter filter) {
        if (filter instanceof TmfFilterRootNode) {
            TmfFilterRootNode parentFilter = (TmfFilterRootNode)filter;
            ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = parentFilter.getChildren();
            int n = iTmfFilterTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITmfFilterTreeNode childFilter = iTmfFilterTreeNodeArray[n2];
                this.addNewFilter((ITmfFilter)childFilter);
                ++n2;
            }
        } else {
            this.addNewFilter(filter);
        }
        this.fLayout.marginTop = 1;
        this.fLayout.marginBottom = 1;
        this.getParent().layout(true, true);
    }

    public void removeFilter(ITmfFilter filter) {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (filter.equals(control.getData())) {
                control.dispose();
                break;
            }
            ++n2;
        }
        if (this.getChildren().length == 0) {
            this.fLayout.marginTop = 0;
            this.fLayout.marginBottom = 0;
        }
        this.getParent().layout(true, true);
    }

    public void clearFilters() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.fLayout.marginTop = 0;
        this.fLayout.marginBottom = 0;
        this.getParent().layout(true, true);
    }

    private void addNewFilter(ITmfFilter filter) {
        String text;
        final CLabel label = new CLabel((Composite)this, 8);
        label.setBackground(this.fLabelBackground);
        if (filter instanceof TmfFilterNode) {
            text = ((TmfFilterNode)filter).getFilterName();
            label.setData(TOOLTIP_KEY, (Object)filter.toString());
        } else {
            text = filter.toString();
        }
        if (this.fCollapsed) {
            label.setToolTipText(text);
            label.setTopMargin(0);
            label.setBottomMargin(0);
            label.setRightMargin(32);
        } else {
            label.setImage(DELETE);
            label.setText(text);
            label.setToolTipText((String)label.getData(TOOLTIP_KEY));
        }
        label.setData((Object)filter);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Rectangle bounds;
                if (TmfEventsTableHeader.this.fCollapsed) {
                    bounds = new Rectangle(0, 0, 4 + TmfEventsTableHeader.DELETE_SMALL.getBounds().width, label.getBounds().height);
                } else {
                    bounds = DELETE.getBounds();
                    bounds.x += label.getLeftMargin();
                    bounds.y = (label.getSize().y - bounds.height) / 2;
                }
                if (bounds.contains(e.x, e.y)) {
                    TmfEventsTableHeader.this.fListener.filterRemoved((ITmfFilter)label.getData());
                } else {
                    TmfEventsTableHeader.this.fListener.filterSelected((ITmfFilter)label.getData());
                    TmfEventsTableHeader.this.getParent().layout(true, true);
                }
            }
        });
        label.addPaintListener(e -> {
            if (this.fCollapsed) {
                e.gc.drawImage(DELETE_SMALL, 2, 2);
            }
        });
    }

    private void toggle() {
        this.fCollapsed = !this.fCollapsed;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CLabel) {
                CLabel label = (CLabel)child;
                if (this.fCollapsed) {
                    label.setImage(null);
                    label.setToolTipText(label.getText());
                    label.setText(null);
                    label.setMargins(3, 0, 32, 0);
                } else {
                    label.setImage(DELETE);
                    label.setText(label.getToolTipText());
                    label.setToolTipText((String)label.getData(TOOLTIP_KEY));
                    label.setMargins(3, 3, 3, 3);
                }
            }
            ++n2;
        }
        this.getParent().layout();
    }

    public static interface IEventsTableHeaderListener {
        public void filterSelected(ITmfFilter var1);

        public void filterRemoved(ITmfFilter var1);
    }
}

