/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xychart;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfBaseProvider;

public class TmfSimpleTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener {
    private TmfAbstractToolTipHandler fTooltipHandler = new XYToolTipHandler();

    public TmfSimpleTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
    }

    @Override
    public TmfAbstractToolTipHandler getTooltipHandler() {
        return this.fTooltipHandler;
    }

    @Override
    public void refresh() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }

    private final class XYToolTipHandler
    extends TmfAbstractToolTipHandler {
        private XYToolTipHandler() {
        }

        @Override
        public void fill(Control control, MouseEvent event, Point pt) {
            IAxis xAxis = TmfSimpleTooltipProvider.this.getXAxis();
            IAxis yAxis = TmfSimpleTooltipProvider.this.getYAxis();
            double xCoordinate = xAxis.getDataCoordinate(pt.x);
            double yCoordinate = yAxis.getDataCoordinate(pt.y);
            ITmfChartTimeProvider viewer = TmfSimpleTooltipProvider.this.getChartViewer();
            ITmfTimestamp time = TmfTimestamp.fromNanos((long)((long)xCoordinate + viewer.getTimeOffset()));
            this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromString("x"), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(time.toString(), time.toNanos()));
            this.addItem(null, "y", Double.toString(yCoordinate));
        }
    }
}

