/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class NamedTimeEvent
extends TimeEvent {
    private final @NonNull String fLabel;

    public NamedTimeEvent(ITimeGraphEntry entry, long time, long duration, int value, @NonNull String label) {
        super(entry, time, duration, value);
        this.fLabel = label.intern();
    }

    public NamedTimeEvent(TimeGraphEntry entry, long time, long duration, int value, String label, int activeProperties) {
        super(entry, time, duration, value, activeProperties);
        this.fLabel = label.intern();
    }

    public NamedTimeEvent(ITimeGraphEntry entry, String label, ITimeGraphState stateModel) {
        super(entry, (ITimeElement)stateModel);
        this.fLabel = label.intern();
    }

    @Override
    public @NonNull String getLabel() {
        return this.fLabel;
    }

    @Override
    @Deprecated
    public @NonNull Map<@NonNull String, @NonNull String> computeData() {
        Map<@NonNull String, @NonNull String> data = super.computeData();
        data.put("label", this.getLabel());
        return data;
    }

    @Override
    public @NonNull Multimap<@NonNull String, @NonNull Object> getMetadata() {
        Multimap<@NonNull String, @NonNull Object> metadata = super.getMetadata();
        String entryName = this.getEntry().getName();
        if (entryName == null) {
            return metadata;
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.getMetadata());
        builder.put((Object)"entry", (Object)entryName);
        return builder.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NamedTimeEvent) {
            return super.equals(obj) && Objects.equals(this.fLabel, ((NamedTimeEvent)obj).fLabel);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fLabel);
    }
}

