/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.extensions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;

public abstract class RegistryReader {
    protected static final String TAG_DESCRIPTION = "description";
    private boolean isInitialized;
    private final String extensionPointId;
    private final String pluginId;
    private final IExtensionRegistry registry = Platform.getExtensionRegistry();

    protected RegistryReader(String aPluginId, String anExtensionPoint) {
        this.pluginId = aPluginId;
        this.extensionPointId = anExtensionPoint;
    }

    protected String getDescription(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    protected static void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuilder buf = new StringBuilder();
        buf.append("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        buf.append("\n" + text);
        NavigatorPlugin.logError(0, buf.toString(), null);
    }

    protected static void logMissingAttribute(IConfigurationElement element, String attributeName) {
        RegistryReader.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected static void logMissingElement(IConfigurationElement element, String elementName) {
        RegistryReader.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected static void logUnknownElement(IConfigurationElement element) {
        RegistryReader.logError(element, "Unknown extension tag found: " + element.getName());
    }

    protected IExtension[] orderExtensions(IExtension[] extensions) {
        IExtension[] sortedExtension = new IExtension[extensions.length];
        System.arraycopy(extensions, 0, sortedExtension, 0, extensions.length);
        Comparator comparer = (arg0, arg1) -> {
            String s1 = arg0.getContributor().getName();
            String s2 = arg1.getContributor().getName();
            return s1.compareToIgnoreCase(s2);
        };
        Collections.sort(Arrays.asList(sortedExtension), comparer);
        return sortedExtension;
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (!this.readElement(element)) {
                RegistryReader.logUnknownElement(element);
            }
            ++n2;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRegistry() {
        if (this.isInitialized) {
            return;
        }
        RegistryReader registryReader = this;
        synchronized (registryReader) {
            if (!this.isInitialized) {
                IExtensionPoint point = this.registry.getExtensionPoint(this.pluginId, this.extensionPointId);
                if (point == null) {
                    return;
                }
                IExtension[] extensions = point.getExtensions();
                IExtension[] iExtensionArray = extensions = this.orderExtensions(extensions);
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    this.readExtension(extension);
                    ++n2;
                }
                this.isInitialized = true;
            }
        }
    }
}

