/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.stringsubstitution;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.stringsubstitution.IArgumentSelector;

public class StringVariablePresentationManager {
    public static final String EXTENSION_POINT_STRING_VARIABLE_PRESENTATIONS = "stringVariablePresentations";
    private static StringVariablePresentationManager fgManager;
    public static final String ATTR_NAME = "variableName";
    public static final String ATTR_ARGUMENT_SELECTOR = "argumentSelector";
    private Map<String, IConfigurationElement> fConfigurations;

    public static StringVariablePresentationManager getDefault() {
        if (fgManager == null) {
            fgManager = new StringVariablePresentationManager();
        }
        return fgManager;
    }

    public IArgumentSelector getArgumentSelector(IStringVariable variable) {
        IConfigurationElement element = this.fConfigurations.get(variable.getName());
        if (element != null) {
            try {
                return (IArgumentSelector)element.createExecutableExtension(ATTR_ARGUMENT_SELECTOR);
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    private StringVariablePresentationManager() {
        this.initialize();
    }

    private void initialize() {
        this.fConfigurations = new HashMap<String, IConfigurationElement>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(DebugUIPlugin.getUniqueIdentifier(), EXTENSION_POINT_STRING_VARIABLE_PRESENTATIONS);
        IConfigurationElement[] elements = point.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            String name = element.getAttribute(ATTR_NAME);
            if (name == null) {
                DebugUIPlugin.logErrorMessage(MessageFormat.format((String)"String variable presentation extension missing required 'variableName' attribute: {0}", (Object[])new Object[]{element.getDeclaringExtension().getLabel()}));
            } else {
                this.fConfigurations.put(name, element);
            }
            ++i;
        }
    }
}

