/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecutionOwner;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecDeclarationStatement;

public class CPPASTDeclarationStatement
extends ASTNode
implements IASTDeclarationStatement,
IASTAmbiguityParent,
ICPPExecutionOwner {
    private IASTDeclaration declaration;

    public CPPASTDeclarationStatement() {
    }

    public CPPASTDeclarationStatement(IASTDeclaration declaration) {
        this.setDeclaration(declaration);
    }

    @Override
    public CPPASTDeclarationStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTDeclarationStatement copy(IASTNode.CopyStyle style) {
        CPPASTDeclarationStatement copy = new CPPASTDeclarationStatement();
        copy.setDeclaration(this.declaration == null ? null : this.declaration.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTDeclaration getDeclaration() {
        return this.declaration;
    }

    @Override
    public void setDeclaration(IASTDeclaration declaration) {
        this.assertNotFrozen();
        this.declaration = declaration;
        if (declaration != null) {
            declaration.setParent(this);
            declaration.setPropertyInParent(DECLARATION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.declaration != null && !this.declaration.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.declaration == child) {
            other.setParent(child.getParent());
            other.setPropertyInParent(child.getPropertyInParent());
            this.declaration = (IASTDeclaration)other;
        }
    }

    @Override
    public IASTAttribute[] getAttributes() {
        return IASTAttribute.EMPTY_ATTRIBUTE_ARRAY;
    }

    @Override
    public void addAttribute(IASTAttribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IASTAttributeSpecifier[] getAttributeSpecifiers() {
        return IASTAttributeSpecifier.EMPTY_ATTRIBUTE_SPECIFIER_ARRAY;
    }

    @Override
    public void addAttributeSpecifier(IASTAttributeSpecifier attributeSpecifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICPPExecution getExecution() {
        if (this.declaration instanceof ICPPExecutionOwner) {
            ICPPExecutionOwner execOwner = (ICPPExecutionOwner)((Object)this.declaration);
            return new ExecDeclarationStatement(execOwner.getExecution());
        }
        return null;
    }
}

