/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.timegraph;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

class TimeGraphFindDialog
extends Dialog {
    private static final int HISTORY_SIZE = 5;
    private final String WRAP = "wrap";
    private final String CASE_SENSITIVE = "casesensitive";
    private final String WHOLE_WORD = "wholeword";
    private final String IS_REGEX_EXPRESSION = "isRegEx";
    private final String FIND_HISTORY = "findhistory";
    private boolean fWrapInit;
    private boolean fCaseInit;
    private boolean fWholeWordInit;
    private boolean fForwardInit;
    private boolean fIsRegExInit;
    private @NonNull List<String> fFindHistory;
    private static Shell fParentShell;
    private Shell fActiveShell;
    private final ActivationListener fActivationListener = new ActivationListener();
    private final FindModifyListener fFindModifyListener = new FindModifyListener();
    private Label fStatusLabel;
    private Button fForwardRadioButton;
    private Button fCaseCheckBox;
    private Button fWrapCheckBox;
    private Button fWholeWordCheckBox;
    private Button fIsRegExCheckBox;
    private Button fFindNextButton;
    private Combo fFindField;
    private ContentAssistCommandAdapter fContentAssistFindField;
    private Rectangle fDialogPositionInit;
    private IDialogSettings fDialogSettings;
    private boolean fGiveFocusToFindField = true;
    private HashMap<Character, Button> fMnemonicButtonMap = new HashMap();
    private @Nullable AbstractTimeGraphView.FindTarget fFindTarget;

    public TimeGraphFindDialog(Shell parentShell) {
        super(parentShell);
        fParentShell = null;
        this.fFindTarget = null;
        this.fDialogPositionInit = null;
        this.fFindHistory = new ArrayList<String>(4);
        this.fWrapInit = true;
        this.fCaseInit = false;
        this.fIsRegExInit = false;
        this.fWholeWordInit = false;
        this.fForwardInit = true;
        this.readConfiguration();
        this.setShellStyle(this.getShellStyle() & 0xFFFEFFFF);
        this.setBlockOnOpen(false);
    }

    protected boolean isResizable() {
        return true;
    }

    private static boolean okToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public void create() {
        super.create();
        Shell shell = this.getShell();
        shell.addShellListener((ShellListener)this.fActivationListener);
        this.fFindField.removeModifyListener((ModifyListener)this.fFindModifyListener);
        TimeGraphFindDialog.updateCombo(this.fFindField, this.fFindHistory);
        this.fFindField.addModifyListener((ModifyListener)this.fFindModifyListener);
        this.initFindStringFromSelection();
        shell.setMinimumSize(shell.getSize());
        if (this.fDialogPositionInit != null) {
            shell.setBounds(this.fDialogPositionInit);
        }
        shell.setText(Messages.TimeGraphFindDialog_FindTitle);
    }

    private Composite createConfigPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        panel.setLayout((Layout)layout);
        Composite directionGroup = this.createDirectionGroup(panel);
        TimeGraphFindDialog.setGridData((Control)directionGroup, 4, true, 4, false);
        Composite optionsGroup = this.createOptionsGroup(panel);
        TimeGraphFindDialog.setGridData((Control)optionsGroup, 4, true, 4, true);
        ((GridData)optionsGroup.getLayoutData()).horizontalSpan = 2;
        return panel;
    }

    protected Control createContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite inputPanel = this.createInputPanel(panel);
        TimeGraphFindDialog.setGridData((Control)inputPanel, 4, true, 128, false);
        Composite configPanel = this.createConfigPanel(panel);
        TimeGraphFindDialog.setGridData((Control)configPanel, 4, true, 128, true);
        Composite statusBar = this.createStatusAndCloseButton(panel);
        TimeGraphFindDialog.setGridData((Control)statusBar, 4, true, 1024, false);
        panel.addTraverseListener(e -> {
            Character mnemonic;
            Button button;
            if (e.detail == 4) {
                Control controlWithFocus;
                if (!Util.isMac() && (controlWithFocus = this.getShell().getDisplay().getFocusControl()) != null && (controlWithFocus.getStyle() & 8) == 8) {
                    return;
                }
                Event event1 = new Event();
                event1.type = 13;
                event1.stateMask = e.stateMask;
                this.fFindNextButton.notifyListeners(13, event1);
                e.doit = false;
            } else if (e.detail == 128 && (button = this.fMnemonicButtonMap.get(mnemonic = new Character(Character.toLowerCase(e.character)))) != null && (this.fFindField.isFocusControl() || (button.getStyle() & 8) != 0) && button.isEnabled()) {
                Event event2 = new Event();
                event2.type = 13;
                event2.stateMask = e.stateMask;
                if ((button.getStyle() & 0x10) != 0) {
                    Composite buttonParent = button.getParent();
                    if (buttonParent != null) {
                        Control[] children = buttonParent.getChildren();
                        int i = 0;
                        while (i < children.length) {
                            ((Button)children[i]).setSelection(false);
                            ++i;
                        }
                    }
                    button.setSelection(true);
                } else {
                    button.setSelection(!button.getSelection());
                }
                button.notifyListeners(13, event2);
                e.detail = 0;
                e.doit = true;
            }
        });
        this.updateButtonState();
        TimeGraphFindDialog.applyDialogFont((Control)panel);
        return panel;
    }

    private void setContentAssistsEnablement(boolean enable) {
        this.fContentAssistFindField.setEnabled(enable);
    }

    private Composite createDirectionGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 16);
        group.setText(Messages.TimeGraphFindDialog_Direction);
        GridLayout groupLayout = new GridLayout();
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fForwardRadioButton = new Button((Composite)group, 16400);
        this.fForwardRadioButton.setText(Messages.TimeGraphFindDialog_ForwardRadioButtonLabel);
        TimeGraphFindDialog.setGridData((Control)this.fForwardRadioButton, 16384, false, 0x1000000, false);
        this.storeButtonWithMnemonicInMap(this.fForwardRadioButton);
        Button backwardRadioButton = new Button((Composite)group, 16400);
        backwardRadioButton.setText(Messages.TimeGraphFindDialog_BackwardRadioButtonLabel);
        TimeGraphFindDialog.setGridData((Control)backwardRadioButton, 16384, false, 0x1000000, false);
        this.storeButtonWithMnemonicInMap(backwardRadioButton);
        backwardRadioButton.setSelection(!this.fForwardInit);
        this.fForwardRadioButton.setSelection(this.fForwardInit);
        return panel;
    }

    private Composite createInputPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label findLabel = new Label(panel, 16384);
        findLabel.setText(Messages.TimeGraphFindDialog_FindLabel);
        TimeGraphFindDialog.setGridData((Control)findLabel, 16384, false, 0x1000000, false);
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider findProposer = new FindReplaceDocumentAdapterContentProposalProvider(true);
        this.fFindField = new Combo(panel, 2052);
        this.fContentAssistFindField = new ContentAssistCommandAdapter((Control)this.fFindField, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)findProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0], true);
        TimeGraphFindDialog.setGridData((Control)this.fFindField, 4, true, 0x1000000, false);
        this.fFindField.addModifyListener((ModifyListener)this.fFindModifyListener);
        return panel;
    }

    private Composite createOptionsGroup(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        Group group = new Group(panel, 32);
        group.setText(Messages.TimeGraphFindDialog_Options);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 1;
        groupLayout.makeColumnsEqualWidth = true;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TimeGraphFindDialog.this.storeSettings();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.fCaseCheckBox = new Button((Composite)group, 16416);
        this.fCaseCheckBox.setText(Messages.TimeGraphFindDialog_CaseCheckBoxLabel);
        TimeGraphFindDialog.setGridData((Control)this.fCaseCheckBox, 16384, false, 0x1000000, false);
        this.fCaseCheckBox.setSelection(this.fCaseInit);
        this.fCaseCheckBox.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(this.fCaseCheckBox);
        this.fWrapCheckBox = new Button((Composite)group, 16416);
        this.fWrapCheckBox.setText(Messages.TimeGraphFindDialog_WrapCheckBoxLabel);
        TimeGraphFindDialog.setGridData((Control)this.fWrapCheckBox, 16384, false, 0x1000000, false);
        this.fWrapCheckBox.setSelection(this.fWrapInit);
        this.fWrapCheckBox.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(this.fWrapCheckBox);
        this.fWholeWordCheckBox = new Button((Composite)group, 16416);
        this.fWholeWordCheckBox.setText(Messages.TimeGraphFindDialog_WholeWordCheckBoxLabel);
        TimeGraphFindDialog.setGridData((Control)this.fWholeWordCheckBox, 16384, false, 0x1000000, false);
        this.fWholeWordCheckBox.setSelection(this.fWholeWordInit);
        this.fWholeWordCheckBox.addSelectionListener(selectionListener);
        this.storeButtonWithMnemonicInMap(this.fWholeWordCheckBox);
        this.fIsRegExCheckBox = new Button((Composite)group, 16416);
        this.fIsRegExCheckBox.setText(Messages.TimeGraphFindDialog_REgExCheckBoxLabel);
        TimeGraphFindDialog.setGridData((Control)this.fIsRegExCheckBox, 16384, false, 0x1000000, false);
        ((GridData)this.fIsRegExCheckBox.getLayoutData()).horizontalSpan = 2;
        this.fIsRegExCheckBox.setSelection(this.fIsRegExInit);
        this.fIsRegExCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newState = TimeGraphFindDialog.this.fIsRegExCheckBox.getSelection();
                TimeGraphFindDialog.this.updateButtonState();
                TimeGraphFindDialog.this.storeSettings();
                TimeGraphFindDialog.this.setContentAssistsEnablement(newState);
            }
        });
        this.storeButtonWithMnemonicInMap(this.fIsRegExCheckBox);
        this.fWholeWordCheckBox.setEnabled(!this.isRegExSearch());
        this.fWholeWordCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeGraphFindDialog.this.updateButtonState();
            }
        });
        return panel;
    }

    private Composite createStatusAndCloseButton(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        panel.setLayout((Layout)layout);
        this.fStatusLabel = new Label(panel, 16384);
        this.fStatusLabel.setText(Messages.TimeGraphFindDialog_StatusWrappedLabel);
        TimeGraphFindDialog.setGridData((Control)this.fStatusLabel, 4, true, 0x1000000, false);
        GridData gd = (GridData)this.fStatusLabel.getLayoutData();
        gd.widthHint = this.fStatusLabel.computeSize((int)-1, (int)-1).x;
        this.fStatusLabel.setText("");
        Composite buttonSection = new Composite(panel, 0);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 2;
        buttonSection.setLayout((Layout)buttonLayout);
        String label = Messages.TimeGraphFindDialog_CloseButtonLabel;
        Button closeButton = this.createButton(buttonSection, 101, label, false);
        TimeGraphFindDialog.setGridData((Control)closeButton, 131072, false, 1024, false);
        this.fFindNextButton = this.makeButton(buttonSection, Messages.TimeGraphFindDialog_FindNextButtonLabel, 102, true, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TimeGraphFindDialog.this.performSearch((e.stateMask & 0x20000) != 0 ^ TimeGraphFindDialog.this.isForwardSearch());
                TimeGraphFindDialog.this.updateFindHistory();
            }
        });
        TimeGraphFindDialog.setGridData((Control)this.fFindNextButton, 4, true, 4, false);
        return panel;
    }

    protected void buttonPressed(int buttonID) {
        if (buttonID == 101) {
            this.close();
        }
    }

    public void update(@NonNull AbstractTimeGraphView.FindTarget findTarget) {
        this.updateTarget(findTarget, true);
    }

    private int findNext(String findString, int startIndex, BiMap<ITimeGraphEntry, Integer> items, SearchOptions options) {
        int index;
        if (options.forwardSearch) {
            index = startIndex == items.size() - 1 ? -1 : this.findNext(startIndex + 1, findString, items, options);
        } else {
            int n = index = startIndex == 0 ? -1 : this.findNext(startIndex - 1, findString, items, options);
        }
        if (index == -1) {
            if (TimeGraphFindDialog.okToUse((Control)this.getShell())) {
                this.getShell().getDisplay().beep();
            }
            if (options.wrapSearch) {
                this.statusMessage(Messages.TimeGraphFindDialog_StatusWrappedLabel);
                index = this.findNext(-1, findString, items, options);
            }
        }
        return index;
    }

    private int findNext(int startIndex, String findString, BiMap<ITimeGraphEntry, Integer> items, SearchOptions options) {
        AbstractTimeGraphView.FindTarget findTarget = this.fFindTarget;
        if (findTarget != null) {
            if (findString == null || findString.length() == 0) {
                return -1;
            }
            @NonNull Pattern pattern = TimeGraphFindDialog.getPattern(findString, options);
            int index = TimeGraphFindDialog.adjustIndex(startIndex, items.size(), options.forwardSearch);
            BiMap entries = items.inverse();
            while (index >= 0 && index < entries.size()) {
                @Nullable ITimeGraphEntry entry = (ITimeGraphEntry)entries.get((Object)index);
                if (entry != null) {
                    String[] columnTexts = findTarget.getColumnTexts(entry);
                    int i = 0;
                    while (i < columnTexts.length) {
                        String columnText = columnTexts[i];
                        if (columnText != null && !columnText.isEmpty() && pattern.matcher(columnTexts[i]).find()) {
                            return index;
                        }
                        ++i;
                    }
                }
                int n = index = options.forwardSearch ? ++index : --index;
            }
        }
        return -1;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean findAndSelect(String findString, SearchOptions options) {
        AbstractTimeGraphView.FindTarget findTarget = this.fFindTarget;
        if (findTarget == null) {
            return false;
        }
        ITimeGraphEntry[] topInput = findTarget.getEntries();
        @NonNull @NonNull HashBiMap items = HashBiMap.create();
        ITimeGraphEntry[] iTimeGraphEntryArray = topInput;
        int n = topInput.length;
        int n2 = 0;
        while (n2 < n) {
            ITimeGraphEntry entry = iTimeGraphEntryArray[n2];
            this.listEntries((Map<ITimeGraphEntry, Integer>)items, entry);
            ++n2;
        }
        int startPosition = findTarget.getSelection() == null ? 0 : (Integer)NonNullUtils.checkNotNull((Object)((Integer)items.get((Object)findTarget.getSelection())));
        int index = this.findNext(findString, startPosition, (BiMap<ITimeGraphEntry, Integer>)items, options);
        if (index == -1) {
            this.statusMessage(Messages.TimeGraphFindDialog_StatusNoMatchLabel);
            return false;
        }
        if (options.forwardSearch && index >= startPosition || !options.forwardSearch && index <= startPosition) {
            this.statusMessage("");
        }
        findTarget.selectAndReveal((ITimeGraphEntry)NonNullUtils.checkNotNull((Object)((ITimeGraphEntry)items.inverse().get((Object)index))));
        return true;
    }

    private void listEntries(Map<ITimeGraphEntry, Integer> items, ITimeGraphEntry root) {
        items.put(root, items.size());
        for (ITimeGraphEntry iTimeGraphEntry : root.getChildren()) {
            this.listEntries(items, iTimeGraphEntry);
        }
    }

    private String getFindString() {
        if (TimeGraphFindDialog.okToUse((Control)this.fFindField)) {
            return this.fFindField.getText();
        }
        return "";
    }

    private Rectangle getDialogBoundaries() {
        if (TimeGraphFindDialog.okToUse((Control)this.getShell())) {
            return this.getShell().getBounds();
        }
        return this.fDialogPositionInit;
    }

    public boolean close() {
        this.handleDialogClose();
        return super.close();
    }

    private void handleDialogClose() {
        if (TimeGraphFindDialog.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener((ModifyListener)this.fFindModifyListener);
        }
        this.updateTarget(null, false);
        if (fParentShell != null) {
            fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            fParentShell = null;
        }
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().removeShellListener((ShellListener)this.fActivationListener);
        }
        this.storeSettings();
        this.fActiveShell = null;
    }

    private void writeSelection() {
        AbstractTimeGraphView.FindTarget input = this.fFindTarget;
        if (input == null) {
            return;
        }
        IDialogSettings s = this.getDialogSettings();
        ITimeGraphEntry selection = input.getSelection();
        if (selection != null) {
            s.put("selection", selection.getName());
        }
    }

    private void storeSettings() {
        this.fDialogPositionInit = this.getDialogBoundaries();
        this.fWrapInit = this.isWrapSearch();
        this.fWholeWordInit = this.isWholeWordSetting();
        this.fCaseInit = this.isCaseSensitiveSearch();
        this.fIsRegExInit = this.isRegExSearch();
        this.fForwardInit = this.isForwardSearch();
        this.writeConfiguration();
    }

    private void initFindStringFromSelection() {
        AbstractTimeGraphView.FindTarget findTarget = this.fFindTarget;
        if (findTarget != null && TimeGraphFindDialog.okToUse((Control)this.fFindField)) {
            ITimeGraphEntry selection = findTarget.getSelection();
            if (selection != null) {
                String fullSelection = selection.getName();
                this.fFindField.removeModifyListener((ModifyListener)this.fFindModifyListener);
                if (fullSelection.length() > 0) {
                    this.fFindField.setText(fullSelection);
                }
            } else if ("".equals(this.fFindField.getText())) {
                if (!this.fFindHistory.isEmpty()) {
                    this.fFindField.setText(this.fFindHistory.get(0));
                } else {
                    this.fFindField.setText("");
                }
            }
            this.fFindField.setSelection(new Point(0, this.fFindField.getText().length()));
            this.fFindField.addModifyListener((ModifyListener)this.fFindModifyListener);
        }
    }

    private boolean isCaseSensitiveSearch() {
        if (TimeGraphFindDialog.okToUse((Control)this.fCaseCheckBox)) {
            return this.fCaseCheckBox.getSelection();
        }
        return this.fCaseInit;
    }

    private boolean isRegExSearch() {
        if (TimeGraphFindDialog.okToUse((Control)this.fIsRegExCheckBox)) {
            return this.fIsRegExCheckBox.getSelection();
        }
        return this.fIsRegExInit;
    }

    private boolean isForwardSearch() {
        if (TimeGraphFindDialog.okToUse((Control)this.fForwardRadioButton)) {
            return this.fForwardRadioButton.getSelection();
        }
        return this.fForwardInit;
    }

    private boolean isWholeWordSetting() {
        if (TimeGraphFindDialog.okToUse((Control)this.fWholeWordCheckBox)) {
            return this.fWholeWordCheckBox.getSelection();
        }
        return this.fWholeWordInit;
    }

    private boolean isWholeWordSearch() {
        return this.isWholeWordSetting() && !this.isRegExSearch() && (!TimeGraphFindDialog.okToUse((Control)this.fWholeWordCheckBox) || this.fWholeWordCheckBox.isEnabled());
    }

    private boolean isWrapSearch() {
        if (TimeGraphFindDialog.okToUse((Control)this.fWrapCheckBox)) {
            return this.fWrapCheckBox.getSelection();
        }
        return this.fWrapInit;
    }

    private Button makeButton(Composite parent, String label, int id, boolean dfltButton, SelectionListener listener) {
        Button button = this.createButton(parent, id, label, dfltButton);
        button.addSelectionListener(listener);
        this.storeButtonWithMnemonicInMap(button);
        return button;
    }

    private void storeButtonWithMnemonicInMap(Button button) {
        char mnemonic = LegacyActionTools.extractMnemonic((String)button.getText());
        if (mnemonic != '\u0000') {
            this.fMnemonicButtonMap.put(new Character(Character.toLowerCase(mnemonic)), button);
        }
    }

    private void statusMessage(String message) {
        this.fStatusLabel.setText(message);
        this.getShell().getDisplay().beep();
    }

    private void performSearch(boolean forwardSearch) {
        String findString = this.getFindString();
        if (findString != null && findString.length() > 0) {
            this.findAndSelect(findString, this.getSearchOptions(forwardSearch));
        }
        this.writeSelection();
        this.updateButtonState();
    }

    private SearchOptions getSearchOptions(boolean forwardSearch) {
        SearchOptions options = new SearchOptions();
        options.forwardSearch = forwardSearch;
        options.caseSensitive = this.isCaseSensitiveSearch();
        options.wrapSearch = this.isWrapSearch();
        options.wholeWord = this.isWholeWordSearch();
        options.regExSearch = this.isRegExSearch();
        return options;
    }

    private static void setGridData(Control component, int horizontalAlignment, boolean grabExcessHorizontalSpace, int verticalAlignment, boolean grabExcessVerticalSpace) {
        GridData gd;
        if (component instanceof Button && (((Button)component).getStyle() & 8) != 0) {
            gd = (GridData)component.getLayoutData();
            gd.horizontalAlignment = 4;
            gd.widthHint = 100;
        } else {
            gd = new GridData();
            component.setLayoutData((Object)gd);
            gd.horizontalAlignment = horizontalAlignment;
            gd.grabExcessHorizontalSpace = grabExcessHorizontalSpace;
        }
        gd.verticalAlignment = verticalAlignment;
        gd.grabExcessVerticalSpace = grabExcessVerticalSpace;
    }

    private void updateButtonState() {
        if (TimeGraphFindDialog.okToUse((Control)this.getShell()) && TimeGraphFindDialog.okToUse((Control)this.fFindNextButton)) {
            boolean enable = this.fFindTarget != null && (this.fActiveShell == fParentShell || this.fActiveShell == this.getShell());
            String str = this.getFindString();
            boolean findString = str != null && str.length() > 0;
            this.fWholeWordCheckBox.setEnabled(TimeGraphFindDialog.isWord(str) && !this.isRegExSearch());
            this.fFindNextButton.setEnabled(enable && findString);
        }
    }

    private static boolean isWord(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str.length()) {
            if (!Character.isJavaIdentifierPart(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void updateCombo(Combo combo, List<String> content) {
        combo.removeAll();
        int i = 0;
        while (i < content.size()) {
            combo.add(content.get(i).toString());
            ++i;
        }
    }

    private void updateFindHistory() {
        if (TimeGraphFindDialog.okToUse((Control)this.fFindField)) {
            this.fFindField.removeModifyListener((ModifyListener)this.fFindModifyListener);
            TimeGraphFindDialog.updateHistory(this.fFindField, this.fFindHistory);
            this.fFindField.addModifyListener((ModifyListener)this.fFindModifyListener);
        }
    }

    private static void updateHistory(Combo combo, List<String> history) {
        String findString = combo.getText();
        int index = history.indexOf(findString);
        if (index != 0) {
            if (index != -1) {
                history.remove(index);
            }
            history.add(0, findString);
            Point selection = combo.getSelection();
            TimeGraphFindDialog.updateCombo(combo, history);
            combo.setText(findString);
            combo.setSelection(selection);
        }
    }

    public void setParentShell(Shell shell) {
        if (shell != fParentShell) {
            if (fParentShell != null) {
                fParentShell.removeShellListener((ShellListener)this.fActivationListener);
            }
            fParentShell = shell;
            fParentShell.addShellListener((ShellListener)this.fActivationListener);
        }
        this.fActiveShell = shell;
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return this.fDialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        this.fWrapInit = s.get("wrap") == null || s.getBoolean("wrap");
        this.fCaseInit = s.getBoolean("casesensitive");
        this.fWholeWordInit = s.getBoolean("wholeword");
        this.fIsRegExInit = s.getBoolean("isRegEx");
        String[] findHistory = s.getArray("findhistory");
        if (findHistory != null) {
            this.fFindHistory.clear();
            int i = 0;
            while (i < findHistory.length) {
                this.fFindHistory.add(findHistory[i]);
                ++i;
            }
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        s.put("wrap", this.fWrapInit);
        s.put("casesensitive", this.fCaseInit);
        s.put("wholeword", this.fWholeWordInit);
        s.put("casesensitive", this.fIsRegExInit);
        String findString = this.getFindString();
        if (findString.length() > 0) {
            this.fFindHistory.add(0, findString);
        }
        TimeGraphFindDialog.writeHistory(this.fFindHistory, s, "findhistory");
    }

    private static void writeHistory(List<String> history, IDialogSettings settings, String sectionName) {
        int itemCount = history.size();
        HashSet<String> distinctItems = new HashSet<String>(itemCount);
        int i = 0;
        while (i < itemCount) {
            String item = history.get(i);
            if (distinctItems.contains(item)) {
                history.remove(i--);
                --itemCount;
            } else {
                distinctItems.add(item);
            }
            ++i;
        }
        while (history.size() > 8) {
            history.remove(8);
        }
        String[] names = new String[history.size()];
        history.toArray(names);
        settings.put(sectionName, names);
    }

    public void updateTarget(@Nullable AbstractTimeGraphView.FindTarget findTarget, boolean initFindString) {
        this.fFindTarget = findTarget;
        if (initFindString) {
            this.initFindStringFromSelection();
        }
        this.updateButtonState();
    }

    public boolean isDialogParentShell(Shell shell) {
        return shell == this.getParentShell();
    }

    private static int adjustIndex(int previousIndex, int count, boolean forwardSearch) {
        int index = previousIndex;
        index = forwardSearch ? (index >= count || index < 0 ? 0 : index) : (index >= count || index < 0 ? count - 1 : index);
        return index;
    }

    private static @NonNull Pattern getPattern(String findString, SearchOptions options) {
        String toFind = findString;
        int patternFlags = 0;
        if (options.regExSearch) {
            toFind = TimeGraphFindDialog.substituteLinebreak(toFind);
        }
        if (!options.caseSensitive) {
            patternFlags |= 0x42;
        }
        if (!options.regExSearch) {
            toFind = TimeGraphFindDialog.asRegPattern(toFind);
        }
        if (options.wholeWord) {
            toFind = "\\b" + toFind + "\\b";
        }
        Pattern pattern = Pattern.compile(toFind, patternFlags);
        return pattern;
    }

    private static String substituteLinebreak(String findString) {
        int length = findString.length();
        StringBuffer buf = new StringBuffer(length);
        int inCharGroup = 0;
        int inBraces = 0;
        boolean inQuote = false;
        int i = 0;
        while (i < length) {
            char ch = findString.charAt(i);
            switch (ch) {
                case '[': {
                    buf.append(ch);
                    if (inQuote) break;
                    ++inCharGroup;
                    break;
                }
                case ']': {
                    buf.append(ch);
                    if (inQuote) break;
                    --inCharGroup;
                    break;
                }
                case '{': {
                    buf.append(ch);
                    if (inQuote || inCharGroup != 0) break;
                    ++inBraces;
                    break;
                }
                case '}': {
                    buf.append(ch);
                    if (inQuote || inCharGroup != 0) break;
                    --inBraces;
                    break;
                }
                case '\\': {
                    if (i + 1 < length) {
                        char ch1 = findString.charAt(i + 1);
                        if (inQuote) {
                            if (ch1 == 'E') {
                                inQuote = false;
                            }
                            buf.append(ch).append(ch1);
                            ++i;
                            break;
                        }
                        if (ch1 == 'R') {
                            if (inCharGroup > 0 || inBraces > 0) {
                                String msg = "TimeGrahViewer.illegalLinebreak";
                                throw new PatternSyntaxException(msg, findString, i);
                            }
                            buf.append("(?>\\r\\n?|\\n)");
                            ++i;
                            break;
                        }
                        if (ch1 == 'Q') {
                            inQuote = true;
                        }
                        buf.append(ch).append(ch1);
                        ++i;
                        break;
                    }
                    buf.append(ch);
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    private static String asRegPattern(String string) {
        StringBuffer out = new StringBuffer(string.length());
        boolean quoting = false;
        int i = 0;
        int length = string.length();
        while (i < length) {
            char ch = string.charAt(i);
            if (ch == '\\') {
                if (quoting) {
                    out.append("\\E");
                    quoting = false;
                }
                out.append("\\\\");
            } else {
                if (!quoting) {
                    out.append("\\Q");
                    quoting = true;
                }
                out.append(ch);
            }
            ++i;
        }
        if (quoting) {
            out.append("\\E");
        }
        return out.toString();
    }

    class ActivationListener
    extends ShellAdapter {
        ActivationListener() {
        }

        public void shellActivated(ShellEvent e) {
            TimeGraphFindDialog.this.fActiveShell = (Shell)e.widget;
            TimeGraphFindDialog.this.updateButtonState();
            if (TimeGraphFindDialog.this.fGiveFocusToFindField && TimeGraphFindDialog.this.getShell() == TimeGraphFindDialog.this.fActiveShell && TimeGraphFindDialog.okToUse((Control)TimeGraphFindDialog.this.fFindField)) {
                TimeGraphFindDialog.this.fFindField.setFocus();
            }
        }

        public void shellDeactivated(ShellEvent e) {
            TimeGraphFindDialog.this.fGiveFocusToFindField = false;
            TimeGraphFindDialog.this.storeSettings();
            TimeGraphFindDialog.this.fActiveShell = null;
            TimeGraphFindDialog.this.updateButtonState();
        }
    }

    private class FindModifyListener
    implements ModifyListener {
        private FindModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            TimeGraphFindDialog.this.updateButtonState();
        }
    }

    private class SearchOptions {
        boolean forwardSearch;
        boolean caseSensitive;
        boolean wrapSearch;
        boolean wholeWord;
        boolean regExSearch;

        private SearchOptions() {
        }
    }
}

