/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.statistics;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public class OfflineStatisticsCalculator<@NonNull E>
implements IStatistics<E> {
    private final Collection<E> fElements;
    private final @NonNull Function<E, @NonNull Long> fMapper;

    public OfflineStatisticsCalculator(Collection<E> elements, @NonNull Function<E, @NonNull Long> mapper) {
        this.fElements = elements;
        this.fMapper = mapper;
    }

    public long getMax() {
        long max = Long.MIN_VALUE;
        for (E element : this.fElements) {
            max = Math.max(max, this.fMapper.apply(element));
        }
        return max;
    }

    public long getMin() {
        long min = Long.MAX_VALUE;
        for (E element : this.fElements) {
            min = Math.min(min, this.fMapper.apply(element));
        }
        return min;
    }

    public @NonNull E getMinObject() {
        @Nullable T obj = null;
        for (E element : this.fElements) {
            if (obj == null) {
                obj = element;
                continue;
            }
            Long value = this.fMapper.apply(element);
            if (value > this.fMapper.apply(obj)) continue;
            obj = element;
        }
        if (obj == null) {
            throw new NoSuchElementException("There are no elements in the collection");
        }
        return (E)obj;
    }

    public @NonNull E getMaxObject() {
        @Nullable T obj = null;
        for (E element : this.fElements) {
            if (obj == null) {
                obj = element;
                continue;
            }
            Long value = this.fMapper.apply(element);
            if (value < this.fMapper.apply(obj)) continue;
            obj = element;
        }
        if (obj == null) {
            throw new NoSuchElementException("There are no elements in the collection");
        }
        return (E)obj;
    }

    public double getMean() {
        double total = 0.0;
        for (E element : this.fElements) {
            total += (double)((Long)NonNullUtils.checkNotNull((Object)this.fMapper.apply(element))).longValue() / (double)this.fElements.size();
        }
        return total;
    }

    public double getStdDev() {
        if (this.fElements.size() < 3) {
            return Double.NaN;
        }
        double mean = this.getMean();
        double totalVariance = 0.0;
        for (E element : this.fElements) {
            double result = (double)((Long)NonNullUtils.checkNotNull((Object)this.fMapper.apply(element))).longValue() - mean;
            totalVariance += result * result / (double)(this.fElements.size() - 1);
        }
        return Math.sqrt(totalVariance);
    }

    public double getTotal() {
        double total = 0.0;
        for (E element : this.fElements) {
            total += (double)this.fMapper.apply(element).longValue();
        }
        return total;
    }

    public long getNbElements() {
        return this.fElements.size();
    }

    public void update(@NonNull E object) {
        throw new UnsupportedOperationException("Offline statistics should not update");
    }

    public void merge(@NonNull IStatistics<@NonNull E> other) {
        throw new UnsupportedOperationException("Offline statistics should not merge");
    }
}

