/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.tests.callstack;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.lttng2.ust.core.callstack.LttngUstCallStackAnalysisRequirement;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class LTTngUstCallStackAnalysisRequirementTest {
    private static final @NonNull String FUNC_EXIT_FAST = "lttng_ust_cyg_profile_fast:func_exit";
    private static final @NonNull String FUNC_EXIT = "lttng_ust_cyg_profile:func_exit";
    private static final @NonNull String FUNC_ENTRY_FAST = "lttng_ust_cyg_profile_fast:func_entry";
    private static final @NonNull String FUNC_ENTRY = "lttng_ust_cyg_profile:func_entry";
    private static final @NonNull String OTHER_EVENT = "OTHER";
    private static final @NonNull String CONTEXT_VTID = "context._vtid";
    private static final @NonNull String CONTEXT_PROCNAME = "context._procname";
    private static final @NonNull String CONTEXT_OTHER = "context._other";
    private static final @NonNull Collection<String> validFields = ImmutableSet.of((Object)"context._vtid", (Object)"context._procname");
    private static final @NonNull Collection<String> badFields = ImmutableSet.of((Object)"context._other", (Object)"context._procname");

    @AfterClass
    public static void cleanup() {
        TestData[] testDataArray = TestData.values();
        int n = testDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestData testData = testDataArray[n2];
            testData.getTrace().dispose();
            ++n2;
        }
    }

    @Test
    public void testCallStackRequirements() {
        LttngUstCallStackAnalysisRequirement req = new LttngUstCallStackAnalysisRequirement(ILttngUstEventLayout.DEFAULT_LAYOUT);
        TestData[] testDataArray = TestData.values();
        int n = testDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestData item = testDataArray[n2];
            Assert.assertEquals((String)item.name(), (Object)item.isValid(), (Object)req.test((ITmfTrace)item.getTrace()));
            ++n2;
        }
    }

    static /* synthetic */ Collection access$0() {
        return validFields;
    }

    static /* synthetic */ Collection access$1() {
        return badFields;
    }

    static enum EventType {
        EVT_EXIT_FAST("lttng_ust_cyg_profile_fast:func_exit", LTTngUstCallStackAnalysisRequirementTest.access$0()),
        EVT_EXIT("lttng_ust_cyg_profile:func_exit", LTTngUstCallStackAnalysisRequirementTest.access$0()),
        EVT_ENTRY_FAST("lttng_ust_cyg_profile_fast:func_entry", LTTngUstCallStackAnalysisRequirementTest.access$0()),
        EVT_ENTRY("lttng_ust_cyg_profile:func_entry", LTTngUstCallStackAnalysisRequirementTest.access$0()),
        EVT_OTHER("OTHER", LTTngUstCallStackAnalysisRequirementTest.access$0()),
        EVT_ENTRY_BAD_FIELDS("lttng_ust_cyg_profile:func_entry", LTTngUstCallStackAnalysisRequirementTest.access$1()),
        EVT_ENTRY_FAST_BAD_FIELDS("lttng_ust_cyg_profile_fast:func_entry", LTTngUstCallStackAnalysisRequirementTest.access$1()),
        EVT_ENTRY_FAST_EMPTY_FIELDS("lttng_ust_cyg_profile_fast:func_entry", (Collection<String>)ImmutableSet.of());

        private final @NonNull CtfTmfEventType fType;

        private EventType(final String name, final Collection<String> fields) {
            this.fType = new CtfTmfEventType(name, null){

                public String getName() {
                    return name;
                }

                public @NonNull Collection<String> getFieldNames() {
                    return fields;
                }
            };
        }

        @NonNull CtfTmfEventType getEventType() {
            return this.fType;
        }
    }

    static enum TestData {
        TRACE_WITH_VALID_EVENTS(EventType.EVT_ENTRY, EventType.EVT_EXIT, true),
        TRACE_WITH_VALID_EVENTS_FAST(EventType.EVT_ENTRY_FAST, EventType.EVT_EXIT_FAST, true),
        TRACE_WITH_VALID_EVENTS_MISSING_FIELDS(EventType.EVT_ENTRY_BAD_FIELDS, EventType.EVT_EXIT, false),
        TRACE_WITH_VALID_EVENTS_MISSING_FIELDS_FAST(EventType.EVT_ENTRY_FAST_BAD_FIELDS, EventType.EVT_EXIT_FAST, false),
        TRACE_WITH_VALID_EVENTS_WRONG_FIELDS(EventType.EVT_ENTRY_FAST_EMPTY_FIELDS, EventType.EVT_EXIT_FAST, false),
        TRACE_WITH_MISSING_EVENTS(EventType.EVT_OTHER, EventType.EVT_EXIT_FAST, false),
        TRACE_MISMATCH_EVENTS(EventType.EVT_ENTRY_FAST, EventType.EVT_EXIT, false);

        private final @NonNull LttngUstTrace fTrace;
        private final boolean fIsValid;

        private TestData(final EventType first, final EventType second, boolean isValid) {
            this.fTrace = new LttngUstTrace(){

                public Set<CtfTmfEventType> getContainedEventTypes() {
                    return ImmutableSet.of((Object)first.getEventType(), (Object)second.getEventType());
                }
            };
            this.fIsValid = isValid;
        }

        @NonNull LttngUstTrace getTrace() {
            return this.fTrace;
        }

        boolean isValid() {
            return this.fIsValid;
        }
    }
}

