/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.presentation;

import org.eclipse.jdt.annotation.Nullable;

public class RGBAColor {
    public static final double TAU = Math.PI * 2;
    private static final int BYTEMASK = 255;
    private final short fRed;
    private final short fGreen;
    private final short fBlue;
    private final short fAlpha;

    public static final RGBAColor fromHSBA(float hue, float saturation, float brightness, float alpha) {
        double r;
        double g;
        double b;
        if (hue < 0.0f || (double)hue > Math.PI * 2 || saturation < 0.0f || saturation > 1.0f || brightness < 0.0f || brightness > 1.0f) {
            throw new IllegalArgumentException(String.format("Invalid color value (%f,%f,%f,%f)", Float.valueOf(hue), Float.valueOf(saturation), Float.valueOf(brightness), Float.valueOf(alpha)));
        }
        if (saturation == 0.0f) {
            g = b = (double)brightness;
            r = b;
        } else {
            double min = Math.min(Math.PI * 2, (double)hue);
            double quadHue = min / 1.0471975511965976;
            int i = (int)quadHue;
            double f = quadHue - (double)i;
            double p = brightness * (1.0f - saturation);
            double q = (double)brightness * (1.0 - (double)saturation * f);
            double t = (double)brightness * (1.0 - (double)saturation * (1.0 - f));
            switch (i) {
                case 0: {
                    r = brightness;
                    g = t;
                    b = p;
                    break;
                }
                case 1: {
                    r = q;
                    g = brightness;
                    b = p;
                    break;
                }
                case 2: {
                    r = p;
                    g = brightness;
                    b = t;
                    break;
                }
                case 3: {
                    r = p;
                    g = q;
                    b = brightness;
                    break;
                }
                case 4: {
                    r = t;
                    g = p;
                    b = brightness;
                    break;
                }
                default: {
                    r = brightness;
                    g = p;
                    b = q;
                }
            }
        }
        return new RGBAColor((int)Math.round(r * 255.0), (int)Math.round(g * 255.0), (int)Math.round(b * 255.0), Math.round(alpha * 255.0f));
    }

    public static @Nullable RGBAColor fromString(String rgbaString) {
        if (rgbaString.length() != 9 || rgbaString.charAt(0) != '#') {
            return null;
        }
        int r = RGBAColor.toInt(rgbaString.charAt(1), rgbaString.charAt(2));
        int g = RGBAColor.toInt(rgbaString.charAt(3), rgbaString.charAt(4));
        int b = RGBAColor.toInt(rgbaString.charAt(5), rgbaString.charAt(6));
        int a = RGBAColor.toInt(rgbaString.charAt(7), rgbaString.charAt(8));
        if (r == -1 || g == -1 || b == -1 || a == -1) {
            return null;
        }
        return new RGBAColor(r, g, b, a);
    }

    public static @Nullable RGBAColor fromString(String rgbString, int alpha) {
        if (rgbString.length() != 7 || rgbString.charAt(0) != '#') {
            return null;
        }
        int r = RGBAColor.toInt(rgbString.charAt(1), rgbString.charAt(2));
        int g = RGBAColor.toInt(rgbString.charAt(3), rgbString.charAt(4));
        int b = RGBAColor.toInt(rgbString.charAt(5), rgbString.charAt(6));
        if (r == -1 || g == -1 || b == -1) {
            return null;
        }
        return new RGBAColor(r, g, b, alpha);
    }

    public RGBAColor(int red, int green, int blue, int alpha) {
        if (red > 255 || red < 0) {
            throw new IllegalArgumentException("Red component must be between 0 and 255. Was : " + red);
        }
        if (green > 255 || green < 0) {
            throw new IllegalArgumentException("Green component must be between 0 and 255. Was : " + green);
        }
        if (blue > 255 || blue < 0) {
            throw new IllegalArgumentException("Blue component must be between 0 and 255. Was : " + blue);
        }
        if (alpha > 255 || alpha < 0) {
            throw new IllegalArgumentException("Alpha component must be between 0 and 255. Was : " + alpha);
        }
        this.fRed = (short)red;
        this.fGreen = (short)green;
        this.fBlue = (short)blue;
        this.fAlpha = (short)alpha;
    }

    public RGBAColor(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public RGBAColor(int color) {
        this.fRed = (short)(color >> 24 & 0xFF);
        this.fGreen = (short)(color >> 16 & 0xFF);
        this.fBlue = (short)(color >> 8 & 0xFF);
        this.fAlpha = (short)(color & 0xFF);
    }

    public short getRed() {
        return this.fRed;
    }

    public short getGreen() {
        return this.fGreen;
    }

    public short getBlue() {
        return this.fBlue;
    }

    public short getAlpha() {
        return this.fAlpha;
    }

    public float[] getHSBA() {
        float saturation;
        float r = (float)this.fRed / 255.0f;
        float g = (float)this.fGreen / 255.0f;
        float b = (float)this.fBlue / 255.0f;
        float max = Math.max(Math.max(r, g), b);
        float min = Math.min(Math.min(r, g), b);
        float delta = max - min;
        float hue = 0.0f;
        float brightness = max;
        float f = saturation = max == 0.0f ? 0.0f : (max - min) / max;
        if (delta != 0.0f) {
            hue = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
            if ((hue = (float)((double)hue * 1.0471975511965976)) < 0.0f) {
                hue = (float)((double)hue + Math.PI * 2);
            }
        }
        return new float[]{hue, saturation, brightness, (float)this.fAlpha / 255.0f};
    }

    public int toInt() {
        return this.getRed() << 24 | this.getGreen() << 16 | this.getBlue() << 8 | this.getAlpha();
    }

    public String toString() {
        return String.format("#%08X", this.toInt());
    }

    private static int toInt(char h, char l) {
        int high = RGBAColor.fromDigit(h);
        if (high == -1) {
            return -1;
        }
        int low = RGBAColor.fromDigit(l);
        if (low == -1) {
            return -1;
        }
        return 16 * high + low;
    }

    private static int fromDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        return -1;
    }
}

