/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.IoOperationType;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.Request;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.StateValues;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.StateSystemBuilderUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfAttributePool;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class DiskWriteModel
extends Disk {
    private final List<Pair<Request, Integer>> fDriverQueue = new ArrayList<Pair<Request, Integer>>();
    private final List<Pair<Request, Integer>> fWaitingQueue = new ArrayList<Pair<Request, Integer>>();
    private final ITmfStateSystemBuilder fSs;
    private final TmfAttributePool fWaitingQueueAttrib;
    private final TmfAttributePool fDriverQueueAttrib;

    public DiskWriteModel(Integer dev, ITmfStateSystemBuilder ss) {
        super(dev, (ITmfStateSystem)ss, ss.getQuarkAbsoluteAndAdd(new String[]{"Disks", String.valueOf(dev)}));
        this.fSs = ss;
        int diskQuark = this.getQuark();
        this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"sectors_written"});
        this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"sectors_read"});
        int wqQuark = this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"Waiting_queue"});
        this.fWaitingQueueAttrib = new TmfAttributePool(this.fSs, Integer.valueOf(wqQuark), TmfAttributePool.QueueType.PRIORITY);
        this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"waitingqueue_length"});
        int dqQuark = this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"Driver_queue"});
        this.fDriverQueueAttrib = new TmfAttributePool(this.fSs, Integer.valueOf(dqQuark), TmfAttributePool.QueueType.PRIORITY);
        this.fSs.getQuarkRelativeAndAdd(diskQuark, new String[]{"driverqueue_length"});
    }

    @Override
    public void setDiskName(String diskname) {
        super.setDiskName(diskname);
        try {
            this.fSs.modifyAttribute(this.fSs.getCurrentEndTime(), (Object)diskname, this.getQuark());
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Cannot set the diskname for disk " + diskname, e);
        }
    }

    public @Nullable Request getWaitingRequest(Long sector) {
        for (Pair<Request, Integer> reqQuark : this.fWaitingQueue) {
            if (!((Request)reqQuark.getFirst()).getSector().equals(sector)) continue;
            return (Request)reqQuark.getFirst();
        }
        return null;
    }

    private int removeWaitingRequest(long ts, Long sector, IoOperationType type) {
        Pair<Request, Integer> reqQuark = null;
        for (Pair<Request, Integer> waitingRequest : this.fWaitingQueue) {
            Request request = (Request)waitingRequest.getFirst();
            if (!request.getSector().equals(sector) || request.getType() != type) continue;
            reqQuark = waitingRequest;
            break;
        }
        if (reqQuark == null) {
            return -2;
        }
        this.fWaitingQueue.remove(reqQuark);
        this.fWaitingQueueAttrib.recycle(((Integer)reqQuark.getSecond()).intValue(), ts);
        return (Integer)reqQuark.getSecond();
    }

    public int addWaitingRequest(long ts, Request request) {
        int slotQuark = this.insertInWaitingQueue(ts, request);
        this.updateQueuesLength(ts);
        return slotQuark;
    }

    private int insertInWaitingQueue(long ts, Request request) {
        ITmfStateValue statusState = request.getType() == IoOperationType.READ ? StateValues.READING_REQUEST_VALUE : StateValues.WRITING_REQUEST_VALUE;
        int slotQuark = this.fWaitingQueueAttrib.getAvailable();
        try {
            this.fSs.modifyAttribute(ts, statusState.unboxValue(), slotQuark);
            int currentRequestQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Current_request"});
            this.fSs.modifyAttribute(ts, (Object)request.getSector(), currentRequestQuark);
            int requestSizeQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Request_size"});
            this.fSs.modifyAttribute(ts, (Object)request.getNrSector(), requestSizeQuark);
            int mergedInQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"merged_in"});
            this.fSs.modifyAttribute(ts, null, mergedInQuark);
            int requestTypeQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Type"});
            this.fSs.modifyAttribute(ts, (Object)request.getType().ordinal(), requestTypeQuark);
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error inserting request", e);
        }
        this.fWaitingQueue.add((Pair<Request, Integer>)new Pair((Object)request, (Object)slotQuark));
        return slotQuark;
    }

    public int updateWaitingRequest(long ts, Request request) {
        Pair<Request, Integer> reqQuark = null;
        for (Pair<Request, Integer> waiting : this.fWaitingQueue) {
            if (!((Request)waiting.getFirst()).getSector().equals(request.getSector())) continue;
            reqQuark = waiting;
        }
        if (reqQuark == null) {
            return this.addWaitingRequest(ts, request);
        }
        int slotQuark = (Integer)reqQuark.getSecond();
        try {
            int currentRequestQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Current_request"});
            this.fSs.modifyAttribute(ts, (Object)request.getSector(), currentRequestQuark);
            int requestSizeQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Request_size"});
            this.fSs.modifyAttribute(ts, (Object)request.getNrSector(), requestSizeQuark);
            int mergedInQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"merged_in"});
            this.fSs.modifyAttribute(ts, null, mergedInQuark);
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error inserting request", e);
        }
        this.updateQueuesLength(ts);
        return slotQuark;
    }

    public int getWaitingQueueSize() {
        return this.fWaitingQueue.size();
    }

    public @Nullable Request getDriverRequest(Long sector) {
        for (Pair<Request, Integer> request : this.fDriverQueue) {
            if (!((Request)request.getFirst()).getSector().equals(sector)) continue;
            return (Request)request.getFirst();
        }
        return null;
    }

    private void removeDriverRequest(long ts, Long sector, IoOperationType type) {
        Pair<Request, Integer> reqQuark = null;
        for (Pair<Request, Integer> driverRequest : this.fDriverQueue) {
            Request request = (Request)driverRequest.getFirst();
            if (!request.getSector().equals(sector) || request.getType() != type) continue;
            reqQuark = driverRequest;
            break;
        }
        if (reqQuark != null) {
            this.fDriverQueue.remove(reqQuark);
            this.fDriverQueueAttrib.recycle(((Integer)reqQuark.getSecond()).intValue(), ts);
        }
    }

    public int issueRequest(long ts, Request request) {
        Integer issuedFromValue = null;
        int fromQuark = this.removeWaitingRequest(ts, request.getSector(), request.getType());
        if (fromQuark != -2) {
            issuedFromValue = Integer.parseInt(this.fSs.getAttributeName(fromQuark));
        } else {
            for (Pair<Request, Integer> issued : this.fDriverQueue) {
                Request first = (Request)issued.getFirst();
                if (!first.includes(request)) continue;
                return -2;
            }
        }
        this.removeDanglingRequests(ts, request);
        ITmfStateValue statusState = request.getType() == IoOperationType.READ ? StateValues.READING_REQUEST_VALUE : StateValues.WRITING_REQUEST_VALUE;
        int slotQuark = this.fDriverQueueAttrib.getAvailable();
        try {
            this.fSs.modifyAttribute(ts, statusState.unboxValue(), slotQuark);
            int currentRequestQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Current_request"});
            this.fSs.modifyAttribute(ts, (Object)request.getSector(), currentRequestQuark);
            int requestSizeQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"Request_size"});
            this.fSs.modifyAttribute(ts, (Object)request.getNrSector(), requestSizeQuark);
            int issuedFromQuark = this.fSs.getQuarkRelativeAndAdd(slotQuark, new String[]{"issued_from"});
            this.fSs.modifyAttribute(ts, (Object)issuedFromValue, issuedFromQuark);
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error issuing request", e);
        }
        this.fDriverQueue.add((Pair<Request, Integer>)new Pair((Object)request, (Object)slotQuark));
        this.updateQueuesLength(ts);
        return slotQuark;
    }

    private void removeDanglingRequests(long ts, Request request) {
        ArrayList<Pair<Request, Integer>> toRemove = new ArrayList<Pair<Request, Integer>>();
        for (Pair<Request, Integer> pair : this.fWaitingQueue) {
            Request otherRequest = (Request)pair.getFirst();
            if (!request.includes(otherRequest)) continue;
            toRemove.add(pair);
        }
        for (Pair pair : toRemove) {
            if (!this.fWaitingQueue.remove(pair)) continue;
            int slotQuark = (Integer)pair.getSecond();
            this.fWaitingQueueAttrib.recycle(slotQuark, ts);
        }
    }

    public void completeRequest(long ts, Request request) {
        try {
            switch (request.getType()) {
                case READ: {
                    int readQuark = this.fSs.getQuarkRelativeAndAdd(this.getQuark(), new String[]{"sectors_read"});
                    StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)this.fSs, (long)ts, (int)readQuark, (int)request.getNrSector());
                    break;
                }
                case WRITE: {
                    int writtenQuark = this.fSs.getQuarkRelativeAndAdd(this.getQuark(), new String[]{"sectors_written"});
                    StateSystemBuilderUtils.incrementAttributeInt((ITmfStateSystemBuilder)this.fSs, (long)ts, (int)writtenQuark, (int)request.getNrSector());
                    break;
                }
                default: {
                    throw new IllegalStateException("Complete request: the request cannot be other than READ or WRITE:" + (Object)((Object)request.getType()));
                }
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException e) {
            Activator.getDefault().logError("Error completing request", e);
        }
        this.removeDriverRequest(ts, request.getSector(), request.getType());
        this.updateQueuesLength(ts);
    }

    public void mergeRequests(long ts, Request baseRequest, Request mergedRequest) {
        int mergedQuark = this.removeWaitingRequest(ts, mergedRequest.getSector(), mergedRequest.getType());
        baseRequest.mergeRequest(mergedRequest);
        int baseQuark = this.updateWaitingRequest(ts, baseRequest);
        if (mergedQuark != -2) {
            try {
                int issuedFromQuark = this.fSs.getQuarkRelativeAndAdd(mergedQuark, new String[]{"merged_in"});
                this.fSs.modifyAttribute(ts, (Object)Integer.parseInt(this.fSs.getAttributeName(baseQuark)), issuedFromQuark);
            }
            catch (StateValueTypeException e) {
                Activator.getDefault().logError("Error adding the merged request information", e);
            }
        }
        this.updateQueuesLength(ts);
    }

    public int getDriverQueueSize() {
        return this.fDriverQueue.size();
    }

    private void updateQueuesLength(long ts) {
        try {
            int fDriverQueueLength = this.fSs.getQuarkRelativeAndAdd(this.getQuark(), new String[]{"driverqueue_length"});
            this.fSs.modifyAttribute(ts, (Object)this.getDriverQueueSize(), fDriverQueueLength);
            int fWaitinQueueLength = this.fSs.getQuarkRelativeAndAdd(this.getQuark(), new String[]{"waitingqueue_length"});
            this.fSs.modifyAttribute(ts, (Object)this.getWaitingQueueSize(), fWaitinQueueLength);
        }
        catch (StateValueTypeException e) {
            Activator.getDefault().logError("Error updating queues lengths", e);
        }
    }
}

