/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.tests.model.component;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TargetNodeState;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceChannelOutputType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEventType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.stubs.service.TestRemoteSystemProxy;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.ITraceControlComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.KernelProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceChannelComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProbeEventComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceProviderGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionGroup;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.UstProviderComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.ILttngControlService;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.service.LTTngControlService;
import org.eclipse.tracecompass.lttng2.control.ui.tests.model.component.TraceControlTestFacility;
import org.eclipse.tracecompass.tmf.remote.core.proxy.RemoteSystemProxy;
import org.eclipse.tracecompass.tmf.remote.core.proxy.TmfRemoteConnectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TraceControlTreeModelTest {
    private TraceControlTestFacility fFacility;
    private static final String TEST_STREAM = "ListInfoTest.cfg";
    private static final String SCEN_LIST_INFO_TEST = "ListInfoTest";
    private static final String TARGET_NODE_NAME = "myNode";
    private IRemoteConnection fHost = TmfRemoteConnectionFactory.getLocalConnection();
    private @NonNull TestRemoteSystemProxy fProxy = new TestRemoteSystemProxy(this.fHost);
    private String fTestFile;

    @Before
    public void setUp() throws Exception {
        this.fFacility = TraceControlTestFacility.getInstance();
        this.fFacility.init();
        URL location = FileLocator.find((Bundle)FrameworkUtil.getBundle(this.getClass()), (IPath)new Path("testfiles" + File.separator + TEST_STREAM), null);
        File testfile = new File(FileLocator.toFileURL((URL)location).toURI());
        this.fTestFile = testfile.getAbsolutePath();
    }

    @After
    public void tearDown() {
        this.fFacility.dispose();
    }

    @Test
    public void testTraceControlComponents() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario(SCEN_LIST_INFO_TEST);
        ITraceControlComponent root = this.fFacility.getControlView().getTraceControlRoot();
        TargetNodeComponent node = new TargetNodeComponent(TARGET_NODE_NAME, root, (RemoteSystemProxy)this.fProxy);
        root.addChild((ITraceControlComponent)node);
        node.connect();
        this.fFacility.waitForConnect(node);
        this.fFacility.waitForJobs();
        Assert.assertEquals((Object)"Local", (Object)node.getToolTip());
        Image connectedImage = node.getImage();
        Assert.assertNotNull((Object)connectedImage);
        Assert.assertEquals((Object)TargetNodeState.CONNECTED, (Object)node.getTargetNodeState());
        Assert.assertNotNull((Object)node.getControlService());
        ILttngControlService service = node.getControlService();
        Assert.assertTrue((boolean)(service instanceof LTTngControlService));
        node.setControlService(service);
        Assert.assertTrue((boolean)(node.getControlService() instanceof LTTngControlService));
        ITraceControlComponent[] groups = node.getChildren();
        Assert.assertNotNull((Object)groups);
        Assert.assertEquals((long)2L, (long)groups.length);
        Assert.assertTrue((boolean)(groups[0] instanceof TraceProviderGroup));
        Assert.assertTrue((boolean)(groups[1] instanceof TraceSessionGroup));
        Assert.assertEquals((Object)"Provider", (Object)groups[0].getName());
        Assert.assertEquals((Object)"Sessions", (Object)groups[1].getName());
        ITraceControlComponent[] providers = groups[0].getChildren();
        Assert.assertNotNull((Object)providers);
        Assert.assertEquals((long)3L, (long)providers.length);
        KernelProviderComponent kernelProvider = (KernelProviderComponent)providers[0];
        ITraceControlComponent[] events = kernelProvider.getChildren();
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)3L, (long)events.length);
        BaseEventComponent baseEventInfo = (BaseEventComponent)events[0];
        Assert.assertNotNull((Object)baseEventInfo);
        Assert.assertEquals((Object)"sched_kthread_stop", (Object)baseEventInfo.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)baseEventInfo.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        baseEventInfo = (BaseEventComponent)events[1];
        Assert.assertEquals((Object)"sched_kthread_stop_ret", (Object)baseEventInfo.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)baseEventInfo.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        baseEventInfo = (BaseEventComponent)events[2];
        Assert.assertEquals((Object)"sched_wakeup_new", (Object)baseEventInfo.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)baseEventInfo.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        UstProviderComponent ustProvider = (UstProviderComponent)providers[1];
        Assert.assertEquals((Object)"/home/user/git/lttng-ust/tests/hello.cxx/.libs/lt-hello [PID=9379]", (Object)ustProvider.getName());
        Assert.assertEquals((long)9379L, (long)ustProvider.getPid());
        events = ustProvider.getChildren();
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.length);
        baseEventInfo = (BaseEventComponent)events[0];
        Assert.assertNotNull((Object)baseEventInfo);
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)baseEventInfo.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_MODULE, (Object)baseEventInfo.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        baseEventInfo = (BaseEventComponent)events[1];
        Assert.assertEquals((Object)"ust_tests_hello:tptest", (Object)baseEventInfo.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_INFO, (Object)baseEventInfo.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        ustProvider = (UstProviderComponent)providers[2];
        Assert.assertEquals((Object)"/home/user/git/lttng-ust/tests/hello.cxx/.libs/lt-hello [PID=4852]", (Object)ustProvider.getName());
        Assert.assertEquals((long)4852L, (long)ustProvider.getPid());
        TraceControlTreeModelTest.verifyUstProviderGettersSetters(ustProvider);
        events = ustProvider.getChildren();
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((long)2L, (long)events.length);
        baseEventInfo = (BaseEventComponent)events[0];
        Assert.assertNotNull((Object)baseEventInfo);
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)baseEventInfo.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_WARNING, (Object)baseEventInfo.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        baseEventInfo = (BaseEventComponent)events[1];
        Assert.assertEquals((Object)"ust_tests_hello:tptest", (Object)baseEventInfo.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_FUNCTION, (Object)baseEventInfo.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)baseEventInfo.getEventType());
        TraceControlTreeModelTest.verifyBaseEventGettersSetters(baseEventInfo);
        ITraceControlComponent[] sessions = groups[1].getChildren();
        Assert.assertNotNull((Object)sessions);
        Assert.assertEquals((long)2L, (long)sessions.length);
        int i = 0;
        while (i < sessions.length) {
            Assert.assertTrue((boolean)(sessions[i] instanceof TraceSessionComponent));
            ++i;
        }
        Assert.assertEquals((Object)"mysession1", (Object)sessions[0].getName());
        Assert.assertEquals((Object)"mysession", (Object)sessions[1].getName());
        TraceSessionComponent session = (TraceSessionComponent)sessions[1];
        Assert.assertEquals((Object)"mysession", (Object)session.getName());
        Assert.assertEquals((Object)"/home/user/lttng-traces/mysession-20120129-084256", (Object)session.getSessionPath());
        Assert.assertEquals((Object)TraceSessionState.ACTIVE, (Object)session.getSessionState());
        TraceControlTreeModelTest.verifySessionGetterSetters(session);
        ITraceControlComponent[] domains = session.getChildren();
        Assert.assertNotNull((Object)domains);
        Assert.assertEquals((long)2L, (long)domains.length);
        Assert.assertEquals((Object)"Kernel", (Object)domains[0].getName());
        ITraceControlComponent[] channels = domains[0].getChildren();
        Assert.assertNotNull((Object)channels);
        Assert.assertEquals((long)2L, (long)channels.length);
        TraceControlTreeModelTest.verifyDomainGettersSetters((TraceDomainComponent)domains[0]);
        Assert.assertTrue((boolean)(channels[0] instanceof TraceChannelComponent));
        TraceChannelComponent channel = (TraceChannelComponent)channels[0];
        Assert.assertEquals((Object)"channel0", (Object)channel.getName());
        Assert.assertEquals((long)4L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"splice()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channel.getOutputType());
        Assert.assertEquals((Object)false, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)200L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Assert.assertEquals((long)262144L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)0L, (long)channel.getSwitchTimer());
        ITraceControlComponent[] channel0Events = channel.getChildren();
        Assert.assertNotNull((Object)channel0Events);
        Assert.assertEquals((long)5L, (long)channel0Events.length);
        Assert.assertTrue((boolean)(channel0Events[0] instanceof TraceEventComponent));
        Assert.assertTrue((boolean)(channel0Events[1] instanceof TraceEventComponent));
        Assert.assertTrue((boolean)(channel0Events[2] instanceof TraceProbeEventComponent));
        Assert.assertTrue((boolean)(channel0Events[3] instanceof TraceProbeEventComponent));
        Assert.assertTrue((boolean)(channel0Events[4] instanceof TraceEventComponent));
        TraceEventComponent event = (TraceEventComponent)channel0Events[0];
        Assert.assertEquals((Object)"block_rq_remap", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        event = (TraceEventComponent)channel0Events[1];
        Assert.assertEquals((Object)"block_bio_remap", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_EMERG, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)event.getState());
        TraceProbeEventComponent probeEvent = (TraceProbeEventComponent)channel0Events[2];
        Assert.assertEquals((Object)"myevent2", (Object)probeEvent.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)probeEvent.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.PROBE, (Object)probeEvent.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)probeEvent.getState());
        Assert.assertEquals((Object)"0xc0101340", (Object)probeEvent.getAddress());
        Assert.assertNull((Object)probeEvent.getOffset());
        Assert.assertNull((Object)probeEvent.getSymbol());
        TraceControlTreeModelTest.verifyProbeEventGettersSetters(probeEvent);
        probeEvent = (TraceProbeEventComponent)channel0Events[3];
        Assert.assertEquals((Object)"myevent0", (Object)probeEvent.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)probeEvent.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.PROBE, (Object)probeEvent.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)probeEvent.getState());
        Assert.assertNull((Object)probeEvent.getAddress());
        Assert.assertEquals((Object)"0x0", (Object)probeEvent.getOffset());
        Assert.assertEquals((Object)"init_post", (Object)probeEvent.getSymbol());
        event = (TraceEventComponent)channel0Events[4];
        Assert.assertEquals((Object)"syscalls", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.SYSCALL, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        Assert.assertEquals((Object)"channel1", (Object)channels[1].getName());
        channel = (TraceChannelComponent)channels[1];
        Assert.assertEquals((long)4L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"splice()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channel.getOutputType());
        Assert.assertEquals((Object)true, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)400L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)channel.getState());
        Assert.assertEquals((long)524288L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)100L, (long)channel.getSwitchTimer());
        ITraceControlComponent[] channel1Events = channels[1].getChildren();
        Assert.assertEquals((long)0L, (long)channel1Events.length);
        Assert.assertEquals((Object)"UST global", (Object)domains[1].getName());
        ITraceControlComponent[] ustChannels = domains[1].getChildren();
        int i2 = 0;
        while (i2 < ustChannels.length) {
            Assert.assertTrue((boolean)(ustChannels[i2] instanceof TraceChannelComponent));
            ++i2;
        }
        channel = (TraceChannelComponent)ustChannels[0];
        Assert.assertEquals((Object)"mychannel1", (Object)channel.getName());
        Assert.assertEquals((long)8L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"mmap()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)channel.getOutputType());
        Assert.assertEquals((Object)true, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)100L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)channel.getState());
        Assert.assertEquals((long)8192L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)200L, (long)channel.getSwitchTimer());
        TraceControlTreeModelTest.verifyChannelGettersSetters(channel);
        ITraceControlComponent[] ustEvents = channel.getChildren();
        Assert.assertEquals((long)0L, (long)ustEvents.length);
        channel = (TraceChannelComponent)ustChannels[1];
        Assert.assertEquals((Object)"channel0", (Object)channel.getName());
        Assert.assertEquals((long)4L, (long)channel.getNumberOfSubBuffers());
        Assert.assertEquals((Object)"mmap()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.MMAP, (Object)channel.getOutputType());
        Assert.assertEquals((Object)false, (Object)channel.isOverwriteMode());
        Assert.assertEquals((long)200L, (long)channel.getReadTimer());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Assert.assertEquals((long)4096L, (long)channel.getSubBufferSize());
        Assert.assertEquals((long)0L, (long)channel.getSwitchTimer());
        ustEvents = channel.getChildren();
        Assert.assertEquals((long)4L, (long)ustEvents.length);
        event = (TraceEventComponent)ustEvents[0];
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_LINE, (Object)event.getLogLevel());
        Assert.assertEquals((Object)LogLevelType.LOGLEVEL_ONLY, (Object)event.getLogLevelType());
        Assert.assertEquals((Object)LogLevelType.LOGLEVEL_ONLY.getShortName(), (Object)event.getLogLevelType().getShortName());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)event.getState());
        event = (TraceEventComponent)ustEvents[1];
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler1", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_INFO, (Object)event.getLogLevel());
        Assert.assertEquals((Object)LogLevelType.LOGLEVEL, (Object)event.getLogLevelType());
        Assert.assertEquals((Object)LogLevelType.LOGLEVEL.getShortName(), (Object)event.getLogLevelType().getShortName());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)event.getState());
        event = (TraceEventComponent)ustEvents[2];
        Assert.assertEquals((Object)"ust_tests_hello:tptest_sighandler2", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.TRACE_DEBUG_SYSTEM, (Object)event.getLogLevel());
        Assert.assertEquals((Object)LogLevelType.LOGLEVEL_NONE, (Object)event.getLogLevelType());
        Assert.assertEquals((Object)LogLevelType.LOGLEVEL_NONE.getShortName(), (Object)event.getLogLevelType().getShortName());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)event.getState());
        event = (TraceEventComponent)ustEvents[3];
        Assert.assertEquals((Object)"*", (Object)event.getName());
        Assert.assertEquals((Object)TraceLogLevel.LEVEL_UNKNOWN, (Object)event.getLogLevel());
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        TraceControlTreeModelTest.verifyEventGettersSetters(event);
        node.disconnect();
        Assert.assertEquals((Object)TargetNodeState.DISCONNECTED, (Object)node.getTargetNodeState());
        Assert.assertNotNull((Object)node.getImage());
        Assert.assertNotSame((Object)connectedImage, (Object)node.getImage());
        node.getParent().removeChild((ITraceControlComponent)node);
    }

    private static void verifySessionGetterSetters(TraceSessionComponent session) {
        String name = session.getName();
        String origPath = session.getSessionPath();
        TraceSessionState origState = session.getSessionState();
        session.setName("newName");
        Assert.assertEquals((Object)"newName", (Object)session.getName());
        session.setSessionPath("/home/user/tmp");
        Assert.assertEquals((Object)"/home/user/tmp", (Object)session.getSessionPath());
        session.setSessionState(TraceSessionState.INACTIVE);
        Assert.assertEquals((Object)TraceSessionState.INACTIVE, (Object)session.getSessionState());
        Image inactiveImage = session.getImage();
        Assert.assertNotNull((Object)inactiveImage);
        session.setSessionState("active");
        Assert.assertEquals((Object)TraceSessionState.ACTIVE, (Object)session.getSessionState());
        Image activeImage = session.getImage();
        Assert.assertNotNull((Object)activeImage);
        Assert.assertNotSame((Object)activeImage, (Object)inactiveImage);
        ITraceControlComponent[] children = session.getChildren();
        TraceDomainComponent[] domains = session.getDomains();
        Assert.assertEquals((long)children.length, (long)domains.length);
        int i = 0;
        while (i < domains.length) {
            Assert.assertEquals((Object)domains[i].getName(), (Object)children[i].getName());
            ++i;
        }
        session.setName(name);
        session.setSessionPath(origPath);
        session.setSessionState(origState);
    }

    private static void verifyDomainGettersSetters(TraceDomainComponent domain) {
        TraceDomainType tmpDomain = domain.getDomain();
        domain.setDomain(TraceDomainType.KERNEL);
        Assert.assertEquals((Object)domain.getDomain(), (Object)TraceDomainType.KERNEL);
        domain.setDomain(TraceDomainType.UST);
        Assert.assertEquals((Object)domain.getDomain(), (Object)TraceDomainType.UST);
        domain.setDomain(TraceDomainType.JUL);
        Assert.assertEquals((Object)domain.getDomain(), (Object)TraceDomainType.JUL);
        domain.setDomain(TraceDomainType.LOG4J);
        Assert.assertEquals((Object)domain.getDomain(), (Object)TraceDomainType.LOG4J);
        domain.setDomain(TraceDomainType.PYTHON);
        Assert.assertEquals((Object)domain.getDomain(), (Object)TraceDomainType.PYTHON);
        domain.setDomain(TraceDomainType.UNKNOWN);
        Assert.assertEquals((Object)domain.getDomain(), (Object)TraceDomainType.UNKNOWN);
        ITraceControlComponent[] children = domain.getChildren();
        TraceChannelComponent[] channels = domain.getChannels();
        Assert.assertEquals((long)children.length, (long)channels.length);
        int i = 0;
        while (i < channels.length) {
            Assert.assertEquals((Object)channels[i].getName(), (Object)children[i].getName());
            ++i;
        }
        String nodeName = domain.getTargetNode().getName();
        Assert.assertEquals((Object)TARGET_NODE_NAME, (Object)nodeName);
        domain.setDomain(tmpDomain);
    }

    private static void verifyBaseEventGettersSetters(BaseEventComponent event) {
        String name = event.getName();
        TraceLogLevel level = event.getLogLevel();
        TraceEventType type = event.getEventType();
        event.setName("newName");
        Assert.assertEquals((Object)"newName", (Object)event.getName());
        event.setLogLevel(TraceLogLevel.TRACE_INFO);
        Assert.assertEquals((Object)TraceLogLevel.TRACE_INFO, (Object)event.getLogLevel());
        event.setLogLevel("TRACE_ALERT");
        Assert.assertEquals((Object)TraceLogLevel.TRACE_ALERT, (Object)event.getLogLevel());
        event.setEventType(TraceEventType.UNKNOWN);
        Assert.assertEquals((Object)TraceEventType.UNKNOWN, (Object)event.getEventType());
        event.setEventType("tracepoint");
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        event.setName(name);
        event.setLogLevel(level);
        event.setEventType(type);
    }

    private static void verifyEventGettersSetters(TraceEventComponent event) {
        String name = event.getName();
        TraceLogLevel level = event.getLogLevel();
        TraceEventType type = event.getEventType();
        TraceEnablement state = event.getState();
        event.setName("newName");
        Assert.assertEquals((Object)"newName", (Object)event.getName());
        event.setLogLevel(TraceLogLevel.TRACE_INFO);
        Assert.assertEquals((Object)TraceLogLevel.TRACE_INFO, (Object)event.getLogLevel());
        event.setLogLevel("TRACE_ALERT");
        Assert.assertEquals((Object)TraceLogLevel.TRACE_ALERT, (Object)event.getLogLevel());
        event.setEventType(TraceEventType.UNKNOWN);
        Assert.assertEquals((Object)TraceEventType.UNKNOWN, (Object)event.getEventType());
        event.setEventType("tracepoint");
        Assert.assertEquals((Object)TraceEventType.TRACEPOINT, (Object)event.getEventType());
        event.setState("disabled");
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)event.getState());
        Image disabledImage = event.getImage();
        Assert.assertNotNull((Object)disabledImage);
        event.setState(TraceEnablement.ENABLED);
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)event.getState());
        Image enabledImage = event.getImage();
        Assert.assertNotNull((Object)enabledImage);
        Assert.assertNotSame((Object)enabledImage, (Object)disabledImage);
        event.setName(name);
        event.setLogLevel(level);
        event.setEventType(type);
        event.setState(state);
    }

    private static void verifyProbeEventGettersSetters(TraceProbeEventComponent event) {
        String address = event.getAddress();
        String offset = event.getOffset();
        String symbol = event.getSymbol();
        event.setAddress("0xffff1234");
        Assert.assertEquals((Object)"0xffff1234", (Object)event.getAddress());
        event.setOffset("0x1234");
        Assert.assertEquals((Object)"0x1234", (Object)event.getOffset());
        event.setSymbol("init");
        Assert.assertEquals((Object)"init", (Object)event.getSymbol());
        event.setAddress(address);
        event.setOffset(offset);
        event.setSymbol(symbol);
    }

    private static void verifyChannelGettersSetters(TraceChannelComponent channel) {
        String name = channel.getName();
        int nbSubBuffers = channel.getNumberOfSubBuffers();
        TraceChannelOutputType type = channel.getOutputType();
        boolean mode = channel.isOverwriteMode();
        long readTimer = channel.getReadTimer();
        TraceEnablement state = channel.getState();
        long subBufferSize = channel.getSubBufferSize();
        long switchTimer = channel.getSwitchTimer();
        channel.setName("newName");
        Assert.assertEquals((Object)"newName", (Object)channel.getName());
        channel.setNumberOfSubBuffers(2);
        Assert.assertEquals((long)2L, (long)channel.getNumberOfSubBuffers());
        channel.setOutputType("splice()");
        Assert.assertEquals((Object)"splice()", (Object)channel.getOutputType().getInName());
        Assert.assertEquals((Object)TraceChannelOutputType.SPLICE, (Object)channel.getOutputType());
        channel.setOverwriteMode(false);
        Assert.assertEquals((Object)false, (Object)channel.isOverwriteMode());
        channel.setReadTimer(250L);
        Assert.assertEquals((long)250L, (long)channel.getReadTimer());
        channel.setState("enabled");
        Assert.assertEquals((Object)TraceEnablement.ENABLED, (Object)channel.getState());
        Image enabledImage = channel.getImage();
        Assert.assertNotNull((Object)enabledImage);
        channel.setState(TraceEnablement.DISABLED);
        Assert.assertEquals((Object)TraceEnablement.DISABLED, (Object)channel.getState());
        Image disabledImage = channel.getImage();
        Assert.assertNotNull((Object)disabledImage);
        Assert.assertNotSame((Object)enabledImage, (Object)disabledImage);
        channel.setSubBufferSize(1024L);
        Assert.assertEquals((long)1024L, (long)channel.getSubBufferSize());
        channel.setSwitchTimer(1000L);
        Assert.assertEquals((long)1000L, (long)channel.getSwitchTimer());
        channel.setName(name);
        channel.setNumberOfSubBuffers(nbSubBuffers);
        channel.setOutputType(type);
        channel.setOverwriteMode(mode);
        channel.setReadTimer(readTimer);
        channel.setState(state);
        channel.setSubBufferSize(subBufferSize);
        channel.setSwitchTimer(switchTimer);
    }

    private static void verifyUstProviderGettersSetters(UstProviderComponent ustProvider) {
        String name = ustProvider.getName();
        int pid = ustProvider.getPid();
        ustProvider.setName("newName");
        Assert.assertEquals((Object)"newName", (Object)ustProvider.getName());
        ustProvider.setPid(9876);
        Assert.assertEquals((long)9876L, (long)ustProvider.getPid());
        ustProvider.setName(name);
        ustProvider.setPid(pid);
    }
}

