/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.ui.swtbot.tests;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfCpuSelectedSignal;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage.CpuUsageView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.tests.shared.CtfTmfTestTraceUtils;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.XYDataProviderBaseTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.swtchart.Chart;
import org.swtchart.ISeries;
import org.swtchart.LineStyle;

public class ResourcesAndCpuViewTest
extends XYDataProviderBaseTest {
    private static final RGB RED = new RGB(255, 0, 0);
    private static final RGB BLUE = new RGB(0, 0, 255);
    private static final RGB GREEN = new RGB(0, 255, 0);
    private static final @NonNull String TOTAL_SERIES_NAME = "total:bug446190";
    private static final @NonNull String TRACE_NAME = "bug446190";
    private static final @NonNull String TITLE = "CPU Usage";
    private static final @NonNull String SELECTED_THREAD = "lttng-sessiond";
    private static final @NonNull String SELECTED_THREAD_SERIES = "bug446190:482";
    private static final String OTHERTHREAD_SERIES = "bug446190:496";
    private static final String RESET = "Reset the Time Scale to Default";
    private static final @NonNull ITmfTimestamp TRACE_START = TmfTimestamp.fromNanos((long)1412670961211260539L);
    private static final @NonNull ITmfTimestamp TRACE_END = TmfTimestamp.fromNanos((long)1412670967217750839L);
    private static final @NonNull TmfTimeRange FULL_RANGE = new TmfTimeRange(TRACE_START, TRACE_END);
    private SWTBotView fResourcesViewBot;
    private String fTraceName = null;

    @Before
    public void setup() {
        super.setup();
        SWTBotUtils.openView((String)"org.eclipse.tracecompass.analysis.os.linux.views.resources");
        this.fResourcesViewBot = fBot.viewById("org.eclipse.tracecompass.analysis.os.linux.views.resources");
        this.getSWTBotView().setFocus();
    }

    @Test
    public void testSignals() {
        Widget widget = this.fResourcesViewBot.getWidget();
        Assert.assertNotNull((Object)widget);
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)activeTrace);
        TmfCpuSelectedSignal signal = new TmfCpuSelectedSignal((Object)widget, -1, activeTrace);
        ResourcesAndCpuViewTest.broadcast((TmfSignal)signal);
        Assert.assertEquals((String)"Before signal - CPU Usage Title", (Object)TITLE, (Object)this.getChartTitle());
        Assert.assertEquals((String)"Before signal - Thread Table", (long)12L, (long)this.getTableCount());
        this.fResourcesViewBot.setFocus();
        signal = new TmfCpuSelectedSignal((Object)widget, 1, activeTrace);
        ResourcesAndCpuViewTest.broadcast((TmfSignal)signal);
        Assert.assertEquals((String)"After signal - CPU Usage Title", (Object)"CPU Usage 1", (Object)this.getChartTitle());
        Assert.assertEquals((String)"After signal - Thread Table", (long)4L, (long)this.getTableCount());
        signal = new TmfCpuSelectedSignal((Object)widget, 3, activeTrace);
        ResourcesAndCpuViewTest.broadcast((TmfSignal)signal);
        Assert.assertEquals((String)"After signal 2 - CPU Usage Title", (Object)"CPU Usage 1, 3", (Object)this.getChartTitle());
        Assert.assertEquals((String)"After signal 2 - Thread Table", (long)8L, (long)this.getTableCount());
        signal = new TmfCpuSelectedSignal((Object)widget, -1, activeTrace);
        ResourcesAndCpuViewTest.broadcast((TmfSignal)signal);
        Assert.assertEquals((String)"After signal clear - CPU Usage Title", (Object)TITLE, (Object)this.getChartTitle());
        Assert.assertEquals((String)"After signal clear - Thread Table", (long)12L, (long)this.getTableCount());
    }

    @Test
    public void testCpuView() {
        IViewPart viewPart = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof CpuUsageView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)ResourcesAndCpuViewTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Chart chart = this.getChart();
        Assert.assertNotNull((Object)chart);
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length > 0, (Object)chart, (String)"No data available");
        chartViewer.setNbPoints(10);
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[0]), (Object)"resources/cpuusage/cpu-usage-res10.json", (String)"Chart data is not valid");
        this.verifySeriesStyle(TOTAL_SERIES_NAME, ISeries.SeriesType.LINE, BLUE, LineStyle.SOLID, false);
        SWTBotTreeItem rootEntry = this.getSWTBotView().bot().tree().getTreeItem(TRACE_NAME);
        SWTBotUtils.waitUntil(tree -> this.getTableCount() >= 8, (Object)rootEntry, (String)"Did not finish loading");
        SWTBotTreeItem selectedTheadNode = rootEntry.getNode(SELECTED_THREAD);
        selectedTheadNode.check();
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 2, (Object)chart, (String)"Only total available");
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{SELECTED_THREAD_SERIES}), (Object)"resources/cpuusage/cpu-usage-res10Selected.json", (String)"Chart data is not valid");
        this.verifySeriesStyle(SELECTED_THREAD_SERIES, ISeries.SeriesType.LINE, RED, LineStyle.SOLID, true);
        selectedTheadNode.uncheck();
        String otherSelectedThread = "lttng-consumerd";
        SWTBotTreeItem otherSelectedThreadNode = rootEntry.getNode(otherSelectedThread);
        otherSelectedThreadNode.check();
        chartViewer.setNbPoints(100);
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 2, (Object)chart, (String)"Only total available");
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{OTHERTHREAD_SERIES}), (Object)"resources/cpuusage/cpu-usage-res100Selected.json", (String)"Chart data is not valid");
        this.verifySeriesStyle(OTHERTHREAD_SERIES, ISeries.SeriesType.LINE, GREEN, LineStyle.SOLID, true);
        chartViewer.setNbPoints(10);
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 2, (Object)chart, (String)"Only total available");
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)activeTrace);
        this.fResourcesViewBot.getToolbarButtons().stream().filter(button -> button.getToolTipText().contains(RESET)).findAny().get().click();
        fBot.waitUntil(ConditionHelpers.windowRange((TmfTimeRange)new TmfTimeRange(TRACE_START, TRACE_END)));
        SWTBotUtils.waitUntil(c -> c.getSeriesSet().getSeries().length >= 2, (Object)chart, (String)"Only total available");
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        SWTBotUtils.waitUntil(json -> this.isChartDataValid(chart, (String)json, new String[]{OTHERTHREAD_SERIES}), (Object)"resources/cpuusage/cpu-usage-all-res10.json", (String)"Chart data is not valid");
        this.verifySeriesStyle(OTHERTHREAD_SERIES, ISeries.SeriesType.LINE, GREEN, LineStyle.SOLID, true);
    }

    @Test
    public void testResetTimeRange() {
        ITmfTrace activeTrace = TmfTraceManager.getInstance().getActiveTrace();
        Assert.assertNotNull((Object)activeTrace);
        IViewPart viewPart = this.getSWTBotView().getViewReference().getView(true);
        Assert.assertTrue((boolean)(viewPart instanceof CpuUsageView));
        TmfCommonXAxisChartViewer chartViewer = (TmfCommonXAxisChartViewer)ResourcesAndCpuViewTest.getChartViewer((IViewPart)viewPart);
        Assert.assertNotNull((Object)chartViewer);
        IWorkbenchPart part = this.fResourcesViewBot.getViewReference().getPart(false);
        Assert.assertTrue((boolean)(part instanceof AbstractTimeGraphView));
        AbstractTimeGraphView abstractTimeGraphView = (AbstractTimeGraphView)part;
        this.getSWTBotView().toolbarButton(RESET).click();
        this.assertChartRange(chartViewer, FULL_RANGE);
        this.fResourcesViewBot.setFocus();
        fBot.waitUntil(ConditionHelpers.timeGraphRangeCondition((AbstractTimeGraphView)abstractTimeGraphView, (ITmfTrace)activeTrace, (TmfTimeRange)FULL_RANGE));
        ResourcesAndCpuViewTest.broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)this, activeTrace.getInitialTimeRange(), activeTrace));
        this.fResourcesViewBot.toolbarButton(RESET).click();
        this.assertChartRange(chartViewer, FULL_RANGE);
        this.fResourcesViewBot.setFocus();
        fBot.waitUntil(ConditionHelpers.timeGraphRangeCondition((AbstractTimeGraphView)abstractTimeGraphView, (ITmfTrace)activeTrace, (TmfTimeRange)FULL_RANGE));
    }

    private void assertChartRange(TmfCommonXAxisChartViewer chartViewer, TmfTimeRange range) {
        this.getSWTBotView().setFocus();
        fBot.waitUntil(ConditionHelpers.xyViewerIsReadyCondition((TmfXYChartViewer)chartViewer));
        Assert.assertEquals((long)range.getStartTime().toNanos(), (long)chartViewer.getStartTime());
        Assert.assertEquals((long)range.getEndTime().toNanos(), (long)chartViewer.getEndTime());
    }

    protected String getMainSeriesName() {
        return TOTAL_SERIES_NAME;
    }

    protected String getTitle() {
        return TITLE;
    }

    protected String getViewID() {
        return "org.eclipse.tracecompass.analysis.os.linux.views.cpuusage";
    }

    protected ITmfTrace getTestTrace() {
        CtfTmfTrace trace = CtfTmfTestTraceUtils.getTrace((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER);
        this.fTraceName = trace.getName();
        return trace;
    }

    protected void disposeTestTrace() {
        CtfTmfTestTraceUtils.dispose((CtfTestTrace)CtfTestTrace.ARM_64_BIT_HEADER);
    }

    private static void broadcast(TmfSignal signal) {
        UIThreadRunnable.syncExec(() -> TmfSignalManager.dispatchSignal((TmfSignal)signal));
        WaitUtils.waitForJobs();
    }

    private String getChartTitle() {
        this.getSWTBotView().setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Chart.class);
        Chart chart = (Chart)this.getSWTBotView().bot().widget(matcher);
        return chart.getTitle().getText();
    }

    private int getTableCount() {
        this.getSWTBotView().setFocus();
        Matcher matcher = WidgetOfType.widgetOfType(Tree.class);
        SWTBotTree treeBot = new SWTBotTree((Tree)this.getSWTBotView().bot().widget(matcher));
        int count = 0;
        SWTBotTreeItem[] sWTBotTreeItemArray = treeBot.getTreeItem(this.fTraceName).getItems();
        int n = sWTBotTreeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem bot = sWTBotTreeItemArray[n2];
            String text = bot.getText();
            if (!text.isEmpty()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }
}

