/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.pcap.core.tests.perf.trace;

import java.io.IOException;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.BadPcapFileException;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapFile;
import org.eclipse.tracecompass.pcap.core.tests.shared.PcapTestTrace;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PcapReadBenchmark {
    private static final String TEST_SUITE_NAME = "Pcap Read Benchmark";
    private static final String TEST_ID = "org.eclipse.linuxtools#Pcap Read Benchmark";
    private static final int LOOP_COUNT = 25;
    private static final int RUN_BETWEEN_COMMIT_COUNT = 15;

    @Test
    public void testPcapTrace() {
        PcapReadBenchmark.readTrace(PcapTestTrace.BENCHMARK_TRACE, "trace-pcap", true);
    }

    private static void readTrace(PcapTestTrace testTrace, String testName, boolean inGlobalSummary) {
        Assume.assumeTrue((boolean)testTrace.exists());
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter("org.eclipse.linuxtools#Pcap Read Benchmark#" + testName);
        perf.tagAsSummary(pm, "Pcap Read Benchmark:" + testName, Dimension.CPU_TIME);
        if (inGlobalSummary) {
            perf.tagAsGlobalSummary(pm, "Pcap Read Benchmark:" + testName, Dimension.CPU_TIME);
        }
        int loop = 0;
        while (loop < 25) {
            pm.start();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (PcapFile trace = testTrace.getTrace();){
                    int i = 0;
                    while (i < 15) {
                        PcapPacket packet;
                        trace.seekPacket(0L);
                        while ((packet = trace.parseNextPacket()) != null) {
                            packet.getPayload();
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | BadPacketException | BadPcapFileException e) {
                Assert.fail((String)("Test failed at iteration " + loop + ':' + e.getMessage()));
            }
            pm.stop();
            ++loop;
        }
        pm.commit();
    }
}

