/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language.settings.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LanguageSettingsSerializableStorage
extends LanguageSettingsStorage {
    private static final String ELEM_LANGUAGE = "language";
    private static final String ATTR_LANGUAGE_ID = "id";
    private static final String ELEM_RESOURCE = "resource";
    private static final String ATTR_PROJECT_PATH = "project-relative-path";
    private static final String ELEM_ENTRY = "entry";
    private static final String ATTR_ENTRY_KIND = "kind";
    private static final String ATTR_ENTRY_NAME = "name";
    private static final String ATTR_ENTRY_VALUE = "value";
    private static final String ELEM_ENTRY_FLAG = "flag";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeEntries(Element elementProvider) {
        Map map = this.fStorage;
        synchronized (map) {
            for (Map.Entry entryLang : this.fStorage.entrySet()) {
                this.serializeLanguage(elementProvider, (String)entryLang.getKey(), (Map)entryLang.getValue());
            }
        }
    }

    private void serializeLanguage(Element parentElement, String langId, Map<String, List<ICLanguageSettingEntry>> langMap) {
        if (langId != null) {
            Element elementLanguage;
            parentElement = elementLanguage = XmlUtil.appendElement(parentElement, ELEM_LANGUAGE, new String[]{ATTR_LANGUAGE_ID, langId});
        }
        for (Map.Entry<String, List<ICLanguageSettingEntry>> entryRc : langMap.entrySet()) {
            this.serializeResource(parentElement, entryRc.getKey(), entryRc.getValue());
        }
    }

    private void serializeResource(Element parentElement, String rcProjectPath, List<ICLanguageSettingEntry> rcList) {
        if (rcProjectPath != null) {
            Element elementRc;
            parentElement = elementRc = XmlUtil.appendElement(parentElement, ELEM_RESOURCE, new String[]{ATTR_PROJECT_PATH, rcProjectPath});
        }
        this.serializeSettingEntries(parentElement, rcList);
    }

    private void serializeSettingEntries(Element parentElement, List<ICLanguageSettingEntry> settingEntries) {
        for (ICLanguageSettingEntry entry : settingEntries) {
            Element elementSettingEntry = XmlUtil.appendElement(parentElement, ELEM_ENTRY, new String[]{ATTR_ENTRY_KIND, LanguageSettingEntriesSerializer.kindToString(entry.getKind()), ATTR_ENTRY_NAME, entry.getName()});
            switch (entry.getKind()) {
                case 4: {
                    elementSettingEntry.setAttribute(ATTR_ENTRY_VALUE, entry.getValue());
                }
            }
            int flags = entry.getFlags();
            if (flags == 0) continue;
            XmlUtil.appendElement(elementSettingEntry, ELEM_ENTRY_FLAG, new String[]{ATTR_ENTRY_VALUE, LanguageSettingEntriesSerializer.composeFlagsString(entry.getFlags())});
        }
    }

    public void loadEntries(Element providerNode) {
        ArrayList<ICLanguageSettingEntry> settings = new ArrayList<ICLanguageSettingEntry>();
        NodeList nodes = providerNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node elementNode = nodes.item(i);
            if (elementNode.getNodeType() == 1) {
                ICLanguageSettingEntry entry;
                if (ELEM_LANGUAGE.equals(elementNode.getNodeName())) {
                    this.loadLanguageElement(elementNode, null);
                } else if (ELEM_RESOURCE.equals(elementNode.getNodeName())) {
                    this.loadResourceElement(elementNode, null, null);
                } else if (ELEM_ENTRY.equals(elementNode.getNodeName()) && (entry = this.loadSettingEntry(elementNode)) != null) {
                    settings.add(entry);
                }
            }
            ++i;
        }
        if (settings.size() > 0) {
            this.setSettingEntries(null, null, settings);
        }
    }

    private ICLanguageSettingEntry loadSettingEntry(Node parentElement) {
        String settingKind = XmlUtil.determineAttributeValue(parentElement, ATTR_ENTRY_KIND);
        String settingName = XmlUtil.determineAttributeValue(parentElement, ATTR_ENTRY_NAME);
        NodeList flagNodes = parentElement.getChildNodes();
        int flags = 0;
        int i = 0;
        while (i < flagNodes.getLength()) {
            Node flagNode = flagNodes.item(i);
            if (flagNode.getNodeType() == 1 && ELEM_ENTRY_FLAG.equals(flagNode.getNodeName())) {
                String settingFlags = XmlUtil.determineAttributeValue(flagNode, ATTR_ENTRY_VALUE);
                int bitFlag = LanguageSettingEntriesSerializer.composeFlags(settingFlags);
                flags |= bitFlag;
            }
            ++i;
        }
        String settingValue = null;
        int kind = LanguageSettingEntriesSerializer.stringToKind(settingKind);
        if (kind == 4) {
            settingValue = XmlUtil.determineAttributeValue(parentElement, ATTR_ENTRY_VALUE);
        }
        ICLanguageSettingEntry entry = (ICLanguageSettingEntry)CDataUtil.createEntry(kind, settingName, settingValue, null, flags);
        return entry;
    }

    private void loadLanguageElement(Node parentNode, String cfgId) {
        String langId = XmlUtil.determineAttributeValue(parentNode, ATTR_LANGUAGE_ID);
        if (langId.length() == 0) {
            langId = null;
        }
        ArrayList<ICLanguageSettingEntry> settings = new ArrayList<ICLanguageSettingEntry>();
        NodeList nodes = parentNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node elementNode = nodes.item(i);
            if (elementNode.getNodeType() == 1) {
                ICLanguageSettingEntry entry;
                if (ELEM_RESOURCE.equals(elementNode.getNodeName())) {
                    this.loadResourceElement(elementNode, cfgId, langId);
                } else if (ELEM_ENTRY.equals(elementNode.getNodeName()) && (entry = this.loadSettingEntry(elementNode)) != null) {
                    settings.add(entry);
                }
            }
            ++i;
        }
        if (settings.size() > 0) {
            this.setSettingEntries(null, langId, settings);
        }
    }

    private void loadResourceElement(Node parentNode, String cfgId, String langId) {
        String rcProjectPath = XmlUtil.determineAttributeValue(parentNode, ATTR_PROJECT_PATH);
        ArrayList<ICLanguageSettingEntry> settings = new ArrayList<ICLanguageSettingEntry>();
        NodeList nodes = parentNode.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            ICLanguageSettingEntry entry;
            Node elementNode = nodes.item(i);
            if (elementNode.getNodeType() == 1 && ELEM_ENTRY.equals(elementNode.getNodeName()) && (entry = this.loadSettingEntry(elementNode)) != null) {
                settings.add(entry);
            }
            ++i;
        }
        if (settings.size() > 0) {
            this.setSettingEntries(rcProjectPath, langId, settings);
        }
    }

    @Override
    public LanguageSettingsSerializableStorage clone() throws CloneNotSupportedException {
        return (LanguageSettingsSerializableStorage)super.clone();
    }
}

