/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import com.ibm.icu.text.DateFormat;
import java.net.URI;
import java.util.Date;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.StorageTypedElement;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.ui.IEditorInput;

public class FileRevisionTypedElement
extends StorageTypedElement {
    private IFileRevision fileRevision;
    private String author;

    public FileRevisionTypedElement(IFileRevision fileRevision) {
        this(fileRevision, null);
    }

    public FileRevisionTypedElement(IFileRevision fileRevision, String localEncoding) {
        super(localEncoding);
        Assert.isNotNull((Object)fileRevision);
        this.fileRevision = fileRevision;
    }

    public String getName() {
        return this.fileRevision.getName();
    }

    @Override
    protected IStorage fetchContents(IProgressMonitor monitor) throws CoreException {
        return this.fileRevision.getStorage(monitor);
    }

    public String getContentIdentifier() {
        return this.fileRevision.getContentIdentifier();
    }

    public String getTimestamp() {
        long date = this.fileRevision.getTimestamp();
        Date dateFromLong = new Date(date);
        return DateFormat.getDateTimeInstance().format(dateFromLong);
    }

    public IFileRevision getFileRevision() {
        return this.fileRevision;
    }

    public String getPath() {
        URI uri = this.fileRevision.getURI();
        if (uri != null) {
            return uri.getPath();
        }
        return this.getName();
    }

    @Override
    public IEditorInput getDocumentKey(Object element) {
        if (element == this && this.getBufferedStorage() != null) {
            return new FileRevisionEditorInput(this.fileRevision, this.getBufferedStorage(), this.getLocalEncoding());
        }
        return null;
    }

    public int hashCode() {
        return this.fileRevision.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileRevisionTypedElement) {
            FileRevisionTypedElement other = (FileRevisionTypedElement)obj;
            return other.getFileRevision().equals(this.getFileRevision());
        }
        return false;
    }

    public String getAuthor() {
        if (this.author == null) {
            this.author = this.fileRevision.getAuthor();
        }
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void fetchAuthor(IProgressMonitor monitor) throws CoreException {
        if (this.getAuthor() == null && this.fileRevision.isPropertyMissing()) {
            IFileRevision other = this.fileRevision.withAllProperties(monitor);
            this.author = other.getAuthor();
        }
    }

    public IFileRevision getRevision() {
        return this.fileRevision;
    }
}

