/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.tree;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;

public abstract class AbstractTmfTreeViewer
extends TmfTimeViewer {
    private static final ISelection EMPTY_SELECTION = StructuredSelection.EMPTY;
    private final TreeViewer fTreeViewer;

    public AbstractTmfTreeViewer(Composite parent, boolean allowMultiSelect) {
        this(parent, new TreeViewer(parent, 0x10100 | (allowMultiSelect ? 2 : 0)));
    }

    public AbstractTmfTreeViewer(Composite parent, TreeViewer treeViewer) {
        super(parent);
        this.fTreeViewer = treeViewer;
        this.fTreeViewer.setAutoExpandLevel(-1);
        Tree tree = this.fTreeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.fTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        List<TmfTreeColumnData> columns = this.getColumnDataProvider().getColumnData();
        this.setTreeColumns(columns);
    }

    protected abstract ITmfTreeColumnDataProvider getColumnDataProvider();

    public void setTreeColumns(List<TmfTreeColumnData> columns) {
        boolean hasPercentProvider = false;
        for (TmfTreeColumnData columnData : columns) {
            columnData.createColumn(this.fTreeViewer);
            hasPercentProvider |= columnData.getPercentageProvider() != null;
        }
        if (hasPercentProvider) {
            this.fTreeViewer.getTree().addListener(40, event -> {
                if (((TmfTreeColumnData)columns.get(event.index)).getPercentageProvider() != null) {
                    double percentage = ((TmfTreeColumnData)columns.get(event.index)).getPercentageProvider().getPercentage(event.item.getData());
                    if (percentage == 0.0) {
                        return;
                    }
                    if ((event.detail & 2) > 0) {
                        event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                        event.detail &= 0xFFFFFFFD;
                    }
                    int barWidth = (int)((double)(this.fTreeViewer.getTree().getColumn(event.index).getWidth() - 8) * percentage);
                    int oldAlpha = event.gc.getAlpha();
                    Color oldForeground = event.gc.getForeground();
                    Color oldBackground = event.gc.getBackground();
                    event.gc.setAlpha(64);
                    event.gc.setForeground(event.item.getDisplay().getSystemColor(9));
                    event.gc.setBackground(event.item.getDisplay().getSystemColor(25));
                    event.gc.fillGradientRectangle(event.x, event.y, barWidth, event.height, true);
                    event.gc.drawRectangle(event.x, event.y, barWidth, event.height);
                    event.gc.setForeground(oldForeground);
                    event.gc.setBackground(oldBackground);
                    event.gc.setAlpha(oldAlpha);
                    event.detail &= 0xFFFFFFF7;
                }
            });
        }
    }

    protected void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.fTreeViewer.setLabelProvider(labelProvider);
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    @Override
    public Control getControl() {
        return this.fTreeViewer.getControl();
    }

    @Override
    public void refresh() {
        Tree tree = this.fTreeViewer.getTree();
        tree.setRedraw(false);
        this.fTreeViewer.refresh();
        tree.setRedraw(true);
    }

    @Override
    public void loadTrace(final ITmfTrace trace) {
        super.loadTrace(trace);
        if (trace == null) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                AbstractTmfTreeViewer.this.initializeDataSource(trace);
                Display.getDefault().asyncExec(() -> {
                    if (!trace.equals(AbstractTmfTreeViewer.this.getTrace())) {
                        return;
                    }
                    AbstractTmfTreeViewer.this.clearContent();
                    AbstractTmfTreeViewer.this.updateContent(AbstractTmfTreeViewer.this.getWindowStartTime(), AbstractTmfTreeViewer.this.getWindowEndTime(), false);
                });
            }
        };
        thread.start();
    }

    public void setSelection(@NonNull List<ITmfTreeViewerEntry> selection) {
        StructuredSelection sel = new StructuredSelection(selection);
        this.fTreeViewer.setSelection((ISelection)sel, true);
    }

    public void addSelectionChangeListener(ISelectionChangedListener listener) {
        this.fTreeViewer.addSelectionChangedListener(listener);
    }

    protected void initializeDataSource(@NonNull ITmfTrace trace) {
    }

    protected void clearContent() {
        this.fTreeViewer.setInput(null);
    }

    protected void contentChanged(ITmfTreeViewerEntry rootEntry) {
    }

    protected void updateContent(final long start, final long end, final boolean isSelection) {
        final ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        Job thread = new Job(""){

            public IStatus run(IProgressMonitor monitor) {
                ITmfTreeViewerEntry newRootEntry = AbstractTmfTreeViewer.this.updateElements(trace, start, end, isSelection);
                if (newRootEntry != null) {
                    Display.getDefault().asyncExec(() -> {
                        if (AbstractTmfTreeViewer.this.fTreeViewer.getControl().isDisposed()) {
                            return;
                        }
                        Object input = AbstractTmfTreeViewer.this.fTreeViewer.getInput();
                        if (newRootEntry != input) {
                            void var7_13;
                            StructuredSelection structuredSelection;
                            Object selected;
                            ISelection selection = AbstractTmfTreeViewer.this.fTreeViewer.getSelection();
                            if (!selection.isEmpty() && selection instanceof StructuredSelection && (selected = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof ITmfTreeViewerEntry) {
                                ITmfTreeViewerEntry newSelection = AbstractTmfTreeViewer.findEquivalent(newRootEntry, (ITmfTreeViewerEntry)selected);
                                selection = newSelection != null ? new StructuredSelection((Object)newSelection) : EMPTY_SELECTION;
                            }
                            Object[] expandedElements = AbstractTmfTreeViewer.this.fTreeViewer.getExpandedElements();
                            HashSet<String> expandedPaths = new HashSet<String>();
                            Object[] objectArray = expandedElements;
                            int n = expandedElements.length;
                            boolean n2 = false;
                            while (var7_13 < n) {
                                Object element = objectArray[var7_13];
                                if (element instanceof ITmfTreeViewerEntry) {
                                    expandedPaths.add(AbstractTmfTreeViewer.getPath((ITmfTreeViewerEntry)element).toString());
                                }
                                ++var7_13;
                            }
                            HashSet allPaths = new HashSet();
                            if (input instanceof ITmfTreeViewerEntry) {
                                for (ITmfTreeViewerEntry iTmfTreeViewerEntry2 : ((ITmfTreeViewerEntry)input).getChildren()) {
                                    AbstractTmfTreeViewer.this.add(allPaths, iTmfTreeViewerEntry2);
                                }
                            }
                            HashSet<@NonNull E> hashSet = new HashSet();
                            AbstractTmfTreeViewer.this.addIf(hashSet, newRootEntry, entry -> {
                                String key = AbstractTmfTreeViewer.getPath(entry).toString();
                                return expandedPaths.contains(key) || !allPaths.contains(key);
                            });
                            AbstractTmfTreeViewer.this.fTreeViewer.setInput((Object)newRootEntry);
                            AbstractTmfTreeViewer.this.contentChanged(newRootEntry);
                            if (!selection.isEmpty()) {
                                AbstractTmfTreeViewer.this.fTreeViewer.setSelection(selection, true);
                            }
                            AbstractTmfTreeViewer.this.fTreeViewer.setExpandedElements(hashSet.toArray());
                        } else {
                            AbstractTmfTreeViewer.this.fTreeViewer.refresh();
                        }
                        TreeColumn[] treeColumnArray = AbstractTmfTreeViewer.this.fTreeViewer.getTree().getColumns();
                        int n = treeColumnArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            TreeColumn column = treeColumnArray[n3];
                            column.pack();
                            ++n3;
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        thread.setSystem(true);
        thread.schedule();
    }

    private void addIf(Collection<@NonNull ITmfTreeViewerEntry> toAdd, @NonNull ITmfTreeViewerEntry parent, Predicate<@NonNull ITmfTreeViewerEntry> condition) {
        if (condition.test(parent) && parent.hasChildren()) {
            toAdd.add(parent);
        }
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : parent.getChildren()) {
            if (!iTmfTreeViewerEntry.hasChildren()) continue;
            this.addIf(toAdd, iTmfTreeViewerEntry, condition);
        }
    }

    private static Deque<String> getPath(@NonNull ITmfTreeViewerEntry entry) {
        ArrayDeque<String> retVal = new ArrayDeque<String>();
        ITmfTreeViewerEntry current = entry;
        while (current.getParent() != null) {
            retVal.addFirst(current.getName());
            current = current.getParent();
        }
        return retVal;
    }

    private static ITmfTreeViewerEntry findEquivalent(@NonNull ITmfTreeViewerEntry entriesToSearch, @NonNull ITmfTreeViewerEntry selectedItem) {
        Deque<String> path = AbstractTmfTreeViewer.getPath(selectedItem);
        Iterator<String> iter = path.iterator();
        ITmfTreeViewerEntry currentEntry = entriesToSearch;
        while (iter.hasNext()) {
            String current = iter.next();
            boolean found = false;
            for (ITmfTreeViewerEntry iTmfTreeViewerEntry : currentEntry.getChildren()) {
                if (!Objects.equals(iTmfTreeViewerEntry.getName(), current)) continue;
                found = true;
                currentEntry = iTmfTreeViewerEntry;
                break;
            }
            if (found) continue;
            return null;
        }
        return currentEntry;
    }

    private void add(Collection<String> collection, @NonNull ITmfTreeViewerEntry entry) {
        collection.add(AbstractTmfTreeViewer.getPath(entry).toString());
        for (ITmfTreeViewerEntry iTmfTreeViewerEntry : entry.getChildren()) {
            if (!iTmfTreeViewerEntry.hasChildren()) continue;
            this.add(collection, iTmfTreeViewerEntry);
        }
    }

    protected abstract ITmfTreeViewerEntry updateElements(@NonNull ITmfTrace var1, long var2, long var4, boolean var6);

    protected ITmfTreeViewerEntry getInput() {
        return (ITmfTreeViewerEntry)this.fTreeViewer.getInput();
    }

    public void setAutoExpandLevel(int level) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setAutoExpandLevel(level);
        }
    }

    @Override
    @TmfSignalHandler
    public void windowRangeUpdated(TmfWindowRangeUpdatedSignal signal) {
        super.windowRangeUpdated(signal);
        this.updateContent(this.getWindowStartTime(), this.getWindowEndTime(), false);
    }

    @Override
    public void reset() {
        super.reset();
        this.clearContent();
    }

    private class TreeContentProvider
    implements ITreeContentProvider {
        private TreeContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ITmfTreeViewerEntry) {
                return ((ITmfTreeViewerEntry)inputElement).getChildren().toArray(new ITmfTreeViewerEntry[0]);
            }
            return new ITmfTreeViewerEntry[0];
        }

        public Object[] getChildren(Object parentElement) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)parentElement;
            List<? extends ITmfTreeViewerEntry> children = entry.getChildren();
            return children.toArray(new ITmfTreeViewerEntry[children.size()]);
        }

        public Object getParent(Object element) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
            return entry.getParent();
        }

        public boolean hasChildren(Object element) {
            ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
            return entry.hasChildren();
        }
    }

    protected static class TreeLabelProvider
    implements ITableLabelProvider,
    ITableFontProvider,
    ITableColorProvider {
        protected TreeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ITmfTreeViewerEntry && columnIndex == 0) {
                ITmfTreeViewerEntry entry = (ITmfTreeViewerEntry)element;
                return entry.getName();
            }
            return new String();
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            return null;
        }
    }
}

