/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.swtbot.tests.views;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.tmf.core.model.TmfXyResponseFactory;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXyModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;

public class XYChartViewStub
extends TmfChartView {
    public static final String ID = "org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart.stub";
    public static final @NonNull String PROVIDER_ID = "org.eclipse.tracecompass.tmf.ui.swtbot.tests.views.xychart.stub.provider";
    public static final String VIEW_TITLE = "XY Chart View Stub";

    public XYChartViewStub() {
        super(VIEW_TITLE);
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        TmfXYChartSettings settings = new TmfXYChartSettings(null, null, null, 1.0);
        return new TmfFilteredXYChartViewer(parent, settings, PROVIDER_ID){

            protected ITmfXYDataProvider initializeDataProvider(@NonNull ITmfTrace trace) {
                return new MyTmfXyDataProvider();
            }
        };
    }

    protected @NonNull TmfViewer createLeftChildViewer(Composite parent) {
        return new MyAbsractSelectTreeViewer(parent, PROVIDER_ID);
    }

    private class MyAbsractSelectTreeViewer
    extends AbstractSelectTreeViewer {
        public MyAbsractSelectTreeViewer(Composite parent, String id) {
            super(parent, 1, id);
            this.setLabelProvider((IBaseLabelProvider)new MyTreeLabelProvider());
        }

        protected ITmfTreeColumnDataProvider getColumnDataProvider() {
            return () -> ImmutableList.of((Object)MyAbsractSelectTreeViewer.createColumn((String)"Name", Comparator.comparing(TmfTreeViewerEntry::getName)), (Object)new TmfTreeColumnData("Legend"));
        }

        protected ITmfTreeDataProvider<@NonNull ITmfTreeDataModel> getProvider(@NonNull ITmfTrace trace) {
            return new MyTmfXyDataProvider();
        }

        class MyTreeLabelProvider
        extends AbstractTmfTreeViewer.TreeLabelProvider {
            MyTreeLabelProvider() {
            }
        }
    }

    private class MyTmfXyDataProvider
    implements ITmfTreeXYDataProvider<ITmfTreeDataModel> {
        private MyTmfXyDataProvider() {
        }

        public final TmfModelResponse<ITmfXyModel> fetchXY(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
            List xValues = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
            if (xValues == null) {
                return TmfXyResponseFactory.createFailedResponse((String)"No requested time values provided");
            }
            double[] yValues = new double[xValues.size()];
            int i = 0;
            while (i < yValues.length) {
                yValues[i] = (double)((Long)xValues.get(i)).longValue() * 1.0E-6;
                ++i;
            }
            @NonNull YModel series = new YModel(1L, "Top", yValues);
            Map<@NonNull String, @NonNull YModel> yModels = Collections.singletonMap(Long.toString(series.getId()), series);
            return TmfXyResponseFactory.create((String)"Top", (long[])Objects.requireNonNull(Longs.toArray((Collection)xValues)), yModels, (boolean)true);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public final TmfModelResponse<TmfTreeModel<@NonNull ITmfTreeDataModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
            @NonNull List<@NonNull TmfTreeDataModel> list = Collections.singletonList(new TmfTreeDataModel(1L, -1L, "Top"));
            @NonNull TmfTreeModel tree = new TmfTreeModel(Collections.emptyList(), list);
            return new TmfModelResponse((Object)tree, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }

        public @NonNull String getId() {
            return XYChartViewStub.PROVIDER_ID;
        }
    }
}

