/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.backend;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public interface IStateHistoryBackend {
    public @NonNull String getSSID();

    public long getStartTime();

    public long getEndTime();

    default public void insertPastState(long stateStartTime, long stateEndTime, int quark, @Nullable Object value) throws TimeRangeException {
        this.insertPastState(stateStartTime, stateEndTime, quark, TmfStateValue.newValue(value));
    }

    public void finishedBuilding(long var1) throws TimeRangeException;

    public FileInputStream supplyAttributeTreeReader();

    public File supplyAttributeTreeWriterFile();

    public long supplyAttributeTreeWriterFilePosition();

    public void removeFiles();

    public void dispose();

    public void doQuery(@NonNull List<@Nullable ITmfStateInterval> var1, long var2) throws TimeRangeException, StateSystemDisposedException;

    public ITmfStateInterval doSingularQuery(long var1, int var3) throws TimeRangeException, StateSystemDisposedException;

    default public Iterable<@NonNull ITmfStateInterval> query2D(IntegerRangeCondition quarkCondition, TimeRangeCondition timeCondition) throws TimeRangeException {
        throw new UnsupportedOperationException("This backend does not support 2D queries");
    }

    default public Iterable<@NonNull ITmfStateInterval> query2D(IntegerRangeCondition quarkCondition, TimeRangeCondition timeCondition, boolean reverse) throws TimeRangeException {
        return this.query2D(quarkCondition, timeCondition);
    }
}

