/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.IStylePresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.XYPresentationProvider;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.model.StyleManager;

public class BaseXYPresentationProvider
extends XYPresentationProvider
implements IStylePresentationProvider {
    private final List<ITmfTreeXYDataProvider<?>> fProviders = new ArrayList();
    private StyleManager fStyleManager = StyleManager.empty();
    private @Nullable Map<String, OutputElementStyle> fStylesMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProvider(ITmfTreeXYDataProvider<?> provider) {
        List<ITmfTreeXYDataProvider<?>> list = this.fProviders;
        synchronized (list) {
            this.fProviders.add(provider);
        }
        Display.getDefault().asyncExec(() -> this.refresh());
    }

    private void refresh() {
        this.fStylesMap = null;
        this.fStyleManager = new StyleManager(this.fetchStyles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<@NonNull String, @NonNull OutputElementStyle> fetchStyles() {
        Map<String, OutputElementStyle> stylesMap = this.fStylesMap;
        if (stylesMap == null) {
            stylesMap = new LinkedHashMap<String, OutputElementStyle>();
            List<ITmfTreeXYDataProvider<?>> list = this.fProviders;
            synchronized (list) {
                for (ITmfTreeXYDataProvider<?> provider : this.fProviders) {
                    TmfModelResponse styleResponse;
                    OutputStyleModel styleModel;
                    if (!(provider instanceof IOutputStyleProvider) || (styleModel = (OutputStyleModel)(styleResponse = ((IOutputStyleProvider)provider).fetchStyle(this.getStyleParameters(), null)).getModel()) == null) continue;
                    for (Map.Entry entry : styleModel.getStyles().entrySet()) {
                        OutputElementStyle style = (OutputElementStyle)entry.getValue();
                        stylesMap.put((String)entry.getKey(), new OutputElementStyle(style.getParentKey(), (Map)Maps.newHashMap((Map)style.getStyleValues())));
                    }
                }
            }
            this.fStylesMap = stylesMap;
        }
        return stylesMap;
    }

    protected Map<String, Object> getStyleParameters() {
        return Collections.emptyMap();
    }

    @Override
    public StyleManager getStyleManager() {
        return this.fStyleManager;
    }

    @Override
    public @Nullable Object getStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getStyle(elementStyle, property);
    }

    @Override
    public @Nullable Float getFloatStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getFactorStyle(elementStyle, property);
    }

    @Override
    public @Nullable RGBAColor getColorStyle(OutputElementStyle elementStyle, String property) {
        return this.fStyleManager.getColorStyle(elementStyle, property);
    }

    public Object getStyleOrDefault(OutputElementStyle elementStyle, String property, Object defaultValue) {
        Object style = this.fStyleManager.getStyle(elementStyle, property);
        return style == null ? defaultValue : style;
    }

    public Float getFloatStyleOrDefault(OutputElementStyle elementStyle, String property, Float defaultValue) {
        Float style = this.fStyleManager.getFactorStyle(elementStyle, property);
        return style == null ? defaultValue : style;
    }

    public RGBAColor getColorStyleOrDefault(OutputElementStyle elementStyle, String property, RGBAColor defaultValue) {
        RGBAColor style = this.fStyleManager.getColorStyle(elementStyle, property);
        return style == null ? defaultValue : style;
    }
}

