/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileLock;
import org.eclipse.help.internal.standalone.Eclipse;
import org.eclipse.help.internal.standalone.EclipseConnection;
import org.eclipse.help.internal.standalone.EclipseLifeCycleListener;
import org.eclipse.help.internal.standalone.Options;

public class EclipseController
implements EclipseLifeCycleListener {
    public static final String CMD_INSTALL = "install";
    public static final String CMD_UPDATE = "update";
    public static final String CMD_ENABLE = "enable";
    public static final String CMD_DISABLE = "disable";
    public static final String CMD_UNINSTALL = "uninstall";
    public static final String CMD_SEARCH = "search";
    public static final String CMD_LIST = "listFeatures";
    public static final String CMD_ADDSITE = "addSite";
    public static final String CMD_REMOVESITE = "removeSite";
    public static final String CMD_APPLY = "apply";
    private static final String CONTROL_SERVLET_PATH = "/help/control";
    protected String applicationId;
    protected EclipseConnection connection;
    public Eclipse eclipse = null;
    private FileLock lock;
    private RandomAccessFile raf;
    private boolean eclipseEnded = false;

    public EclipseController(String applicationId, String[] args) {
        this.applicationId = applicationId;
        Options.init(applicationId, args);
        this.connection = new EclipseConnection();
    }

    public final synchronized void shutdown() throws Exception {
        try {
            try {
                this.obtainLock();
                this.sendHelpCommandInternal("shutdown", new String[0]);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
                this.releaseLock();
            }
            catch (InterruptedException interruptedException) {
                this.releaseLock();
            }
        }
        finally {
            this.releaseLock();
        }
    }

    public final synchronized void start() throws Exception {
        try {
            this.obtainLock();
            this.startEclipse();
        }
        finally {
            this.releaseLock();
        }
    }

    protected final synchronized void sendHelpCommand(String command, String[] parameters) throws Exception {
        try {
            this.obtainLock();
            this.sendHelpCommandInternal(command, parameters);
        }
        finally {
            this.releaseLock();
        }
    }

    private void startEclipse() throws Exception {
        boolean fullyRunning = this.isApplicationRunning();
        if (fullyRunning) {
            return;
        }
        if (Options.isDebug()) {
            System.out.println("Using workspace " + Options.getWorkspace().getAbsolutePath());
        }
        Options.getConnectionFile().delete();
        this.connection.reset();
        if (Options.isDebug()) {
            System.out.println("Ensured old .connection file is deleted.  Launching Eclipse.");
        }
        this.eclipseEnded = false;
        this.eclipse = new Eclipse(this);
        this.eclipse.start();
        fullyRunning = this.isApplicationRunning();
        while (!this.eclipseEnded && !fullyRunning) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            fullyRunning = this.isApplicationRunning();
        }
        if (this.eclipseEnded) {
            if (this.eclipse.getStatus() == 2) {
                throw this.eclipse.getException();
            }
            return;
        }
        if (Options.isDebug()) {
            System.out.println("Eclipse launched");
        }
        Runtime.getRuntime().addShutdownHook(new EclipseCleaner());
    }

    private void sendHelpCommandInternal(String command, String[] parameters) throws Exception {
        block10: {
            if (!"shutdown".equalsIgnoreCase(command)) {
                this.startEclipse();
            }
            if (!this.isApplicationRunning()) {
                return;
            }
            if (!this.connection.isValid()) {
                this.connection.renew();
            }
            try {
                String trustStorePassword;
                String trustStoreLocation = Options.getTrustStoreLocation();
                if (trustStoreLocation != null) {
                    System.setProperty("javax.net.ssl.trustStore", trustStoreLocation);
                }
                if ((trustStorePassword = Options.getTrustStorePassword()) != null) {
                    System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
                }
                URL url = this.createCommandURL(command, parameters);
                if ("shutdown".equalsIgnoreCase(command) && Options.getConnectionFile().exists()) {
                    this.connection.connect(url);
                    long timeLimit = System.currentTimeMillis() + 60000L;
                    while (Options.getConnectionFile().exists()) {
                        Thread.sleep(200L);
                        if (System.currentTimeMillis() <= timeLimit) continue;
                        System.out.println("Shutting down is taking too long.  Will not wait.");
                        break block10;
                    }
                    break block10;
                }
                this.connection.connect(url);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private URL createCommandURL(String command, String[] parameters) throws MalformedURLException {
        StringBuilder urlStr = new StringBuilder();
        urlStr.append("http://");
        urlStr.append(this.connection.getHost());
        urlStr.append(":");
        urlStr.append(this.connection.getPort());
        urlStr.append(CONTROL_SERVLET_PATH);
        urlStr.append("?command=");
        urlStr.append(command);
        int i = 0;
        while (i < parameters.length) {
            urlStr.append("&");
            urlStr.append(parameters[i]);
            ++i;
        }
        if (Options.isDebug()) {
            System.out.println("Control servlet URL=" + urlStr.toString());
        }
        return new URL(urlStr.toString());
    }

    @Override
    public void eclipseEnded() {
        this.eclipseEnded = true;
        this.connection.reset();
    }

    private void obtainLock() throws IOException {
        if (this.lock != null) {
            return;
        }
        if (!Options.getLockFile().exists()) {
            Options.getLockFile().getParentFile().mkdirs();
        }
        this.raf = new RandomAccessFile(Options.getLockFile(), "rw");
        this.lock = this.raf.getChannel().lock();
        if (Options.isDebug()) {
            System.out.println("Lock obtained.");
        }
    }

    private void releaseLock() {
        if (this.lock != null) {
            try {
                this.lock.channel().close();
                if (Options.isDebug()) {
                    System.out.println("Lock released.");
                }
                this.lock = null;
            }
            catch (IOException iOException) {}
        }
        if (this.raf != null) {
            try {
                this.raf.close();
            }
            catch (IOException iOException) {}
            this.raf = null;
        }
    }

    private boolean isApplicationRunning() {
        FileLock applicationLock;
        block26: {
            File applicationLockFile = new File(Options.getLockFile().getParentFile(), ".applicationlock");
            applicationLock = null;
            try {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (RandomAccessFile randomAccessFile = new RandomAccessFile(applicationLockFile, "rw");){
                        applicationLock = randomAccessFile.getChannel().tryLock();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    if (applicationLock != null) {
                        try {
                            applicationLock.release();
                        }
                        catch (IOException iOException2) {}
                    }
                    if (Options.isDebug()) {
                        System.out.println("isApplicationRunning? " + (applicationLock == null));
                    }
                    break block26;
                }
            }
            catch (Throwable throwable) {
                if (applicationLock != null) {
                    try {
                        applicationLock.release();
                    }
                    catch (IOException iOException) {}
                }
                if (Options.isDebug()) {
                    System.out.println("isApplicationRunning? " + (applicationLock == null));
                }
                throw throwable;
            }
            if (applicationLock != null) {
                try {
                    applicationLock.release();
                }
                catch (IOException iOException) {}
            }
            if (Options.isDebug()) {
                System.out.println("isApplicationRunning? " + (applicationLock == null));
            }
        }
        return applicationLock == null;
    }

    protected boolean executeUpdateCommand(String updateCommand) throws Exception {
        String[] parameters = Options.getUpdateParameters();
        this.sendHelpCommandInternal(updateCommand, parameters);
        return true;
    }

    public class EclipseCleaner
    extends Thread {
        @Override
        public void run() {
            if (EclipseController.this.eclipse != null) {
                EclipseController.this.eclipse.killProcess();
            }
        }
    }
}

