/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.core.runtime.CoreException;

public final class CStringValue
implements IValue {
    private static final Map<Character, Character> escapeSequences;
    private final char[] fFixedValue;
    private String fParsedValue;

    static {
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        map.put(Character.valueOf('\''), Character.valueOf('\''));
        map.put(Character.valueOf('\"'), Character.valueOf('\"'));
        map.put(Character.valueOf('?'), Character.valueOf('?'));
        map.put(Character.valueOf('\\'), Character.valueOf('\\'));
        map.put(Character.valueOf('a'), Character.valueOf('\u0007'));
        map.put(Character.valueOf('b'), Character.valueOf('\b'));
        map.put(Character.valueOf('f'), Character.valueOf('\f'));
        map.put(Character.valueOf('n'), Character.valueOf('\n'));
        map.put(Character.valueOf('r'), Character.valueOf('\r'));
        map.put(Character.valueOf('t'), Character.valueOf('\t'));
        map.put(Character.valueOf('v'), Character.valueOf('\u000b'));
        escapeSequences = Collections.unmodifiableMap(map);
    }

    private CStringValue(char[] fixedValue) {
        this.fFixedValue = fixedValue;
    }

    public static IValue create(char[] fixedValue) {
        return new CStringValue(fixedValue);
    }

    public String cStringValue() {
        if (this.fParsedValue == null) {
            this.fParsedValue = this.parseString();
        }
        return this.fParsedValue;
    }

    private int indexOfStartQuote() {
        int len = this.fFixedValue.length;
        int i = 0;
        while (i < len && this.fFixedValue[i] != '\"') {
            ++i;
        }
        if (i >= len) {
            return -1;
        }
        return i;
    }

    private int indexOfEndQuote() {
        int i = this.fFixedValue.length - 1;
        while (i >= 0 && this.fFixedValue[i] != '\"') {
            --i;
        }
        if (i < 0) {
            return -1;
        }
        return i;
    }

    private boolean isRawStringLiteral() {
        int i = 0;
        while (i < this.indexOfStartQuote()) {
            if (this.fFixedValue[i] == 'R') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private int getDelimiterLength() {
        if (this.isRawStringLiteral()) {
            int i = this.indexOfStartQuote();
            int len = 0;
            while (i < this.fFixedValue.length && this.fFixedValue[i] != '(') {
                ++i;
                ++len;
            }
            return len;
        }
        return 0;
    }

    private int getStart() {
        return this.indexOfStartQuote() + this.getDelimiterLength() + 1;
    }

    private int getEnd() {
        return this.indexOfEndQuote() - this.getDelimiterLength() - 1;
    }

    private String parseString() {
        boolean isRaw = this.isRawStringLiteral();
        int end = this.getEnd();
        StringBuilder builder = new StringBuilder();
        int i = this.getStart();
        while (i <= end) {
            if (!isRaw && this.fFixedValue[i] == '\\' && i < end) {
                if (this.fFixedValue[++i] == '0') break;
                i = this.parseEscapeSequence(i, builder);
            } else {
                builder.append(this.fFixedValue[i]);
            }
            ++i;
        }
        return builder.toString();
    }

    private int parseEscapeSequence(int i, StringBuilder builder) {
        char c = this.fFixedValue[i];
        Character escapeSequence = escapeSequences.get(Character.valueOf(c));
        if (escapeSequence != null) {
            builder.append(escapeSequence);
        } else if (c == 'u' && i + 4 <= this.getEnd()) {
            StringBuilder hexStr = new StringBuilder();
            int end = ++i + 4;
            while (i < end) {
                hexStr.append(this.fFixedValue[i]);
                ++i;
            }
            int codePoint = Integer.parseInt(hexStr.toString(), 16);
            builder.append(Character.toChars(codePoint));
        }
        return i;
    }

    @Override
    public Number numberValue() {
        return null;
    }

    @Override
    public int numberOfSubValues() {
        String str = this.cStringValue();
        return str.length();
    }

    @Override
    public ICPPEvaluation getSubValue(int index) {
        String str = this.cStringValue();
        Character c = null;
        if (index >= 0 && index < str.length()) {
            c = Character.valueOf(str.charAt(index));
        } else if (index == str.length()) {
            c = Character.valueOf('\u0000');
        }
        if (c != null) {
            IntegralValue val = IntegralValue.create(c.charValue());
            return new EvalFixed(CPPBasicType.CHAR, IASTExpression.ValueCategory.PRVALUE, val);
        }
        return EvalFixed.INCOMPLETE;
    }

    @Override
    public ICPPEvaluation[] getAllSubValues() {
        return null;
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        return null;
    }

    @Override
    public char[] getSignature() {
        return this.fFixedValue;
    }

    public int hashCode() {
        return CharArrayUtils.hash(this.getSignature());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CStringValue)) {
            return false;
        }
        CStringValue rhs = (CStringValue)obj;
        if (this.fFixedValue != null) {
            return CharArrayUtils.equals(this.fFixedValue, rhs.fFixedValue);
        }
        return CharArrayUtils.equals(this.getSignature(), rhs.getSignature());
    }

    @Override
    public void setSubValue(int position, ICPPEvaluation newValue) {
    }

    @Override
    public IValue clone() {
        char[] newFixedValue = Arrays.copyOf(this.fFixedValue, this.fFixedValue.length);
        return new CStringValue(newFixedValue);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buf) throws CoreException {
        buf.putShort((short)3);
        buf.putCharArray(this.fFixedValue);
    }

    public static IValue unmarshal(short firstBytes, ITypeMarshalBuffer buf) throws CoreException {
        return new CStringValue(buf.getCharArray());
    }

    public String toString() {
        return new String(this.fFixedValue);
    }

    @Override
    public boolean isEquivalentTo(IValue other) {
        if (!(other instanceof CStringValue)) {
            return false;
        }
        CStringValue o = (CStringValue)other;
        return this.fFixedValue.equals(o.fFixedValue);
    }
}

