/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.common.core.format.DataSizeWithUnitFormat;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory.MemoryPresentationProvider;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory.MemoryUsageTreeViewer;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.memory.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.BaseXYPresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.eclipse.tracecompass.tmf.ui.views.TmfChartView;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MemoryUsageView
extends TmfChartView {
    private final String fProviderId;
    private final TmfXYChartSettings fSettings;

    public MemoryUsageView(String title, String providerId, TmfXYChartSettings settings) {
        super(title);
        this.fProviderId = providerId;
        this.fSettings = settings;
    }

    protected TmfXYChartViewer createChartViewer(Composite parent) {
        TmfFilteredXYChartViewer viewer = new TmfFilteredXYChartViewer(parent, this.fSettings, this.fProviderId){

            public @NonNull OutputElementStyle getSeriesStyle(Long seriesId) {
                return this.getPresentationProvider().getSeriesStyle(seriesId);
            }

            protected BaseXYPresentationProvider createPresentationProvider(ITmfTrace trace) {
                return MemoryPresentationProvider.getForTrace(trace);
            }
        };
        viewer.getSwtChart().getAxisSet().getYAxis(0).getTick().setFormat(DataSizeWithUnitFormat.getInstance());
        return viewer;
    }

    protected @NonNull TmfViewer createLeftChildViewer(Composite parent) {
        return new MemoryUsageTreeViewer(parent, this.fProviderId);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getViewSite().getActionBars().getToolBarManager().appendToGroup("additions", (IAction)this.getFilterAction());
    }

    private Action getFilterAction() {
        Action action = new Action(Messages.MemoryView_FilterAction_Text, 2){
            private boolean isFiltered;
            {
                this.isFiltered = true;
            }

            public void run() {
                this.isFiltered ^= true;
                this.setToolTipText(this.isFiltered ? Messages.MemoryView_FilterAction_FilteredTooltipText : Messages.MemoryView_FilterAction_UnfilteredTooltipText);
                TmfViewer tree = MemoryUsageView.this.getLeftChildViewer();
                if (tree instanceof MemoryUsageTreeViewer) {
                    MemoryUsageTreeViewer memoryUsageTreeViewer = (MemoryUsageTreeViewer)tree;
                    memoryUsageTreeViewer.setFiltered(this.isFiltered);
                }
            }
        };
        action.setToolTipText(Messages.MemoryView_FilterAction_FilteredTooltipText);
        action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tracecompass.tmf.ui", (String)"icons/elcl16/filter_items.gif"));
        action.setChecked(true);
        return action;
    }
}

