/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.modelhandler;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistryReader;
import org.eclipse.wst.sse.core.internal.util.Utilities;

public class ModelHandlerRegistry {
    private static ModelHandlerRegistry instance = null;
    static final String INTERNAL_DEFAULT_EXTENSION = "org.eclipse.wst.xml.core.internal.modelhandler";
    private IModelHandler defaultHandler = null;
    private ModelHandlerRegistryReader reader = new ModelHandlerRegistryReader().readRegistry();

    public static synchronized ModelHandlerRegistry getInstance() {
        if (instance == null) {
            instance = new ModelHandlerRegistry();
        }
        return instance;
    }

    private ModelHandlerRegistry() {
    }

    public final IModelHandler getDefault() {
        if (this.defaultHandler == null) {
            IConfigurationElement[] elements = this.reader.elements;
            int i = 0;
            while (i < elements.length) {
                boolean ofInterest = this.reader.isElementDefault(elements[i]);
                if (ofInterest) {
                    if (this.defaultHandler == null) {
                        this.defaultHandler = this.reader.getInstance(elements[i]);
                    } else {
                        String errorString = "Program or configuration error. More than one default content handler found";
                        Logger.log(4, errorString);
                        throw new IllegalStateException(errorString);
                    }
                }
                ++i;
            }
        }
        if (this.defaultHandler == null) {
            String errorString = "Program or configuration error. No default content type handler found.";
            Logger.log(4, errorString);
            throw new IllegalStateException(errorString);
        }
        return this.defaultHandler;
    }

    private IModelHandler getHandlerExtension(String extensionId) {
        IModelHandler found = null;
        IConfigurationElement[] elements = this.reader.elements;
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                String currentId = this.reader.getId(elements[i]);
                if (extensionId.equals(currentId)) {
                    IModelHandler item;
                    found = item = this.reader.getInstance(elements[i]);
                }
                ++i;
            }
        } else if (Logger.DEBUG) {
            Logger.log(2, "There were no Model Handler found in registry");
        }
        return found;
    }

    public IModelHandler getHandlerFor(IFile file, boolean provideDefault) throws CoreException {
        IContentType contentType;
        IModelHandler modelHandler;
        block22: {
            modelHandler = null;
            IContentDescription contentDescription = null;
            contentType = null;
            boolean accessible = file.isAccessible();
            if (accessible) {
                contentDescription = file.getContentDescription();
                if (contentDescription != null) {
                    contentType = contentDescription.getContentType();
                } else {
                    InputStream contents = null;
                    try {
                        try {
                            contents = file.getContents(false);
                            contentDescription = Platform.getContentTypeManager().getDescriptionFor(contents, file.getName(), IContentDescription.ALL);
                            if (contentDescription != null) {
                                contentType = contentDescription.getContentType();
                            }
                        }
                        catch (IOException e) {
                            Logger.logException(e);
                            if (contents != null) {
                                try {
                                    contents.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        if (contents != null) {
                            try {
                                contents.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (contentType == null) {
            contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
        }
        if (contentType != null) {
            modelHandler = this.getHandlerForContentType(contentType);
        } else if (contentType == null && provideDefault) {
            modelHandler = this.getHandlerExtension(INTERNAL_DEFAULT_EXTENSION);
        }
        return modelHandler;
    }

    public IModelHandler getHandlerFor(IFile file) throws CoreException {
        return this.getHandlerFor(file, true);
    }

    public IModelHandler getHandlerFor(String inputName, InputStream inputStream) throws IOException {
        InputStream iStream = Utilities.getMarkSupportedStream(inputStream);
        IModelHandler modelHandler = null;
        IContentType contentType = null;
        if (inputStream != null) {
            try {
                iStream.mark(8192);
                contentType = Platform.getContentTypeManager().findContentTypeFor(Utilities.getLimitedStream(iStream), inputName);
            }
            finally {
                if (iStream != null && iStream.markSupported()) {
                    iStream.reset();
                }
            }
        }
        if (contentType == null) {
            contentType = Platform.getContentTypeManager().findContentTypeFor(inputName);
        }
        if (contentType == null) {
            contentType = Platform.getContentTypeManager().findContentTypeFor(Utilities.getLimitedStream(iStream), null);
        }
        modelHandler = this.getHandlerForContentType(contentType);
        return modelHandler;
    }

    private IModelHandler getHandlerForContentType(IContentType contentType) {
        IModelHandler handler = null;
        if (contentType != null) {
            IConfigurationElement exactContentTypeElement = null;
            IConfigurationElement kindOfContentTypeElement = null;
            int kindOfContentTypeDepth = 0;
            IConfigurationElement[] elements = this.reader.elements;
            if (elements != null) {
                int i = 0;
                while (i < elements.length && exactContentTypeElement == null) {
                    String currentId = this.reader.getAssociatedContentTypeId(elements[i]);
                    IContentType associatedContentType = Platform.getContentTypeManager().getContentType(currentId);
                    if (contentType.equals(associatedContentType)) {
                        exactContentTypeElement = elements[i];
                    } else if (contentType.isKindOf(associatedContentType)) {
                        IContentType testContentType = associatedContentType;
                        int testDepth = 0;
                        while (testContentType != null) {
                            ++testDepth;
                            testContentType = testContentType.getBaseType();
                        }
                        if (testDepth > kindOfContentTypeDepth) {
                            kindOfContentTypeElement = elements[i];
                            kindOfContentTypeDepth = testDepth;
                        }
                    }
                    ++i;
                }
            } else if (Logger.DEBUG) {
                Logger.log(2, "There were no Model Handler found in registry");
            }
            if (exactContentTypeElement != null) {
                handler = this.reader.getInstance(exactContentTypeElement);
            } else if (kindOfContentTypeElement != null) {
                handler = this.reader.getInstance(kindOfContentTypeElement);
            }
        }
        if (handler == null) {
            handler = this.getHandlerExtension(INTERNAL_DEFAULT_EXTENSION);
        }
        return handler;
    }

    public IModelHandler getHandlerForContentTypeId(String contentTypeId) {
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        return this.getHandlerForContentType(contentType);
    }
}

