/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.provisional;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.AsynchronousSchedulingRuleFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.provisional.IAsynchronousContentAdapter;
import org.eclipse.debug.internal.ui.viewers.provisional.IChildrenRequestMonitor;
import org.eclipse.debug.internal.ui.viewers.provisional.IContainerRequestMonitor;

public abstract class AsynchronousContentAdapter
implements IAsynchronousContentAdapter {
    protected static final Object[] EMPTY = new Object[0];

    @Override
    public void retrieveChildren(final Object parent, final IPresentationContext context, final IChildrenRequestMonitor result) {
        Job job = new Job("Retrieving Children"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    AsynchronousContentAdapter.this.computeChildren(parent, context, result);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.getRetrieveChildrenRule(parent, context));
        job.schedule();
    }

    protected ISchedulingRule getRetrieveChildrenRule(Object parent, IPresentationContext context) {
        return AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule(context);
    }

    @Override
    public void isContainer(final Object element, final IPresentationContext context, final IContainerRequestMonitor result) {
        Job job = new Job("Computing hasChildren"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!monitor.isCanceled()) {
                    AsynchronousContentAdapter.this.computeIsContainer(element, context, result);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.getIsContainerRule(element, context));
        job.schedule();
    }

    protected ISchedulingRule getIsContainerRule(Object parent, IPresentationContext context) {
        return AsynchronousSchedulingRuleFactory.getDefault().newSerialPerObjectRule(context);
    }

    protected void computeChildren(Object parent, IPresentationContext context, IChildrenRequestMonitor monitor) {
        if (!monitor.isCanceled()) {
            IStatus status = Status.OK_STATUS;
            try {
                if (this.supportsContext(context)) {
                    monitor.addChildren(this.getChildren(parent, context));
                }
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            monitor.setStatus(status);
            monitor.done();
        }
    }

    protected void computeIsContainer(Object parent, IPresentationContext context, IContainerRequestMonitor monitor) {
        if (!monitor.isCanceled()) {
            IStatus status = Status.OK_STATUS;
            try {
                monitor.setIsContainer(this.hasChildren(parent, context));
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            monitor.setStatus(status);
            monitor.done();
        }
    }

    protected abstract Object[] getChildren(Object var1, IPresentationContext var2) throws CoreException;

    protected abstract boolean hasChildren(Object var1, IPresentationContext var2) throws CoreException;

    protected boolean supportsContext(IPresentationContext context) {
        return this.supportsPartId(context.getId());
    }

    protected abstract boolean supportsPartId(String var1);
}

