/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.activities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.ui.internal.activities.ActivityDefinition;
import org.eclipse.ui.internal.activities.ActivityPatternBindingDefinition;
import org.eclipse.ui.internal.activities.ActivityRegistryEvent;
import org.eclipse.ui.internal.activities.ActivityRequirementBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryActivityBindingDefinition;
import org.eclipse.ui.internal.activities.CategoryDefinition;
import org.eclipse.ui.internal.activities.IActivityRegistry;
import org.eclipse.ui.internal.activities.IActivityRegistryListener;

public abstract class AbstractActivityRegistry
implements IActivityRegistry {
    protected List<ActivityRequirementBindingDefinition> activityRequirementBindingDefinitions = Collections.emptyList();
    protected List<ActivityDefinition> activityDefinitions = Collections.emptyList();
    protected List<ActivityPatternBindingDefinition> activityPatternBindingDefinitions = Collections.emptyList();
    private ActivityRegistryEvent activityRegistryEvent;
    private List<IActivityRegistryListener> activityRegistryListeners;
    protected List<CategoryActivityBindingDefinition> categoryActivityBindingDefinitions = Collections.emptyList();
    protected List<CategoryDefinition> categoryDefinitions = Collections.emptyList();
    protected List<String> defaultEnabledActivities = Collections.emptyList();

    protected AbstractActivityRegistry() {
    }

    @Override
    public void addActivityRegistryListener(IActivityRegistryListener activityRegistryListener) {
        if (activityRegistryListener == null) {
            throw new NullPointerException();
        }
        if (this.activityRegistryListeners == null) {
            this.activityRegistryListeners = new ArrayList<IActivityRegistryListener>();
        }
        if (!this.activityRegistryListeners.contains(activityRegistryListener)) {
            this.activityRegistryListeners.add(activityRegistryListener);
        }
    }

    protected void fireActivityRegistryChanged() {
        if (this.activityRegistryListeners != null) {
            int i = 0;
            while (i < this.activityRegistryListeners.size()) {
                if (this.activityRegistryEvent == null) {
                    this.activityRegistryEvent = new ActivityRegistryEvent(this);
                }
                this.activityRegistryListeners.get(i).activityRegistryChanged(this.activityRegistryEvent);
                ++i;
            }
        }
    }

    @Override
    public List<ActivityRequirementBindingDefinition> getActivityRequirementBindingDefinitions() {
        return this.activityRequirementBindingDefinitions;
    }

    @Override
    public List<ActivityDefinition> getActivityDefinitions() {
        return this.activityDefinitions;
    }

    @Override
    public List<ActivityPatternBindingDefinition> getActivityPatternBindingDefinitions() {
        return this.activityPatternBindingDefinitions;
    }

    @Override
    public List<CategoryActivityBindingDefinition> getCategoryActivityBindingDefinitions() {
        return this.categoryActivityBindingDefinitions;
    }

    @Override
    public List<CategoryDefinition> getCategoryDefinitions() {
        return this.categoryDefinitions;
    }

    @Override
    public void removeActivityRegistryListener(IActivityRegistryListener activityRegistryListener) {
        if (activityRegistryListener == null) {
            throw new NullPointerException();
        }
        if (this.activityRegistryListeners != null) {
            this.activityRegistryListeners.remove(activityRegistryListener);
        }
    }

    @Override
    public List<String> getDefaultEnabledActivities() {
        return this.defaultEnabledActivities;
    }
}

