/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.workingsets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IAggregateWorkingSet;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class WorkingSetsContentProvider
implements ICommonContentProvider {
    public static final String EXTENSION_ID = "org.eclipse.ui.navigator.resources.workingSets";
    public static final String SHOW_TOP_LEVEL_WORKING_SETS = "org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets";
    private static final Object[] NO_CHILDREN = new Object[0];
    public static final Object OTHERS_WORKING_SET = new Object();
    private WorkingSetHelper helper;
    private IAggregateWorkingSet workingSetRoot;
    private IExtensionStateModel extensionStateModel;
    private IWorkingSetManager workingSetManager;
    private CommonNavigator projectExplorer;
    private CommonViewer viewer;
    private IPropertyChangeListener rootModeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (WorkingSetsContentProvider.SHOW_TOP_LEVEL_WORKING_SETS.equals(event.getProperty())) {
                WorkingSetsContentProvider.this.updateRootMode();
            }
        }
    };
    private IPropertyChangeListener workingSetManagerListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (WorkingSetsContentProvider.this.helper != null) {
                WorkingSetsContentProvider.this.helper.refreshWorkingSetTreeState();
            }
        }
    };

    public void init(ICommonContentExtensionSite aConfig) {
        NavigatorContentService cs = (NavigatorContentService)aConfig.getService();
        this.viewer = (CommonViewer)cs.getViewer();
        this.projectExplorer = this.viewer.getCommonNavigator();
        this.extensionStateModel = aConfig.getExtensionStateModel();
        this.extensionStateModel.addPropertyChangeListener(this.rootModeListener);
        this.updateRootMode();
        this.workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        this.workingSetManager.addPropertyChangeListener(this.workingSetManagerListener);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkingSet) {
            IWorkingSet workingSet = (IWorkingSet)parentElement;
            if (workingSet.isAggregateWorkingSet() && this.projectExplorer != null) {
                switch (this.projectExplorer.getRootMode()) {
                    case 0: {
                        Object[] activeWorkingSets = ((IAggregateWorkingSet)workingSet).getComponents();
                        if (this.helper.getUnassignedProjects().isEmpty()) {
                            return activeWorkingSets;
                        }
                        Object[] res = new Object[activeWorkingSets.length + 1];
                        System.arraycopy(activeWorkingSets, 0, res, 0, activeWorkingSets.length);
                        res[activeWorkingSets.length] = OTHERS_WORKING_SET;
                        return res;
                    }
                    case 1: {
                        return this.getWorkingSetElements(workingSet);
                    }
                }
            }
            return this.getWorkingSetElements(workingSet);
        }
        if (parentElement == OTHERS_WORKING_SET) {
            Set<IProject> res = this.helper.getUnassignedProjects();
            return res.toArray(new Object[res.size()]);
        }
        return NO_CHILDREN;
    }

    private IAdaptable[] getWorkingSetElements(IWorkingSet workingSet) {
        IAdaptable[] children = workingSet.getElements();
        int i = 0;
        while (i < children.length) {
            IResource resource = (IResource)Adapters.adapt((Object)children[i], IResource.class);
            if (resource instanceof IProject) {
                children[i] = resource;
            }
            ++i;
        }
        return children;
    }

    public Object getParent(Object element) {
        if (this.helper != null && this.projectExplorer.getRootMode() == 0) {
            return this.helper.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object parentElement) {
        return this.getChildren(parentElement).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.helper = null;
        this.extensionStateModel.removePropertyChangeListener(this.rootModeListener);
        this.workingSetManager.removePropertyChangeListener(this.workingSetManagerListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof IWorkingSet) {
            IWorkingSet rootSet = (IWorkingSet)newInput;
            this.helper = new WorkingSetHelper(rootSet);
        }
    }

    private void updateRootMode() {
        if (this.projectExplorer == null) {
            return;
        }
        if (this.extensionStateModel.getBooleanProperty(SHOW_TOP_LEVEL_WORKING_SETS)) {
            this.projectExplorer.setRootMode(0);
        } else {
            this.projectExplorer.setRootMode(1);
        }
    }

    protected class WorkingSetHelper {
        private final IWorkingSet workingSet;
        private Map<IAdaptable, IAdaptable> parents;
        private Set<IProject> unassignedProjects;

        public WorkingSetHelper(IWorkingSet set) {
            this.workingSet = set;
            this.refreshWorkingSetTreeState();
        }

        void refreshWorkingSetTreeState() {
            int n;
            this.parents = new WeakHashMap<IAdaptable, IAdaptable>();
            if (this.workingSet.isAggregateWorkingSet()) {
                IWorkingSet[] components;
                IAggregateWorkingSet aggregateSet = (IAggregateWorkingSet)this.workingSet;
                if (WorkingSetsContentProvider.this.workingSetRoot == null) {
                    WorkingSetsContentProvider.this.workingSetRoot = aggregateSet;
                }
                IWorkingSet[] iWorkingSetArray = components = aggregateSet.getComponents();
                int n2 = components.length;
                n = 0;
                while (n < n2) {
                    IAdaptable[] elements;
                    IWorkingSet component = iWorkingSetArray[n];
                    IAdaptable[] iAdaptableArray = elements = WorkingSetsContentProvider.this.getWorkingSetElements(component);
                    int n3 = elements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IAdaptable element = iAdaptableArray[n4];
                        this.parents.put(element, (IAdaptable)component);
                        ++n4;
                    }
                    this.parents.put((IAdaptable)component, (IAdaptable)aggregateSet);
                    ++n;
                }
            } else {
                IAdaptable[] elements;
                IAdaptable[] iAdaptableArray = elements = WorkingSetsContentProvider.this.getWorkingSetElements(this.workingSet);
                n = elements.length;
                int n5 = 0;
                while (n5 < n) {
                    IAdaptable element = iAdaptableArray[n5];
                    this.parents.put(element, (IAdaptable)this.workingSet);
                    ++n5;
                }
            }
            this.unassignedProjects = new HashSet<IProject>(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
            for (IAdaptable node : this.parents.keySet()) {
                this.unassignedProjects.remove(node.getAdapter(IProject.class));
            }
        }

        public Set<IProject> getUnassignedProjects() {
            return this.unassignedProjects;
        }

        public Object getParent(Object element) {
            if (element instanceof IWorkingSet && element != WorkingSetsContentProvider.this.workingSetRoot) {
                return WorkingSetsContentProvider.this.workingSetRoot;
            }
            IAdaptable res = this.parents.get(element);
            if (res != null) {
                return res;
            }
            if (this.unassignedProjects.contains(element)) {
                return OTHERS_WORKING_SET;
            }
            return null;
        }
    }
}

