/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.debug.internal.ui.actions.ToggleBreakpointsTargetManager;
import org.eclipse.debug.internal.ui.actions.breakpoints.Messages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class BreakpointTypesContribution
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator fServiceLocator;
    private static IContributionItem[] NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS = new IContributionItem[]{new ContributionItem(){

        public void fill(Menu menu, int index) {
            MenuItem item = new MenuItem(menu, 0);
            item.setEnabled(false);
            item.setText(Messages.BreakpointTypesContribution_0);
        }

        public boolean isEnabled() {
            return false;
        }
    }};

    protected IContributionItem[] getContributionItems() {
        IPartService partService;
        IWorkbenchPart part = null;
        ISelection selection = null;
        ISelectionService selectionService = (ISelectionService)this.fServiceLocator.getService(ISelectionService.class);
        if (selectionService != null) {
            selection = selectionService.getSelection();
        }
        if ((partService = (IPartService)this.fServiceLocator.getService(IPartService.class)) != null) {
            part = partService.getActivePart();
        }
        if (part == null || selection == null) {
            return NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;
        }
        IToggleBreakpointsTargetManager manager = DebugUITools.getToggleBreakpointsTargetManager();
        Set<String> enabledIDs = manager.getEnabledToggleBreakpointsTargetIDs(part, selection);
        String preferredId = manager.getPreferredToggleBreakpointsTargetID(part, selection);
        ArrayList<SelectTargetAction> actions = new ArrayList<SelectTargetAction>(enabledIDs.size());
        for (String id : enabledIDs) {
            SelectTargetAction action = new SelectTargetAction(manager.getToggleBreakpointsTargetName(id), enabledIDs, id);
            if (id.equals(preferredId)) {
                action.setChecked(true);
            }
            actions.add(action);
        }
        if (enabledIDs.isEmpty()) {
            return NO_BREAKPOINT_TYPES_CONTRIBUTION_ITEMS;
        }
        IContributionItem[] items = new IContributionItem[enabledIDs.size()];
        int i = 0;
        while (i < actions.size()) {
            items[i] = new ActionContributionItem((IAction)actions.get(i));
            ++i;
        }
        return items;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    private class SelectTargetAction
    extends Action {
        private final Set<String> fPossibleIDs;
        private final String fID;

        SelectTargetAction(String name, Set<String> possibleIDs, String ID) {
            super(name, 8);
            this.fID = ID;
            this.fPossibleIDs = possibleIDs;
        }

        public void run() {
            if (this.isChecked()) {
                ToggleBreakpointsTargetManager.getDefault().setPreferredTarget(this.fPossibleIDs, this.fID);
            }
        }
    }
}

