/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.NavigationAction;
import org.eclipse.compare.internal.ChangeCompareFilterPropertyAction;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.EditorActionBarContributor;

public class CompareEditorContributor
extends EditorActionBarContributor {
    public static final String FILTER_SEPARATOR = "compare.filters";
    public static final String BUILTIN_SEPARATOR = "compare.builtin";
    private IEditorPart fActiveEditorPart = null;
    private ChangePropertyAction fIgnoreWhitespace;
    private NavigationAction fNext;
    private NavigationAction fPrevious;
    private NavigationAction fToolbarNext;
    private NavigationAction fToolbarPrevious;

    public CompareEditorContributor() {
        ResourceBundle bundle = CompareUI.getResourceBundle();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        this.fIgnoreWhitespace = ChangePropertyAction.createIgnoreWhiteSpaceAction(bundle, null);
        helpSystem.setHelp((IAction)this.fIgnoreWhitespace, "org.eclipse.compare.ignore_whitespace_action_context");
        this.fNext = new NavigationAction(bundle, true);
        helpSystem.setHelp((IAction)this.fNext, "org.eclipse.compare.global_next_diff_action_context");
        this.fPrevious = new NavigationAction(bundle, false);
        helpSystem.setHelp((IAction)this.fPrevious, "org.eclipse.compare.global_previous_diff_action_context");
        this.fToolbarNext = new NavigationAction(bundle, true);
        helpSystem.setHelp((IAction)this.fToolbarNext, "org.eclipse.compare.next_diff_action_context");
        this.fToolbarPrevious = new NavigationAction(bundle, false);
        helpSystem.setHelp((IAction)this.fToolbarPrevious, "org.eclipse.compare.previous_diff_action_context");
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(FILTER_SEPARATOR));
        tbm.add((IContributionItem)new Separator(BUILTIN_SEPARATOR));
        tbm.appendToGroup(BUILTIN_SEPARATOR, (IAction)this.fIgnoreWhitespace);
        tbm.appendToGroup(BUILTIN_SEPARATOR, (IAction)this.fToolbarNext);
        tbm.appendToGroup(BUILTIN_SEPARATOR, (IAction)this.fToolbarPrevious);
    }

    public void contributeToMenu(IMenuManager menuManager) {
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        IActionBars actionBars;
        IEditorInput input;
        if (this.fActiveEditorPart == targetEditor) {
            return;
        }
        this.fActiveEditorPart = targetEditor;
        if (this.fActiveEditorPart != null && (input = this.fActiveEditorPart.getEditorInput()) instanceof CompareEditorInput) {
            CompareEditorInput compareInput = (CompareEditorInput)input;
            this.fNext.setCompareEditorInput(compareInput);
            this.fPrevious.setCompareEditorInput(compareInput);
            this.fToolbarNext.setCompareEditorInput(compareInput);
            this.fToolbarPrevious.setCompareEditorInput(compareInput);
        }
        if (targetEditor instanceof CompareEditor) {
            Object filterActions;
            IEditorInput input2;
            actionBars = this.getActionBars();
            CompareEditor editor = (CompareEditor)targetEditor;
            editor.setActionBars(actionBars);
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNext);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPrevious);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", (IAction)this.fNext);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", (IAction)this.fPrevious);
            CompareConfiguration cc = editor.getCompareConfiguration();
            this.fIgnoreWhitespace.setCompareConfiguration(cc);
            IContributionItem[] items = actionBars.getToolBarManager().getItems();
            boolean inFilters = false;
            int i = 0;
            while (i < items.length) {
                if (items[i].getId().equals(FILTER_SEPARATOR)) {
                    inFilters = true;
                } else {
                    if (items[i].getId().equals(BUILTIN_SEPARATOR)) break;
                    if (inFilters) {
                        String definitionId;
                        if (items[i] instanceof ActionContributionItem && (definitionId = ((ActionContributionItem)items[i]).getAction().getActionDefinitionId()) != null) {
                            actionBars.setGlobalActionHandler(definitionId, null);
                        }
                        actionBars.getToolBarManager().remove(items[i]);
                    }
                }
                ++i;
            }
            if ((input2 = editor.getEditorInput()) instanceof CompareEditorInput && ((CompareEditorInput)input2).getCompareConfiguration() != null && (filterActions = ((CompareEditorInput)input2).getCompareConfiguration().getProperty("COMPARE_FILTER_ACTIONS")) instanceof List && !((List)filterActions).isEmpty()) {
                for (Object next : (List)filterActions) {
                    if (!(next instanceof ChangeCompareFilterPropertyAction)) continue;
                    actionBars.getToolBarManager().appendToGroup(FILTER_SEPARATOR, (IAction)((ChangeCompareFilterPropertyAction)((Object)next)));
                    String definitionId = ((ChangeCompareFilterPropertyAction)((Object)next)).getActionDefinitionId();
                    if (definitionId == null) continue;
                    actionBars.setGlobalActionHandler(definitionId, (IAction)((ChangeCompareFilterPropertyAction)((Object)next)));
                }
                actionBars.getToolBarManager().markDirty();
                actionBars.getToolBarManager().update(true);
                actionBars.updateActionBars();
            }
        } else {
            actionBars = this.getActionBars();
            actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), null);
            actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), null);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", null);
            actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", null);
        }
    }

    public void dispose() {
        this.setActiveEditor(null);
        super.dispose();
        this.fIgnoreWhitespace.dispose();
    }
}

