/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.TmfWorkspaceModifyOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ArchiveUtil;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.FileSystemObjectImportStructureProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.IFileSystemObject;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConfirmation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.ImportConflictHandler;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.Messages;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.importtrace.TraceFileSystemElement;
import org.eclipse.tracecompass.internal.util.ByteBufferTracker;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceImportException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.util.Pair;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class TraceValidateAndImportOperation
extends TmfWorkspaceModifyOperation {
    private static final String TRACE_IMPORT_TEMP_FOLDER = ".traceImport";
    private static final String EXTRACTED_ARCHIVE_FOLDER = ".extractedArchive";
    private static final @NonNull String DEFAULT_ARCHIVE_FOLDER_NAME = "extractedTrace";
    private String fTraceType;
    private IPath fDestinationContainerPath;
    private IPath fBaseSourceContainerPath;
    private boolean fImportFromArchive;
    private int fImportOptionFlags;
    private Shell fShell;
    private TmfTraceFolder fTraceFolderElement;
    private List<TraceFileSystemElement> fSelectedFileSystemElements;
    private ITmfTimestamp fStartTimeRange;
    private ITmfTimestamp fEndTimeRange;
    private @NonNull String fFolderName;
    private boolean fKeepArchive;
    private IStatus fStatus;
    private ImportConflictHandler fConflictHandler;
    private String fCurrentPath;
    private List<IResource> fImportedResources;

    public TraceValidateAndImportOperation(Shell shell, List<TraceFileSystemElement> traceFileSystemElements, String traceId, IPath baseSourceContainerPath, IPath destinationContainerPath, boolean importFromArchive, int importOptionFlags, TmfTraceFolder traceFolderElement, ITmfTimestamp startTimeRange, ITmfTimestamp endTimeRange, String folderName, boolean keepArchive) {
        boolean overwriteExistingResources;
        this.fTraceType = traceId;
        this.fBaseSourceContainerPath = baseSourceContainerPath;
        this.fDestinationContainerPath = destinationContainerPath;
        this.fImportOptionFlags = importOptionFlags;
        this.fImportFromArchive = importFromArchive;
        this.fShell = shell;
        this.fTraceFolderElement = traceFolderElement;
        this.fStartTimeRange = startTimeRange;
        this.fEndTimeRange = endTimeRange;
        this.fFolderName = folderName != null ? folderName : DEFAULT_ARCHIVE_FOLDER_NAME;
        this.fKeepArchive = keepArchive;
        boolean bl = overwriteExistingResources = (importOptionFlags & 0x10) != 0;
        if (overwriteExistingResources) {
            this.setConflictHandler(new ImportConflictHandler(this.fShell, this.fTraceFolderElement, ImportConfirmation.OVERWRITE_ALL));
        } else {
            this.setConflictHandler(new ImportConflictHandler(this.fShell, this.fTraceFolderElement, ImportConfirmation.SKIP));
        }
        this.fImportedResources = new ArrayList<IResource>();
        this.fSelectedFileSystemElements = traceFileSystemElements;
    }

    @Override
    protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            boolean keepArchive;
            SubMonitor monitor;
            int ARCHIVE_OR_DIRECTORY_PROGRESS = 45;
            int EXTRA_IMPORT_OPERATION_PROGRESS = 45;
            int DELETE_PROGRESS = 10;
            int TOTAL_PROGRESS = 100;
            List<TraceFileSystemElement> selectedFileSystemElements = this.fSelectedFileSystemElements;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)TOTAL_PROGRESS);
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            IFolder destTempFolder = this.fTraceFolderElement.getProject().getResource().getFolder(TRACE_IMPORT_TEMP_FOLDER);
            if (destTempFolder.exists()) {
                monitor = subMonitor.newChild(1);
                destTempFolder.delete(true, (IProgressMonitor)monitor);
            }
            monitor = subMonitor.newChild(1);
            destTempFolder.create(4096, true, (IProgressMonitor)monitor);
            String baseSourceLocation = null;
            if (this.fImportFromArchive) {
                SubMonitor archiveMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(45), (int)2);
                if (this.fKeepArchive) {
                    this.fImportOptionFlags |= 0x100;
                    this.fImportOptionFlags |= 4;
                    IFolder extractedFolder = this.fTraceFolderElement.getProject().getResource().getFolder(EXTRACTED_ARCHIVE_FOLDER);
                    if (!extractedFolder.exists()) {
                        monitor = archiveMonitor.newChild(1);
                        extractedFolder.create(2, true, (IProgressMonitor)monitor);
                    }
                    if (!(destTempFolder = extractedFolder.getFolder(this.fFolderName)).exists()) {
                        monitor = archiveMonitor.newChild(1);
                        destTempFolder.create(2, true, (IProgressMonitor)monitor);
                    }
                }
                this.extractArchiveContent(selectedFileSystemElements.iterator(), destTempFolder, (IProgressMonitor)archiveMonitor.newChild(1));
                archiveMonitor.subTask("");
                if (!selectedFileSystemElements.isEmpty()) {
                    baseSourceLocation = TraceValidateAndImportOperation.getRootElement(selectedFileSystemElements.get(0)).getSourceLocation();
                    if ((this.fImportOptionFlags & 0x40) == 0) {
                        List<TraceFileSystemElement> tempFolderFileSystemElements = TraceValidateAndImportOperation.createElementsForFolder(destTempFolder);
                        this.extractAllArchiveFiles(tempFolderFileSystemElements, destTempFolder, destTempFolder.getLocation(), (IProgressMonitor)archiveMonitor.newChild(1));
                    }
                }
            } else {
                SubMonitor directoryMonitor = SubMonitor.convert((IProgressMonitor)subMonitor.newChild(45), (int)2);
                this.importFileSystemElements((IProgressMonitor)directoryMonitor.newChild(1), selectedFileSystemElements);
                if ((this.fImportOptionFlags & 0x40) == 0) {
                    this.extractAllArchiveFiles(selectedFileSystemElements, destTempFolder, this.fBaseSourceContainerPath, (IProgressMonitor)directoryMonitor.newChild(1));
                }
                baseSourceLocation = URIUtil.toUnencodedString((URI)this.fBaseSourceContainerPath.toFile().getCanonicalFile().toURI());
            }
            this.fBaseSourceContainerPath = destTempFolder.getLocation();
            List<TraceFileSystemElement> tempFolderFileSystemElements = TraceValidateAndImportOperation.createElementsForFolder(destTempFolder);
            boolean bl = keepArchive = (this.fImportOptionFlags & 0x100) != 0;
            if (!tempFolderFileSystemElements.isEmpty()) {
                this.calculateSourceLocations(tempFolderFileSystemElements, baseSourceLocation);
                if (!keepArchive) {
                    this.fImportOptionFlags &= 0xFFFFFFFB;
                }
                SubMonitor importTempMonitor = subMonitor.newChild(45);
                this.importFileSystemElements((IProgressMonitor)importTempMonitor.newChild(1), tempFolderFileSystemElements);
            }
            if (destTempFolder.exists() && !keepArchive) {
                if (ByteBufferTracker.getAndReset()) {
                    System.gc();
                }
                destTempFolder.delete(true, (IProgressMonitor)subMonitor.newChild(TOTAL_PROGRESS));
            }
            this.setStatus(Status.OK_STATUS);
        }
        catch (InterruptedException e) {
            this.setStatus(Status.CANCEL_STATUS);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            String errorMessage = String.valueOf(Messages.ImportTraceWizard_ImportProblem) + ": " + (this.fCurrentPath != null ? this.fCurrentPath : "");
            Activator.getDefault().logError(errorMessage, e);
            this.setStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", errorMessage, (Throwable)e));
        }
    }

    private TraceFileSystemElement filterSelectedFileSystemElement(TraceFileSystemElement selectedFileSystemElements, IProgressMonitor monitor) {
        if ((this.fImportOptionFlags & 0x80) != 0 && this.fStartTimeRange != null && this.fEndTimeRange != null) {
            return this.filterByTimerange(selectedFileSystemElements, monitor);
        }
        return selectedFileSystemElements;
    }

    private TraceFileSystemElement filterByTimerange(TraceFileSystemElement selectedFileSystemElements, IProgressMonitor monitor) {
        block15: {
            ITmfTrace trace;
            SubMonitor subMonitor;
            block12: {
                TraceFileSystemElement traceFileSystemElement;
                block13: {
                    IConfigurationElement ce;
                    String tracePath;
                    block10: {
                        block11: {
                            TraceTypeHelper traceTypeHelper;
                            block8: {
                                block9: {
                                    subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
                                    subMonitor.subTask(Messages.ImportTraceWizard_FilteringOperationTaskName);
                                    tracePath = selectedFileSystemElements.getFileSystemObject().getAbsolutePath();
                                    trace = null;
                                    traceTypeHelper = TmfTraceTypeUIUtils.selectTraceType(tracePath, null, null);
                                    if (traceTypeHelper != null) break block8;
                                    if (trace == null) break block9;
                                    trace.dispose();
                                    TmfTraceManager.deleteSupplementaryFolder(trace);
                                }
                                subMonitor.worked(1);
                                return null;
                            }
                            ce = TmfTraceType.getTraceAttributes((String)traceTypeHelper.getTraceTypeId());
                            if (ce != null) break block10;
                            if (trace == null) break block11;
                            trace.dispose();
                            TmfTraceManager.deleteSupplementaryFolder(trace);
                        }
                        subMonitor.worked(1);
                        return null;
                    }
                    try {
                        trace = (ITmfTrace)ce.createExecutableExtension("trace_type");
                        ITmfEvent event = (ITmfEvent)ce.createExecutableExtension("event_type");
                        trace.initTrace(null, tracePath, event.getClass());
                        if (!this.isInTimerange(trace)) break block12;
                        traceFileSystemElement = selectedFileSystemElements;
                        if (trace == null) break block13;
                    }
                    catch (CoreException | TmfTraceException | TmfTraceImportException e) {
                        block14: {
                            try {
                                String errorMessage = String.valueOf(Messages.ImportTraceWizard_ImportProblem) + ": " + tracePath;
                                Activator.getDefault().logError(errorMessage, e);
                                if (trace == null) break block14;
                            }
                            catch (Throwable throwable) {
                                if (trace != null) {
                                    trace.dispose();
                                    TmfTraceManager.deleteSupplementaryFolder(trace);
                                }
                                subMonitor.worked(1);
                                throw throwable;
                            }
                            trace.dispose();
                            TmfTraceManager.deleteSupplementaryFolder((ITmfTrace)trace);
                        }
                        subMonitor.worked(1);
                        break block15;
                    }
                    trace.dispose();
                    TmfTraceManager.deleteSupplementaryFolder((ITmfTrace)trace);
                }
                subMonitor.worked(1);
                return traceFileSystemElement;
            }
            if (trace != null) {
                trace.dispose();
                TmfTraceManager.deleteSupplementaryFolder((ITmfTrace)trace);
            }
            subMonitor.worked(1);
        }
        return null;
    }

    private boolean isInTimerange(ITmfTrace trace) {
        ITmfTimestamp startTimestamp = trace.readStart();
        ITmfTimestamp endTimestamp = trace.readEnd();
        return startTimestamp != null && endTimestamp != null && startTimestamp.compareTo(this.fEndTimeRange) <= 0 && endTimestamp.compareTo(this.fStartTimeRange) >= 0;
    }

    public List<IResource> getImportedResources() {
        return this.fImportedResources;
    }

    private void importFileSystemElements(IProgressMonitor monitor, List<TraceFileSystemElement> fileSystemElements) throws InterruptedException, TmfTraceImportException, CoreException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)fileSystemElements.size());
        fileSystemElements.sort(new FileObjectPathComparator());
        ListIterator<TraceFileSystemElement> fileSystemElementsIter = fileSystemElements.listIterator();
        HashMap<String, TraceFileSystemElement> directoryTraces = new HashMap<String, TraceFileSystemElement>();
        while (fileSystemElementsIter.hasNext()) {
            ModalContext.checkCanceled((IProgressMonitor)monitor);
            this.fCurrentPath = null;
            TraceFileSystemElement element = fileSystemElementsIter.next();
            IFileSystemObject fileSystemObject = element.getFileSystemObject();
            String resourcePath = element.getFileSystemObject().getAbsolutePath();
            element.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(resourcePath)));
            this.fCurrentPath = resourcePath;
            SubMonitor sub = subMonitor.split(1, 3);
            if (element.isDirectory()) {
                if (directoryTraces.containsKey(resourcePath) || !TraceValidateAndImportOperation.isDirectoryTrace(element)) continue;
                directoryTraces.put(resourcePath, element);
                this.validateAndImportTrace(element, (IProgressMonitor)sub);
                continue;
            }
            TraceFileSystemElement parentElement = (TraceFileSystemElement)element.getParent();
            String parentPath = parentElement.getFileSystemObject().getAbsolutePath();
            parentElement.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(parentPath)));
            this.fCurrentPath = parentPath;
            if (directoryTraces.containsKey(parentPath)) continue;
            if (TraceValidateAndImportOperation.isDirectoryTrace(parentElement)) {
                directoryTraces.put(parentPath, parentElement);
                this.validateAndImportTrace(parentElement, (IProgressMonitor)sub);
                continue;
            }
            boolean validateFile = true;
            TraceFileSystemElement grandParentElement = (TraceFileSystemElement)parentElement.getParent();
            if (grandParentElement != null) {
                String grandParentPath = grandParentElement.getFileSystemObject().getAbsolutePath();
                grandParentElement.setDestinationContainerPath(this.computeDestinationContainerPath(new Path(parentPath)));
                this.fCurrentPath = grandParentPath;
                if (directoryTraces.containsKey(grandParentPath)) {
                    validateFile = false;
                } else if (TraceValidateAndImportOperation.isDirectoryTrace(grandParentElement)) {
                    directoryTraces.put(grandParentPath, grandParentElement);
                    this.validateAndImportTrace(grandParentElement, (IProgressMonitor)sub);
                    validateFile = false;
                }
            }
            if (!validateFile || !fileSystemObject.exists()) continue;
            this.validateAndImportTrace(element, (IProgressMonitor)sub);
        }
    }

    private static List<TraceFileSystemElement> createElementsForFolder(IFolder folder) {
        FileSystemObjectImportStructureProvider importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
        IFileSystemObject rootElement = importStructureProvider.getIFileSystemObject(new File(folder.getLocation().toOSString()));
        TraceFileSystemElement createRootElement = TraceFileSystemElement.createRootTraceFileElement(rootElement, importStructureProvider);
        LinkedList<TraceFileSystemElement> list = new LinkedList<TraceFileSystemElement>();
        createRootElement.getAllChildren(list);
        return list;
    }

    private void extractAllArchiveFiles(List<TraceFileSystemElement> fileSystemElements, IFolder destFolder, IPath baseSourceContainerPath, IProgressMonitor progressMonitor) throws InterruptedException, CoreException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)fileSystemElements.size());
        ListIterator<TraceFileSystemElement> fileSystemElementsIter = fileSystemElements.listIterator();
        while (fileSystemElementsIter.hasNext()) {
            boolean isArchiveFileElement;
            ModalContext.checkCanceled((IProgressMonitor)subMonitor);
            SubMonitor elementProgress = subMonitor.newChild(1);
            TraceFileSystemElement element = fileSystemElementsIter.next();
            elementProgress.setTaskName(String.valueOf(Messages.ImportTraceWizard_ExamineOperationTaskName) + " " + element.getFileSystemObject().getAbsolutePath());
            File archiveFile = (File)element.getFileSystemObject().getRawFileSystemObject();
            boolean bl = isArchiveFileElement = element.getFileSystemObject() instanceof FileFileSystemObject && ArchiveUtil.isArchiveFile(archiveFile);
            if (!isArchiveFileElement) continue;
            elementProgress = SubMonitor.convert((IProgressMonitor)elementProgress, (int)4);
            IPath makeAbsolute = baseSourceContainerPath.makeAbsolute();
            IPath relativeToSourceContainer = new Path(element.getFileSystemObject().getAbsolutePath()).makeRelativeTo(makeAbsolute);
            IFolder folder = TraceValidateAndImportOperation.safeCreateExtractedFolder(destFolder, relativeToSourceContainer, (IProgressMonitor)elementProgress.newChild(1));
            this.extractArchiveToFolder(archiveFile, folder, (IProgressMonitor)elementProgress.newChild(1));
            IFile fileRes = destFolder.getFile(relativeToSourceContainer);
            fileRes.delete(true, (IProgressMonitor)elementProgress.newChild(1));
            IPath newPath = destFolder.getFullPath().append(relativeToSourceContainer);
            folder.move(newPath, true, (IProgressMonitor)elementProgress.newChild(1));
            folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(newPath);
            elementProgress.subTask("");
            FileSystemObjectImportStructureProvider importStructureProvider = new FileSystemObjectImportStructureProvider((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null);
            IFileSystemObject rootElement = importStructureProvider.getIFileSystemObject(new File(folder.getLocation().toOSString()));
            TraceFileSystemElement newElement = TraceFileSystemElement.createRootTraceFileElement(rootElement, importStructureProvider);
            ArrayList<TraceFileSystemElement> extractedChildren = new ArrayList<TraceFileSystemElement>();
            newElement.getAllChildren(extractedChildren);
            this.extractAllArchiveFiles(extractedChildren, folder, folder.getLocation(), progressMonitor);
        }
    }

    private void extractArchiveToFolder(File sourceFile, IFolder destinationFolder, IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        Pair<IFileSystemObject, FileSystemObjectImportStructureProvider> rootObjectAndProvider = ArchiveUtil.getRootObjectAndProvider(sourceFile, this.fShell);
        TraceFileSystemElement rootElement = TraceFileSystemElement.createRootTraceFileElement((IFileSystemObject)rootObjectAndProvider.getFirst(), (FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond());
        ArrayList<TraceFileSystemElement> fileSystemElements = new ArrayList<TraceFileSystemElement>();
        rootElement.getAllChildren(fileSystemElements);
        this.extractArchiveContent(fileSystemElements.listIterator(), destinationFolder, progressMonitor);
        ((FileSystemObjectImportStructureProvider)rootObjectAndProvider.getSecond()).dispose();
    }

    private static IFolder safeCreateExtractedFolder(IFolder destinationFolder, IPath relativeContainerRelativePath, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        String suffix = "";
        int i = 2;
        while (true) {
            IPath fullPath = destinationFolder.getFullPath().append(relativeContainerRelativePath + ".extract" + suffix);
            folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(fullPath);
            if (!folder.exists()) break;
            suffix = "(" + i + ")";
            ++i;
        }
        IFolder extractedFolder = folder;
        subMonitor.worked(1);
        TraceUtils.createFolder(extractedFolder, (IProgressMonitor)subMonitor.newChild(1));
        return extractedFolder;
    }

    private void calculateSourceLocations(List<TraceFileSystemElement> fileSystemElements, String baseSourceLocation) {
        for (TraceFileSystemElement element : fileSystemElements) {
            IPath tempRelative = new Path(element.getFileSystemObject().getAbsolutePath()).makeRelativeTo(this.fBaseSourceContainerPath);
            String sourceLocation = String.valueOf(baseSourceLocation) + tempRelative;
            element.setSourceLocation(sourceLocation);
            TraceFileSystemElement parentElement = (TraceFileSystemElement)element.getParent();
            tempRelative = new Path(parentElement.getFileSystemObject().getAbsolutePath()).makeRelativeTo(this.fBaseSourceContainerPath);
            sourceLocation = String.valueOf(baseSourceLocation) + tempRelative + '/';
            parentElement.setSourceLocation(sourceLocation);
        }
    }

    private void extractArchiveContent(Iterator<TraceFileSystemElement> fileSystemElementsIter, IFolder tempFolder, IProgressMonitor progressMonitor) throws InterruptedException, InvocationTargetException {
        ArrayList<TraceFileSystemElement> subList = new ArrayList<TraceFileSystemElement>();
        while (fileSystemElementsIter.hasNext()) {
            ModalContext.checkCanceled((IProgressMonitor)progressMonitor);
            TraceFileSystemElement element = fileSystemElementsIter.next();
            if (element.isDirectory()) {
                Object[] array = element.getFiles().getChildren();
                int i = 0;
                while (i < array.length) {
                    subList.add((TraceFileSystemElement)((Object)array[i]));
                    ++i;
                }
            }
            subList.add(element);
        }
        if (subList.isEmpty()) {
            return;
        }
        TraceFileSystemElement root = TraceValidateAndImportOperation.getRootElement((TraceFileSystemElement)((Object)subList.get(0)));
        ImportProvider fileSystemStructureProvider = new ImportProvider();
        IOverwriteQuery myQueryImpl = file -> "NOALL";
        progressMonitor.setTaskName(Messages.ImportTraceWizard_ExtractImportOperationTaskName);
        IPath containerPath = tempFolder.getFullPath();
        ImportOperation operation = new ImportOperation(containerPath, (Object)root, (IImportStructureProvider)fileSystemStructureProvider, myQueryImpl, subList);
        operation.setContext(this.fShell);
        operation.setCreateContainerStructure(true);
        operation.setOverwriteResources(false);
        operation.setVirtualFolders(false);
        operation.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor).newChild(subList.size()));
    }

    private static TraceFileSystemElement getRootElement(TraceFileSystemElement element) {
        TraceFileSystemElement root = element;
        while (root.getParent() != null) {
            root = (TraceFileSystemElement)root.getParent();
        }
        return root;
    }

    private IPath computeDestinationContainerPath(Path resourcePath) {
        IPath destinationContainerPath = this.fDestinationContainerPath;
        if ((this.fImportOptionFlags & 2) != 0) {
            IPath sourceContainerPath = resourcePath.removeLastSegments(1);
            if (this.fBaseSourceContainerPath.equals((Object)resourcePath)) {
                sourceContainerPath = resourcePath;
            }
            IPath relativeContainerPath = sourceContainerPath.makeRelativeTo(this.fBaseSourceContainerPath);
            destinationContainerPath = this.fDestinationContainerPath.append(relativeContainerPath);
        }
        return destinationContainerPath;
    }

    private void validateAndImportTrace(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws TmfTraceImportException, CoreException, InvocationTargetException, InterruptedException {
        TraceFileSystemElement resourceToImport;
        String path = fileSystemElement.getFileSystemObject().getAbsolutePath();
        TraceTypeHelper traceTypeHelper = null;
        monitor.setTaskName(String.valueOf(Messages.ImportTraceWizard_ExamineOperationTaskName) + " " + fileSystemElement.getFileSystemObject().getAbsolutePath());
        if ((this.fImportOptionFlags & 0x40) == 0) {
            boolean isArchiveFileElement;
            File file = (File)fileSystemElement.getFileSystemObject().getRawFileSystemObject();
            boolean bl = isArchiveFileElement = fileSystemElement.getFileSystemObject() instanceof FileFileSystemObject && ArchiveUtil.isArchiveFile(file);
            if (isArchiveFileElement) {
                return;
            }
        }
        if (this.fTraceType == null) {
            try {
                traceTypeHelper = TmfTraceTypeUIUtils.selectTraceType(path, null, null);
            }
            catch (TmfTraceImportException file) {
                // empty catch block
            }
            if (traceTypeHelper == null) {
                if ((this.fImportOptionFlags & 8) != 0) {
                    this.importResource(fileSystemElement, monitor);
                }
                return;
            }
        } else {
            boolean isDirectoryTraceType = TmfTraceType.isDirectoryTraceType((String)this.fTraceType);
            if (fileSystemElement.isDirectory() != isDirectoryTraceType) {
                return;
            }
            traceTypeHelper = TmfTraceType.getTraceType((String)this.fTraceType);
            if (traceTypeHelper == null) {
                throw new TmfTraceImportException(Messages.ImportTraceWizard_TraceTypeNotFound);
            }
            if (!traceTypeHelper.validate(path).isOK()) {
                return;
            }
        }
        if ((resourceToImport = this.filterSelectedFileSystemElement(fileSystemElement, monitor)) == null) {
            return;
        }
        IResource importedResource = this.importResource(resourceToImport, monitor);
        if (importedResource != null) {
            TmfTraceTypeUIUtils.setTraceType(importedResource, traceTypeHelper, false);
            this.fImportedResources.add(importedResource);
        }
    }

    private IResource importResource(TraceFileSystemElement fileSystemElement, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, CoreException {
        boolean createLinksInWorkspace;
        IPath tracePath = TraceValidateAndImportOperation.getInitialDestinationPath(fileSystemElement);
        String newName = this.fConflictHandler.checkAndHandleNameClash(tracePath, monitor);
        if (newName == null) {
            return null;
        }
        fileSystemElement.setLabel(newName);
        ArrayList<TraceFileSystemElement> subList = new ArrayList<TraceFileSystemElement>();
        FileSystemElement parentFolder = fileSystemElement.getParent();
        IPath containerPath = fileSystemElement.getDestinationContainerPath();
        tracePath = containerPath.addTrailingSeparator().append(fileSystemElement.getLabel());
        boolean bl = createLinksInWorkspace = (this.fImportOptionFlags & 4) != 0;
        if (fileSystemElement.isDirectory() && !createLinksInWorkspace) {
            containerPath = tracePath;
            Object[] array = fileSystemElement.getFiles().getChildren();
            int i = 0;
            while (i < array.length) {
                subList.add((TraceFileSystemElement)((Object)array[i]));
                ++i;
            }
            parentFolder = fileSystemElement;
        } else {
            IFileInfo info;
            if (!fileSystemElement.isDirectory() && (info = EFS.getStore((URI)new File(fileSystemElement.getFileSystemObject().getAbsolutePath()).toURI()).fetchInfo()).getLength() == 0L) {
                return null;
            }
            subList.add(fileSystemElement);
        }
        ImportProvider fileSystemStructureProvider = new ImportProvider();
        IOverwriteQuery myQueryImpl = file -> "NOALL";
        monitor.setTaskName(String.valueOf(Messages.ImportTraceWizard_ImportOperationTaskName) + " " + fileSystemElement.getFileSystemObject().getAbsolutePath());
        ImportOperation operation = new ImportOperation(containerPath, (Object)parentFolder, (IImportStructureProvider)fileSystemStructureProvider, myQueryImpl, subList);
        operation.setContext(this.fShell);
        operation.setCreateContainerStructure(false);
        operation.setOverwriteResources(false);
        operation.setCreateLinks(createLinksInWorkspace);
        operation.setVirtualFolders(false);
        operation.run((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor).newChild(1));
        String sourceLocation = fileSystemElement.getSourceLocation();
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(tracePath);
        if (sourceLocation != null && resource != null) {
            resource.setPersistentProperty(TmfCommonConstants.SOURCE_LOCATION, sourceLocation);
        }
        return resource;
    }

    private static boolean isDirectoryTrace(TraceFileSystemElement fileSystemElement) {
        String path = fileSystemElement.getFileSystemObject().getAbsolutePath();
        return TmfTraceType.isDirectoryTrace((String)path);
    }

    private static IPath getInitialDestinationPath(TraceFileSystemElement fileSystemElement) {
        IPath traceFolderPath = fileSystemElement.getDestinationContainerPath();
        return traceFolderPath.append(fileSystemElement.getFileSystemObject().getName());
    }

    private void setStatus(IStatus status) {
        this.fStatus = status;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setConflictHandler(ImportConflictHandler conflictHandler) {
        this.fConflictHandler = conflictHandler;
    }

    private final class FileObjectPathComparator
    implements Comparator<TraceFileSystemElement> {
        private FileObjectPathComparator() {
        }

        @Override
        public int compare(TraceFileSystemElement e1, TraceFileSystemElement e2) {
            IFileSystemObject o1 = e1.getFileSystemObject();
            IFileSystemObject o2 = e2.getFileSystemObject();
            Path p1 = new Path(e1.getProvider().getFullPath(o1));
            Path p2 = new Path(e2.getProvider().getFullPath(o2));
            int segmentCount1 = p1.segmentCount();
            int segmentCount2 = p2.segmentCount();
            int commonParentSegmentCount = Math.min(segmentCount1, segmentCount2) - 1;
            int i = 0;
            while (i < commonParentSegmentCount) {
                int compare = p1.segment(i).compareToIgnoreCase(p2.segment(i));
                if (compare != 0) {
                    return compare;
                }
                ++i;
            }
            if (segmentCount1 != segmentCount2) {
                return Integer.compare(segmentCount1, segmentCount2);
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }

    private class ImportProvider
    implements IImportStructureProvider {
        ImportProvider() {
        }

        public String getLabel(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getLabel();
        }

        public List getChildren(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return Arrays.asList(resource.getFiles().getChildren());
        }

        public InputStream getContents(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getProvider().getContents(resource.getFileSystemObject());
        }

        public String getFullPath(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.getProvider().getFullPath(resource.getFileSystemObject());
        }

        public boolean isFolder(Object element) {
            TraceFileSystemElement resource = (TraceFileSystemElement)((Object)element);
            return resource.isDirectory();
        }
    }
}

