/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;

public class TmfTreeModel<T extends ITmfTreeDataModel> {
    private List<String> fHeaders;
    private List<ITableColumnDescriptor> fColumnDescriptors;
    private List<T> fEntries;
    private @Nullable String fScope;

    public TmfTreeModel(List<String> headers, List<T> entries) {
        this(headers, entries, null);
    }

    public TmfTreeModel(List<String> headers, List<T> entries, @Nullable String scope) {
        this.fHeaders = headers;
        this.fColumnDescriptors = new ArrayList<ITableColumnDescriptor>();
        for (String header : headers) {
            TableColumnDescriptor.Builder builder = new TableColumnDescriptor.Builder();
            builder.setText(header);
            this.fColumnDescriptors.add(builder.build());
        }
        this.fEntries = entries;
        this.fScope = scope;
    }

    public List<ITableColumnDescriptor> getColumnDescriptors() {
        return this.fColumnDescriptors;
    }

    private TmfTreeModel(Builder<T> builder) {
        this.fHeaders = ((Builder)builder).fColumnDescriptors.stream().map(ITableColumnDescriptor::getText).collect(Collectors.toList());
        this.fColumnDescriptors = ((Builder)builder).fColumnDescriptors;
        this.fEntries = ((Builder)builder).fEntries;
        this.fScope = ((Builder)builder).fScope;
    }

    public List<String> getHeaders() {
        return this.fHeaders;
    }

    public List<T> getEntries() {
        return this.fEntries;
    }

    public @Nullable String getScope() {
        return this.fScope;
    }

    /* synthetic */ TmfTreeModel(Builder builder, TmfTreeModel tmfTreeModel) {
        this(builder);
    }

    public static class Builder<T extends ITmfTreeDataModel> {
        private List<ITableColumnDescriptor> fColumnDescriptors = new ArrayList<ITableColumnDescriptor>();
        private List<T> fEntries = Collections.emptyList();
        private @Nullable String fScope;

        public void setColumnDescriptors(List<ITableColumnDescriptor> columnDescriptors) {
            this.fColumnDescriptors = columnDescriptors;
        }

        public void setEntries(List<T> entries) {
            this.fEntries = entries;
        }

        public void setScope(String scope) {
            this.fScope = scope;
        }

        public TmfTreeModel<T> build() {
            return new TmfTreeModel(this, null);
        }
    }
}

