/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs;

import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.Messages;

public class Criteria {
    private boolean fLifeLineSelected = false;
    private boolean fSyncMessageSelected = false;
    private boolean fSyncMessageReturnSelected = false;
    private boolean fAsyncMessageSelected = false;
    private boolean fAsyncMessageReturnSelected = false;
    private boolean fCaseSenstiveSelected = false;
    private boolean fStopSelected = false;
    private String fExpression = null;
    private Pattern pattern = null;

    public Criteria() {
    }

    public Criteria(Criteria other) {
        this.fLifeLineSelected = other.fLifeLineSelected;
        this.fSyncMessageSelected = other.fSyncMessageSelected;
        this.fSyncMessageReturnSelected = other.fSyncMessageReturnSelected;
        this.fAsyncMessageSelected = other.fAsyncMessageSelected;
        this.fAsyncMessageReturnSelected = other.fAsyncMessageReturnSelected;
        this.fCaseSenstiveSelected = other.fCaseSenstiveSelected;
        this.fStopSelected = other.fStopSelected;
        this.fExpression = other.fExpression;
        this.updatePattern();
    }

    public boolean isAsyncMessageReturnSelected() {
        return this.fAsyncMessageReturnSelected;
    }

    public boolean isAsyncMessageSelected() {
        return this.fAsyncMessageSelected;
    }

    public String getExpression() {
        return this.fExpression;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isLifeLineSelected() {
        return this.fLifeLineSelected;
    }

    public boolean isStopSelected() {
        return this.fStopSelected;
    }

    public boolean isSyncMessageReturnSelected() {
        return this.fSyncMessageReturnSelected;
    }

    public boolean isSyncMessageSelected() {
        return this.fSyncMessageSelected;
    }

    public void setAsyncMessageReturnSelected(boolean b) {
        this.fAsyncMessageReturnSelected = b;
    }

    public void setAsyncMessageSelected(boolean b) {
        this.fAsyncMessageSelected = b;
    }

    public void setExpression(String string) {
        this.fExpression = string;
        this.updatePattern();
    }

    public void setLifeLineSelected(boolean b) {
        this.fLifeLineSelected = b;
    }

    public void setStopSelected(boolean b) {
        this.fStopSelected = b;
    }

    public void setSyncMessageReturnSelected(boolean b) {
        this.fSyncMessageReturnSelected = b;
    }

    public void setSyncMessageSelected(boolean b) {
        this.fSyncMessageSelected = b;
    }

    public boolean isCaseSenstiveSelected() {
        return this.fCaseSenstiveSelected;
    }

    public void setCaseSenstiveSelected(boolean b) {
        this.fCaseSenstiveSelected = b;
        this.setExpression(this.fExpression);
    }

    public boolean compareTo(Criteria to) {
        boolean retVal = true;
        if (this.getExpression() != null) {
            retVal = this.getExpression().equals(to.getExpression());
        } else if (to.getExpression() != null) {
            retVal = to.getExpression().equals(this.getExpression());
        }
        return retVal && this.isCaseSenstiveSelected() == to.isCaseSenstiveSelected() && this.isAsyncMessageReturnSelected() == to.isAsyncMessageReturnSelected() && this.isAsyncMessageSelected() == to.isAsyncMessageSelected() && this.isLifeLineSelected() == to.isLifeLineSelected() && this.isStopSelected() == to.isStopSelected() && this.isSyncMessageReturnSelected() == to.isSyncMessageReturnSelected() && this.isSyncMessageSelected() == to.isSyncMessageSelected();
    }

    public void save(DialogSettings settings) {
        settings.put("expression", this.getExpression());
        settings.put("isCaseSenstiveSelected", this.isCaseSenstiveSelected());
        settings.put("isAsyncMessageReturnSelected", this.isAsyncMessageReturnSelected());
        settings.put("isAsyncMessageSelected", this.isAsyncMessageSelected());
        settings.put("isLifeLineSelected", this.isLifeLineSelected());
        settings.put("isStopSelected", this.isStopSelected());
        settings.put("isSyncMessageReturnSelected", this.isSyncMessageReturnSelected());
        settings.put("isSyncMessageSelected", this.isSyncMessageSelected());
    }

    public void load(DialogSettings settings) {
        this.setExpression(settings.get("expression"));
        this.setCaseSenstiveSelected(settings.getBoolean("isCaseSenstiveSelected"));
        this.setAsyncMessageReturnSelected(settings.getBoolean("isAsyncMessageReturnSelected"));
        this.setAsyncMessageSelected(settings.getBoolean("isAsyncMessageSelected"));
        this.setLifeLineSelected(settings.getBoolean("isLifeLineSelected"));
        this.setStopSelected(settings.getBoolean("isStopSelected"));
        this.setSyncMessageReturnSelected(settings.getBoolean("isSyncMessageReturnSelected"));
        this.setSyncMessageSelected(settings.getBoolean("isSyncMessageSelected"));
    }

    public String getGraphNodeSummary(ISDFilterProvider provider, String loaderClassName) {
        ArrayList<String> list = new ArrayList<String>();
        if (provider != null) {
            if (this.isLifeLineSelected()) {
                list.add(provider.getNodeName(0, loaderClassName));
            }
            if (this.isSyncMessageSelected()) {
                list.add(provider.getNodeName(1, loaderClassName));
            }
            if (this.isSyncMessageReturnSelected()) {
                list.add(provider.getNodeName(2, loaderClassName));
            }
            if (this.isAsyncMessageSelected()) {
                list.add(provider.getNodeName(3, loaderClassName));
            }
            if (this.isAsyncMessageReturnSelected()) {
                list.add(provider.getNodeName(4, loaderClassName));
            }
            if (this.isStopSelected()) {
                list.add(provider.getNodeName(5, loaderClassName));
            }
        } else {
            if (this.isLifeLineSelected()) {
                list.add(Messages.SequenceDiagram_Lifeline);
            }
            if (this.isSyncMessageSelected()) {
                list.add(Messages.SequenceDiagram_SynchronousMessage);
            }
            if (this.isSyncMessageReturnSelected()) {
                list.add(Messages.SequenceDiagram_SynchronousMessageReturn);
            }
            if (this.isAsyncMessageSelected()) {
                list.add(Messages.SequenceDiagram_AsynchronousMessage);
            }
            if (this.isAsyncMessageReturnSelected()) {
                list.add(Messages.SequenceDiagram_AsynchronousMessageReturn);
            }
            if (this.isStopSelected()) {
                list.add(Messages.SequenceDiagram_Stop);
            }
        }
        StringBuffer ret = new StringBuffer();
        String prefix = "[";
        for (String s : list) {
            ret.append(prefix);
            ret.append(s);
            prefix = " " + Messages.SequenceDiagram_or + " ";
        }
        ret.append("]");
        return ret.toString();
    }

    public boolean matches(String stringToMatch) {
        if (this.pattern == null) {
            return false;
        }
        return this.pattern.matcher(stringToMatch).matches();
    }

    private void updatePattern() {
        block5: {
            if (this.fExpression != null) {
                try {
                    if (this.fCaseSenstiveSelected) {
                        this.pattern = Pattern.compile(this.fExpression);
                        break block5;
                    }
                    this.pattern = Pattern.compile(this.fExpression, 2);
                }
                catch (PatternSyntaxException e) {
                    this.pattern = null;
                }
            } else {
                this.pattern = null;
            }
        }
    }
}

