/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.views.contentoutline;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.views.contentoutline.AbstractXMLContentOutlineConfiguration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLContentOutlineConfiguration
extends AbstractXMLContentOutlineConfiguration {
    static final String ATTR_NAME = "name";
    static final String ATTR_ID = "id";
    private ILabelProvider fAttributeShowingLabelProvider;
    private IContentProvider fContentProvider = null;
    boolean fShowAttributes = false;
    private final String OUTLINE_SHOW_ATTRIBUTE_PREF = "outline-show-attribute";
    private static final String OUTLINE_FILTER_PREF = "org.eclipse.wst.xml.ui.OutlinePage";

    public XMLContentOutlineConfiguration() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getDefaultString("outline-behavior.document-node").length() == 0) {
            store.setDefault("outline-behavior.document-node", "1, true");
        }
        if (store.getDefaultString("outline-behavior.instruction-node").length() == 0) {
            store.setDefault("outline-behavior.instruction-node", "2, true");
        }
        if (store.getDefaultString("outline-behavior.document-type-node").length() == 0) {
            store.setDefault("outline-behavior.document-type-node", "3, true");
        }
        if (store.getDefaultString("outline-behavior.document-fragment-node").length() == 0) {
            store.setDefault("outline-behavior.document-fragment-node", "4, true");
        }
        if (store.getDefaultString("outline-behavior.comment-node").length() == 0) {
            store.setDefault("outline-behavior.comment-node", "5, true");
        }
        if (store.getDefaultString("outline-behavior.attribute-node").length() == 0) {
            store.setDefault("outline-behavior.attribute-node", "6, false");
        }
        if (store.getDefaultString("outline-behavior.element-node").length() == 0) {
            store.setDefault("outline-behavior.element-node", "7, true");
        }
        if (store.getDefaultString("outline-behavior.entity-reference-node").length() == 0) {
            store.setDefault("outline-behavior.entity-reference-node", "8, true");
        }
        if (store.getDefaultString("outline-behavior.cdata-section-node").length() == 0) {
            store.setDefault("outline-behavior.cdata-section-node", "9, true");
        }
        if (store.getDefaultString("outline-behavior.entity-node").length() == 0) {
            store.setDefault("outline-behavior.entity-node", "10, true");
        }
        if (store.getDefaultString("outline-behavior.notation-node").length() == 0) {
            store.setDefault("outline-behavior.notation-node", "11, true");
        }
        if (store.getDefaultString("outline-behavior.text-node").length() == 0) {
            store.setDefault("outline-behavior.text-node", "12, false");
        }
    }

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        PropertyChangeUpdateActionContributionItem showAttributeItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)new ToggleShowAttributeAction(this.getPreferenceStore(), "outline-show-attribute", viewer));
        IContributionItem[] items = super.createMenuContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{showAttributeItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = showAttributeItem;
            items = combinedItems;
        }
        return items;
    }

    protected void enableShowAttributes(boolean showAttributes, TreeViewer treeViewer) {
    }

    @Override
    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            this.fContentProvider = new JFaceNodeContentProvider();
        }
        return this.fContentProvider;
    }

    private Object getFilteredNode(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            short nodeType = node.getNodeType();
            if (nodeType == 2) {
                node = ((Attr)node).getOwnerElement();
            } else if (nodeType == 3) {
                node = node.getParentNode();
            }
            return node;
        }
        return object;
    }

    private Object[] getFilteredNodes(Object[] filteredNodes) {
        int i = 0;
        while (i < filteredNodes.length) {
            filteredNodes[i] = this.getFilteredNode(filteredNodes[i]);
            ++i;
        }
        return filteredNodes;
    }

    @Override
    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fAttributeShowingLabelProvider == null) {
            this.fAttributeShowingLabelProvider = new AttributeShowingLabelProvider();
        }
        return this.fAttributeShowingLabelProvider;
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        ISelection filteredSelection = selection;
        if (selection instanceof IStructuredSelection) {
            Object[] filteredNodes = this.getFilteredNodes(((IStructuredSelection)selection).toArray());
            filteredSelection = new StructuredSelection(filteredNodes);
        }
        return filteredSelection;
    }

    protected String getOutlineFilterTarget() {
        return OUTLINE_FILTER_PREF;
    }

    private class AttributeShowingLabelProvider
    extends JFaceNodeLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private AttributeShowingLabelProvider() {
        }

        @Override
        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        private Node getAttributeToShow(Element element) {
            NamedNodeMap attributes = element.getAttributes();
            Node idTypedAttribute = null;
            Node requiredAttribute = null;
            boolean hasId = false;
            boolean hasName = false;
            Node shownAttribute = null;
            CMElementDeclaration elementDecl = null;
            ModelQuery mq = ModelQueryUtil.getModelQuery((Document)element.getOwnerDocument());
            if (mq != null) {
                elementDecl = mq.getCMElementDeclaration(element);
            }
            if (elementDecl != null) {
                CMNamedNodeMap attributeDeclarationMap = elementDecl.getAttributes();
                int i = 0;
                while (i < attributes.getLength() && idTypedAttribute == null) {
                    Node attr = attributes.item(i);
                    String attrName = attr.getNodeName();
                    CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attributeDeclarationMap.getNamedItem(attrName);
                    if (attrDecl != null) {
                        if (attrDecl.getAttrType() != null && "ID".equals(attrDecl.getAttrType().getDataTypeName())) {
                            idTypedAttribute = attr;
                        } else if (attrDecl.getUsage() == 2 && requiredAttribute == null) {
                            requiredAttribute = attr;
                        } else {
                            hasId = hasId || attrName.equals(XMLContentOutlineConfiguration.ATTR_ID);
                            hasName = hasName || attrName.equals(XMLContentOutlineConfiguration.ATTR_NAME);
                        }
                    }
                    ++i;
                }
            }
            if (idTypedAttribute != null) {
                shownAttribute = idTypedAttribute;
            } else if (hasId) {
                shownAttribute = attributes.getNamedItem(XMLContentOutlineConfiguration.ATTR_ID);
            } else if (hasName) {
                shownAttribute = attributes.getNamedItem(XMLContentOutlineConfiguration.ATTR_NAME);
            } else if (requiredAttribute != null) {
                shownAttribute = requiredAttribute;
            }
            if (shownAttribute == null) {
                shownAttribute = attributes.item(0);
            }
            return shownAttribute;
        }

        @Override
        public String getText(Object o) {
            if (o instanceof Node) {
                String attributeValue;
                String attributeName;
                Node shownAttribute;
                Node node = (Node)o;
                StringBuffer buffer = new StringBuffer(super.getText(node));
                if (node.getNodeType() == 1 && XMLContentOutlineConfiguration.this.fShowAttributes && node.hasAttributes() && (shownAttribute = this.getAttributeToShow((Element)node)) != null && (attributeName = shownAttribute.getNodeName()) != null && attributeName.length() > 0 && (attributeValue = shownAttribute.getNodeValue()) != null) {
                    buffer.append(" ");
                    buffer.append(attributeName);
                    buffer.append("=");
                    buffer.append(attributeValue);
                }
                return buffer.toString();
            }
            return super.toString();
        }

        public String getToolTipText(Object element) {
            if (element instanceof Node) {
                switch (((Node)element).getNodeType()) {
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: {
                        String nodeValue = ((Node)element).getNodeValue().trim();
                        return this.prepareText(nodeValue);
                    }
                    case 1: {
                        Node previous = ((Node)element).getPreviousSibling();
                        if (previous != null && previous.getNodeType() == 3) {
                            previous = previous.getPreviousSibling();
                        }
                        if (previous == null || previous.getNodeType() != 8) break;
                        return this.getToolTipText(previous);
                    }
                }
            }
            return super.getToolTipText(element);
        }

        private String prepareText(String text) {
            StringBuffer nodeText = new StringBuffer();
            int i = 0;
            while (i < text.length()) {
                char c = text.charAt(i);
                if (c != '\r' && c != '\n') {
                    nodeText.append(c);
                } else if (c == '\r' || c == '\n') {
                    nodeText.append('\n');
                    while (Character.isWhitespace(c) && i < text.length()) {
                        c = text.charAt(++i);
                    }
                    nodeText.append(c);
                }
                ++i;
            }
            return nodeText.toString();
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof Node) {
                String attributeValue;
                String attributeName;
                Node shownAttribute;
                Node node = (Node)element;
                StyledString styleString = new StyledString(super.getText(node));
                if (node.getNodeType() == 1 && XMLContentOutlineConfiguration.this.fShowAttributes && node.hasAttributes() && (shownAttribute = this.getAttributeToShow((Element)node)) != null && (attributeName = shownAttribute.getNodeName()) != null && attributeName.length() > 0 && (attributeValue = shownAttribute.getNodeValue()) != null) {
                    StringBuffer buffer = new StringBuffer(" ");
                    buffer.append(attributeName);
                    buffer.append("=");
                    buffer.append(attributeValue);
                    styleString.append(buffer.toString(), StyledString.QUALIFIER_STYLER);
                }
                return styleString;
            }
            return new StyledString(this.getText(element));
        }
    }

    private class ToggleShowAttributeAction
    extends PropertyChangeUpdateAction {
        private TreeViewer fTreeViewer;

        public ToggleShowAttributeAction(IPreferenceStore store, String preference, TreeViewer treeViewer) {
            super(XMLUIMessages.XMLContentOutlineConfiguration_0, store, preference, true);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/prop_ps.gif"));
            this.fTreeViewer = treeViewer;
            this.update();
        }

        public void update() {
            super.update();
            XMLContentOutlineConfiguration.this.fShowAttributes = this.isChecked();
            XMLContentOutlineConfiguration.this.enableShowAttributes(XMLContentOutlineConfiguration.this.fShowAttributes, this.fTreeViewer);
            this.fTreeViewer.refresh(true);
        }
    }
}

