/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.html;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class HTMLUtil {
    public static StringBuffer createHTMLStartTag(String elementName, Map elementAttributes, boolean insertLineBreak) {
        StringBuffer element = new StringBuffer();
        if (elementName != null) {
            element.append(HTMLUtil.openHTMLStartTag(elementName));
            if (elementAttributes != null && !elementAttributes.isEmpty()) {
                element.append(" ").append(HTMLUtil.createAttributeList(elementAttributes));
            }
            element.append(HTMLUtil.closeHTMLTag(insertLineBreak));
        }
        return element;
    }

    public static StringBuffer createHTMLStartTag(String elementName, boolean insertLineBreak) {
        return HTMLUtil.createHTMLStartTag(elementName, null, insertLineBreak);
    }

    public static StringBuffer createHTMLStartTag(String elementName) {
        return HTMLUtil.createHTMLStartTag(elementName, null, true);
    }

    public static StringBuffer createHTMLEndTag(String elementName, boolean addNewLine) {
        StringBuffer closingElement = new StringBuffer();
        if (elementName != null) {
            closingElement.append("<").append("/").append(elementName).append(HTMLUtil.closeHTMLTag(addNewLine));
        }
        return closingElement;
    }

    public static String createAttributeList(Map attributes) {
        if (attributes == null) {
            return null;
        }
        StringBuilder attributeList = new StringBuilder();
        Set attrNames = attributes.keySet();
        Iterator it = attrNames.iterator();
        while (it.hasNext()) {
            Object name = it.next();
            Object value = attributes.get(name);
            if (!(name instanceof String) || !(value instanceof String)) continue;
            attributeList.append(HTMLUtil.createAttribute((String)name, (String)value));
            if (!it.hasNext()) continue;
            attributeList.append(" ");
        }
        return attributeList.toString();
    }

    public static StringBuffer createAttribute(String attrName, String attrValue) {
        StringBuffer attribute = new StringBuffer();
        if (attrName != null && attrValue != null) {
            attribute.append(attrName).append("=").append("\"").append(attrValue).append("\"");
        }
        return attribute;
    }

    public static StringBuffer openHTMLStartTag(String elementName) {
        return new StringBuffer().append("<").append(elementName);
    }

    public static StringBuffer closeHTMLTag() {
        return HTMLUtil.closeHTMLTag(true);
    }

    public static StringBuffer closeHTMLTag(boolean newLine) {
        StringBuffer closing = new StringBuffer().append(">");
        if (newLine) {
            closing.append("\n");
        }
        return closing;
    }

    public static boolean equalCharArrayContent(char[] a, char[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

