/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.HyperlinkDetectorTargetDescriptor;

class HyperlinkDetectorsConfigurationBlock
implements IPreferenceConfigurationBlock {
    private static final String MODIFIER_DELIMITER = TextEditorMessages.HyperlinkKeyModifier_delimiter;
    private OverlayPreferenceStore fStore;
    private CheckboxTableViewer fHyperlinkDetectorsViewer;
    private ListItem[] fListModel;
    private final HyperlinkDetectorDescriptor[] fHyperlinkDetectorDescriptors;
    private Text fHyperlinkDefaultKeyModifierText;
    private Text fHyperlinkKeyModifierText;
    private Button fHyperlinksEnabledCheckBox;
    private StatusInfo fHyperlinkKeyModifierStatus;
    private PreferencePage fPreferencePage;

    public HyperlinkDetectorsConfigurationBlock(PreferencePage preferencePage, OverlayPreferenceStore store) {
        Assert.isNotNull((Object)store);
        Assert.isNotNull((Object)preferencePage);
        this.fStore = store;
        this.fPreferencePage = preferencePage;
        this.fHyperlinkDetectorDescriptors = EditorsUI.getHyperlinkDetectorRegistry().getHyperlinkDetectorDescriptors();
        this.fStore.addKeys(this.createOverlayStoreKeys());
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        int i = 0;
        while (i < this.fHyperlinkDetectorDescriptors.length) {
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, this.fHyperlinkDetectorDescriptors[i].getId()));
            overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, String.valueOf(this.fHyperlinkDetectorDescriptors[i].getId()) + "_stateMask"));
            ++i;
        }
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "hyperlinkKeyModifier"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "hyperlinksEnabled"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    @Override
    public Control createControl(Composite parent) {
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.addFiller(composite, 2);
        String label = TextEditorMessages.HyperlinksEnabled_label;
        this.fHyperlinksEnabledCheckBox = this.addCheckBox(composite, label, "hyperlinksEnabled", 0);
        this.fHyperlinksEnabledCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean state = HyperlinkDetectorsConfigurationBlock.this.fHyperlinksEnabledCheckBox.getSelection();
                HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.setEnabled(state);
                HyperlinkDetectorsConfigurationBlock.this.fHyperlinkKeyModifierText.setEnabled(state && HyperlinkDetectorsConfigurationBlock.this.getSelectedItem() != null);
                HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDetectorsViewer.getTable().setEnabled(state);
                HyperlinkDetectorsConfigurationBlock.this.handleHyperlinkKeyModifierModified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        label = TextEditorMessages.HyperlinkDefaultKeyModifier_label;
        this.fHyperlinkDefaultKeyModifierText = (Text)this.addTextField(composite, label, "hyperlinkKeyModifier", 15, 20, pixelConverter)[1];
        this.fHyperlinkDefaultKeyModifierText.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent e) {
                this.isModifierCandidate = e.keyCode > 0 && e.character == '\u0000' && e.stateMask == 0;
            }

            public void keyReleased(KeyEvent e) {
                if (this.isModifierCandidate && e.stateMask > 0 && e.character == '\u0000') {
                    boolean needsPostfixDelimiter;
                    String modifierString = HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.getText();
                    Point selection = HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.getSelection();
                    int i = selection.x - 1;
                    while (i > -1 && Character.isWhitespace(modifierString.charAt(i))) {
                        --i;
                    }
                    boolean needsPrefixDelimiter = i > -1 && !String.valueOf(modifierString.charAt(i)).equals(MODIFIER_DELIMITER);
                    i = selection.y;
                    while (i < modifierString.length() && Character.isWhitespace(modifierString.charAt(i))) {
                        ++i;
                    }
                    boolean bl = needsPostfixDelimiter = i < modifierString.length() && !String.valueOf(modifierString.charAt(i)).equals(MODIFIER_DELIMITER);
                    String insertString = needsPrefixDelimiter && needsPostfixDelimiter ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertDelimiterAndModifierAndDelimiter, Action.findModifierString((int)e.stateMask)) : (needsPrefixDelimiter ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertDelimiterAndModifier, Action.findModifierString((int)e.stateMask)) : (needsPostfixDelimiter ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertModifierAndDelimiter, Action.findModifierString((int)e.stateMask)) : Action.findModifierString((int)e.stateMask)));
                    HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.insert(insertString);
                }
            }
        });
        this.fHyperlinkDefaultKeyModifierText.addModifyListener(e -> this.handleHyperlinkDefaultKeyModifierModified());
        this.addFiller(composite, 2);
        Composite editorComposite = new Composite(composite, 0);
        GridData gd = new GridData(4, 128, true, false);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        editorComposite.setLayoutData((Object)gd);
        TableColumnLayout tableColumnlayout = new TableColumnLayout();
        editorComposite.setLayout((Layout)tableColumnlayout);
        Table hyperlinkDetectorTable = new Table(editorComposite, 68388);
        hyperlinkDetectorTable.setHeaderVisible(true);
        hyperlinkDetectorTable.setLinesVisible(true);
        hyperlinkDetectorTable.setFont(parent.getFont());
        hyperlinkDetectorTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperlinkDetectorsConfigurationBlock.this.handleListSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ColumnWeightData columnLayoutData = new ColumnWeightData(1);
        TableColumn nameColumn = new TableColumn(hyperlinkDetectorTable, 0, 0);
        nameColumn.setText(TextEditorMessages.HyperlinkDetectorTable_nameColumn);
        tableColumnlayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)columnLayoutData);
        TableColumn modifierKeysColumn = new TableColumn(hyperlinkDetectorTable, 0, 1);
        modifierKeysColumn.setText(TextEditorMessages.HyperlinkDetectorTable_modifierKeysColumn);
        tableColumnlayout.setColumnData((Widget)modifierKeysColumn, (ColumnLayoutData)columnLayoutData);
        TableColumn targetNameColumn = new TableColumn(hyperlinkDetectorTable, 0, 2);
        targetNameColumn.setText(TextEditorMessages.HyperlinkDetectorTable_targetNameColumn);
        tableColumnlayout.setColumnData((Widget)targetNameColumn, (ColumnLayoutData)columnLayoutData);
        this.fHyperlinkDetectorsViewer = new CheckboxTableViewer(hyperlinkDetectorTable);
        this.fHyperlinkDetectorsViewer.setUseHashlookup(true);
        this.fHyperlinkDetectorsViewer.addCheckStateListener(event -> {
            String id = ((ListItem)event.getElement()).id;
            if (id == null) {
                return;
            }
            this.fStore.setValue(id, !event.getChecked());
        });
        this.fHyperlinkDetectorsViewer.setLabelProvider((IBaseLabelProvider)new ItemLabelProvider());
        this.fHyperlinkDetectorsViewer.setContentProvider((IContentProvider)new ItemContentProvider());
        gd = new GridData(4, 4, true, false);
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(10);
        this.fHyperlinkDetectorsViewer.getControl().setLayoutData((Object)gd);
        label = TextEditorMessages.HyperlinkKeyModifier_label;
        this.fHyperlinkKeyModifierText = (Text)this.addTextField(composite, label, null, 15, 20, pixelConverter)[1];
        this.fHyperlinkKeyModifierText.addKeyListener(new KeyListener(){
            private boolean isModifierCandidate;

            public void keyPressed(KeyEvent e) {
                this.isModifierCandidate = e.keyCode > 0 && e.character == '\u0000' && e.stateMask == 0;
            }

            public void keyReleased(KeyEvent e) {
                if (this.isModifierCandidate && e.stateMask > 0 && e.character == '\u0000') {
                    boolean needsPostfixDelimiter;
                    String modifierString = HyperlinkDetectorsConfigurationBlock.this.fHyperlinkKeyModifierText.getText();
                    Point selection = HyperlinkDetectorsConfigurationBlock.this.fHyperlinkKeyModifierText.getSelection();
                    int i = selection.x - 1;
                    while (i > -1 && Character.isWhitespace(modifierString.charAt(i))) {
                        --i;
                    }
                    boolean needsPrefixDelimiter = i > -1 && !String.valueOf(modifierString.charAt(i)).equals(MODIFIER_DELIMITER);
                    i = selection.y;
                    while (i < modifierString.length() && Character.isWhitespace(modifierString.charAt(i))) {
                        ++i;
                    }
                    boolean bl = needsPostfixDelimiter = i < modifierString.length() && !String.valueOf(modifierString.charAt(i)).equals(MODIFIER_DELIMITER);
                    String insertString = needsPrefixDelimiter && needsPostfixDelimiter ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertDelimiterAndModifierAndDelimiter, Action.findModifierString((int)e.stateMask)) : (needsPrefixDelimiter ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertDelimiterAndModifier, Action.findModifierString((int)e.stateMask)) : (needsPostfixDelimiter ? NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_insertModifierAndDelimiter, Action.findModifierString((int)e.stateMask)) : Action.findModifierString((int)e.stateMask)));
                    HyperlinkDetectorsConfigurationBlock.this.fHyperlinkKeyModifierText.insert(insertString);
                }
            }
        });
        this.fHyperlinkKeyModifierText.addModifyListener(e -> this.handleHyperlinkKeyModifierModified());
        return composite;
    }

    @Override
    public void applyData(Object data) {
    }

    private void addFiller(Composite composite, int horizontalSpan) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = horizontalSpan;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    private Button addCheckBox(Composite composite, String label, final String key, int indentation) {
        final Button checkBox = new Button(composite, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean value = checkBox.getSelection();
                HyperlinkDetectorsConfigurationBlock.this.fStore.setValue(key, value);
            }
        });
        return checkBox;
    }

    private Control[] addTextField(Composite composite, String label, String key, int textLimit, int indentation, PixelConverter pixelConverter) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = pixelConverter.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        textControl.addModifyListener(e -> {
            String value = textControl.getText();
            if (key != null) {
                this.fStore.setValue(key, value);
            }
        });
        return new Control[]{labelControl, textControl};
    }

    private Object[] getCheckedItems() {
        ArrayList<ListItem> result = new ArrayList<ListItem>();
        int i = 0;
        while (i < this.fListModel.length) {
            if (!this.fStore.getBoolean(this.fListModel[i].id)) {
                result.add(this.fListModel[i]);
            }
            ++i;
        }
        return result.toArray();
    }

    @Override
    public boolean canPerformOk() {
        return true;
    }

    @Override
    public void performOk() {
        this.fStore.setValue("hyperlinkKeyModifierMask", HyperlinkDetectorsConfigurationBlock.computeStateMask(this.fHyperlinkKeyModifierText.getText()));
    }

    @Override
    public void performDefaults() {
        this.fStore.loadDefaults();
        this.initialize();
    }

    private void handleListSelection() {
        ListItem item = this.getSelectedItem();
        if (item == null) {
            this.fHyperlinkKeyModifierText.setEnabled(false);
            return;
        }
        this.fHyperlinkKeyModifierText.setEnabled(this.fHyperlinkDetectorsViewer.getChecked((Object)item));
        String text = item.modifierKeys;
        if (text == null) {
            text = this.fHyperlinkDefaultKeyModifierText.getText();
        }
        this.fHyperlinkKeyModifierText.setText(text);
    }

    @Override
    public void initialize() {
        String modifierString = this.fStore.getString("hyperlinkKeyModifier");
        if (HyperlinkDetectorsConfigurationBlock.computeStateMask(modifierString) == -1) {
            int stateMask = this.fStore.getInt("hyperlinkKeyModifierMask");
            if (stateMask == -1) {
                this.fHyperlinkDefaultKeyModifierText.setText("");
            } else {
                this.fHyperlinkDefaultKeyModifierText.setText(HyperlinkDetectorsConfigurationBlock.getModifierString(stateMask));
            }
        } else {
            this.fHyperlinkDefaultKeyModifierText.setText(modifierString);
        }
        boolean isEnabled = this.fStore.getBoolean("hyperlinksEnabled");
        this.fHyperlinksEnabledCheckBox.setSelection(isEnabled);
        this.fHyperlinkKeyModifierText.setEnabled(isEnabled);
        this.fHyperlinkDefaultKeyModifierText.setEnabled(isEnabled);
        this.fListModel = this.createListModel();
        this.fHyperlinkDetectorsViewer.setInput((Object)this.fListModel);
        this.fHyperlinkDetectorsViewer.setAllChecked(false);
        this.fHyperlinkDetectorsViewer.setCheckedElements(this.getCheckedItems());
        this.fHyperlinkDetectorsViewer.getTable().setEnabled(isEnabled);
        this.fHyperlinkKeyModifierText.setText("");
        this.handleListSelection();
    }

    private ListItem[] createListModel() {
        ArrayList<ListItem> listModelItems = new ArrayList<ListItem>();
        int i = 0;
        while (i < this.fHyperlinkDetectorDescriptors.length) {
            HyperlinkDetectorDescriptor desc = this.fHyperlinkDetectorDescriptors[i];
            HyperlinkDetectorTargetDescriptor target = desc.getTarget();
            int stateMask = this.fStore.getInt(String.valueOf(desc.getId()) + "_stateMask");
            String modifierKeys = HyperlinkDetectorsConfigurationBlock.getModifierString(stateMask);
            listModelItems.add(new ListItem(desc.getId(), desc.getName(), target.getName(), modifierKeys));
            ++i;
        }
        Comparator comparator = (o1, o2) -> {
            String label1 = o1.name;
            String label2 = o2.name;
            return Collator.getInstance().compare(label1, label2);
        };
        Collections.sort(listModelItems, comparator);
        ListItem[] items = new ListItem[listModelItems.size()];
        listModelItems.toArray(items);
        return items;
    }

    private ListItem getSelectedItem() {
        return (ListItem)this.fHyperlinkDetectorsViewer.getStructuredSelection().getFirstElement();
    }

    private void handleHyperlinkKeyModifierModified() {
        String modifiers = this.fHyperlinkKeyModifierText.getText();
        int stateMask = HyperlinkDetectorsConfigurationBlock.computeStateMask(modifiers);
        if (this.fHyperlinksEnabledCheckBox.getSelection() && (stateMask == -1 || (stateMask & 0x20000) != 0)) {
            this.fHyperlinkKeyModifierStatus = stateMask == -1 ? new StatusInfo(4, NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_error_modifierIsNotValid, modifiers)) : new StatusInfo(4, TextEditorMessages.HyperlinkKeyModifier_error_shiftIsDisabled);
            this.applyToStatusLine(this.getHyperlinkKeyModifierStatus());
            this.fPreferencePage.setValid(this.getHyperlinkKeyModifierStatus().isOK());
        } else {
            ListItem item = this.getSelectedItem();
            if (item != null) {
                if (item.modifierKeys != null || !modifiers.equalsIgnoreCase(this.fHyperlinkDefaultKeyModifierText.getText())) {
                    item.modifierKeys = modifiers;
                }
                this.fHyperlinkDetectorsViewer.refresh((Object)this.getSelectedItem());
                this.fStore.setValue(String.valueOf(item.id) + "_stateMask", stateMask);
            }
            this.fHyperlinkKeyModifierStatus = new StatusInfo();
            this.fPreferencePage.setValid(true);
            this.applyToStatusLine(this.fHyperlinkKeyModifierStatus);
        }
    }

    private void handleHyperlinkDefaultKeyModifierModified() {
        String modifiers = this.fHyperlinkDefaultKeyModifierText.getText();
        int stateMask = HyperlinkDetectorsConfigurationBlock.computeStateMask(modifiers);
        if (this.fHyperlinksEnabledCheckBox.getSelection() && (stateMask == -1 || (stateMask & 0x20000) != 0)) {
            this.fHyperlinkKeyModifierStatus = stateMask == -1 ? new StatusInfo(4, NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_error_modifierIsNotValid, modifiers)) : new StatusInfo(4, TextEditorMessages.HyperlinkKeyModifier_error_shiftIsDisabled);
            this.applyToStatusLine(this.getHyperlinkKeyModifierStatus());
            this.fPreferencePage.setValid(this.getHyperlinkKeyModifierStatus().isOK());
        } else {
            this.fStore.setValue("hyperlinkKeyModifier", modifiers);
            this.fHyperlinkKeyModifierStatus = new StatusInfo();
            this.fPreferencePage.setValid(true);
            this.applyToStatusLine(this.fHyperlinkKeyModifierStatus);
            this.fHyperlinkDetectorsViewer.refresh();
            this.handleListSelection();
        }
    }

    private IStatus getHyperlinkKeyModifierStatus() {
        if (this.fHyperlinkKeyModifierStatus == null) {
            this.fHyperlinkKeyModifierStatus = new StatusInfo();
        }
        return this.fHyperlinkKeyModifierStatus;
    }

    private static final int computeStateMask(String modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.length() == 0) {
            return 0;
        }
        int stateMask = 0;
        StringTokenizer modifierTokenizer = new StringTokenizer(modifiers, ",;.:+-* ");
        while (modifierTokenizer.hasMoreTokens()) {
            int modifier = HyperlinkDetectorsConfigurationBlock.findLocalizedModifier(modifierTokenizer.nextToken());
            if (modifier == 0 || (stateMask & modifier) == modifier) {
                return -1;
            }
            stateMask |= modifier;
        }
        return stateMask;
    }

    private static final int findLocalizedModifier(String modifierName) {
        if (modifierName == null) {
            return 0;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (modifierName.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    private static final String getModifierString(int stateMask) {
        if (stateMask == -1) {
            return null;
        }
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = HyperlinkDetectorsConfigurationBlock.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = HyperlinkDetectorsConfigurationBlock.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = HyperlinkDetectorsConfigurationBlock.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = HyperlinkDetectorsConfigurationBlock.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static final String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return NLSUtility.format(TextEditorMessages.HyperlinkKeyModifier_concatModifierStrings, new String[]{modifierString, newModifierString});
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                this.fPreferencePage.setMessage(message, 0);
                this.fPreferencePage.setErrorMessage(null);
                break;
            }
            case 2: {
                this.fPreferencePage.setMessage(message, 2);
                this.fPreferencePage.setErrorMessage(null);
                break;
            }
            case 1: {
                this.fPreferencePage.setMessage(message, 1);
                this.fPreferencePage.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                this.fPreferencePage.setMessage(null);
                this.fPreferencePage.setErrorMessage(message);
            }
        }
    }

    @Override
    public void dispose() {
    }

    private static final class ItemContentProvider
    implements IStructuredContentProvider {
        private ItemContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (ListItem[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ItemLabelProvider
    implements ITableLabelProvider {
        private ItemLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((ListItem)element).name;
                }
                case 1: {
                    String text = ((ListItem)element).modifierKeys;
                    if (text == null) {
                        return HyperlinkDetectorsConfigurationBlock.this.fHyperlinkDefaultKeyModifierText.getText();
                    }
                    return text;
                }
                case 2: {
                    return ((ListItem)element).targetName;
                }
            }
            Assert.isLegal((boolean)false);
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class ListItem {
        final String id;
        final String name;
        final String targetName;
        String modifierKeys = "";

        ListItem(String id, String name, String targetName, String modifierKeys) {
            this.id = id;
            this.name = name;
            this.targetName = targetName;
            this.modifierKeys = modifierKeys;
        }
    }
}

