/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.preferences.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;

public abstract class AbstractPreferencePage
extends PreferencePage
implements ModifyListener,
SelectionListener,
IWorkbenchPreferencePage {
    protected static final int WIDTH_VALIDATION_LOWER_LIMIT = 0;
    protected static final int WIDTH_VALIDATION_UPPER_LIMIT = 999;

    protected Button createCheckBox(Composite group, String label) {
        Button button = new Button(group, 16416);
        button.setText(label);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    protected void initCheckbox(Button box, String key) {
        if (box != null && key != null) {
            box.setSelection(this.getPreferenceStore().getBoolean(key));
        }
    }

    protected void defaultCheckbox(Button box, String key) {
        if (box != null && key != null) {
            box.setSelection(this.getPreferenceStore().getDefaultBoolean(key));
        }
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected Control createContents(Composite parent) {
        return this.createScrolledComposite(parent);
    }

    protected Combo createDropDownBox(Composite parent) {
        Combo comboBox = new Combo(parent, 12);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        comboBox.setLayoutData((Object)data);
        return comboBox;
    }

    protected Group createGroup(Composite parent, int numColumns) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.horizontalIndent = 0;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)data);
        return group;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Button createRadioButton(Composite group, String label) {
        Button button = new Button(group, 16);
        button.setText(label);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        button.setLayoutData((Object)data);
        return button;
    }

    protected Composite createScrolledComposite(Composite parent) {
        ScrolledComposite sc1 = new ScrolledComposite(parent, 768);
        sc1.setLayoutData((Object)new GridData(1808));
        Composite composite = this.createComposite((Composite)sc1, 1);
        sc1.setContent((Control)composite);
        this.setSize(composite);
        return composite;
    }

    protected Label createSeparator(Composite parent, int columnSpan) {
        Label separator = new Label(parent, 258);
        GridData data = new GridData(4);
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.horizontalSpan = columnSpan;
        separator.setLayoutData((Object)data);
        return separator;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        return text;
    }

    protected void enableValues() {
    }

    protected Preferences getModelPreferences() {
        return SSECorePlugin.getDefault().getPluginPreferences();
    }

    public void init(IWorkbench workbench) {
    }

    protected void initializeValues() {
    }

    protected boolean loadPreferences() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractPreferencePage.this.initializeValues();
                AbstractPreferencePage.this.validateValues();
                AbstractPreferencePage.this.enableValues();
            }
        });
        return true;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget != null && e.widget.isDisposed()) {
            return;
        }
        this.validateValues();
        this.enableValues();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        this.savePreferences();
        return true;
    }

    protected boolean savePreferences() {
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractPreferencePage.this.storeValues();
            }
        });
        return true;
    }

    protected void setInvalidInputMessage(String widthText) {
        String msg = NLS.bind((String)SSEUIMessages._4concat, (Object[])new Object[]{widthText});
        this.setErrorMessage(msg);
    }

    protected void setSize(Composite composite) {
        if (composite != null) {
            this.applyDialogFont(composite);
            Point minSize = composite.computeSize(-1, -1);
            composite.setSize(minSize);
            if (composite.getParent() instanceof ScrolledComposite) {
                ScrolledComposite sc1 = (ScrolledComposite)composite.getParent();
                sc1.setMinSize(minSize);
                sc1.setExpandHorizontal(true);
                sc1.setExpandVertical(true);
            }
        }
    }

    protected void storeValues() {
        SSEUIPlugin.getDefault().savePluginPreferences();
    }

    protected void validateValues() {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget != null && e.widget.isDisposed()) {
            return;
        }
        this.validateValues();
        this.enableValues();
    }
}

