/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.tests.stateprovider;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.common.TmfXmlTestFiles;
import org.eclipse.tracecompass.tmf.analysis.xml.core.tests.module.XmlUtilsTest;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConsumingFsmTest {
    private static final @NonNull String TEST_TRACE = "test_traces/testTrace5.xml";
    ITmfTrace fTrace;
    XmlPatternAnalysis fModule;

    @Before
    public void setUp() throws TmfAnalysisException {
        ITmfTrace trace = XmlUtilsTest.initializeTrace(TEST_TRACE);
        @NonNull XmlPatternAnalysis module = XmlUtilsTest.initializePatternModule(TmfXmlTestFiles.CONSUMING_FSM_TEST);
        module.setTrace(trace);
        module.schedule();
        module.waitForCompletion();
        this.fTrace = trace;
        this.fModule = module;
    }

    @After
    public void cleanUp() {
        this.fTrace.dispose();
        this.fModule.dispose();
    }

    @Test
    public void testConsumingFsm() throws AttributeNotFoundException, StateSystemDisposedException {
        XmlPatternAnalysis module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem(module.getId());
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"consuming"});
        int[] expectedStarts = new int[]{1, 7, 7};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueLong((long)1L)};
        XmlUtilsTest.verifyStateIntervals("testConsuming", ss, quark, expectedStarts, expectedValues);
    }

    @Test
    public void testNonConsumingFsm() throws AttributeNotFoundException, StateSystemDisposedException {
        XmlPatternAnalysis module = this.fModule;
        Assert.assertNotNull((Object)module);
        ITmfStateSystem ss = module.getStateSystem(module.getId());
        Assert.assertNotNull((Object)ss);
        int quark = ss.getQuarkAbsolute(new String[]{"non_consuming"});
        int[] expectedStarts = new int[]{1, 7, 7};
        ITmfStateValue[] expectedValues = new ITmfStateValue[]{TmfStateValue.nullValue(), TmfStateValue.newValueLong((long)3L)};
        XmlUtilsTest.verifyStateIntervals("testNonConsuming", ss, quark, expectedStarts, expectedValues);
    }
}

