/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.counters.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.counters.core.CounterAnalysis;
import org.eclipse.tracecompass.internal.analysis.counters.core.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectedCounterQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class CounterDataProvider
extends AbstractTreeCommonXDataProvider<CounterAnalysis, TmfTreeDataModel> {
    public static final String ID = "org.eclipse.tracecompass.analysis.counters.core.CounterDataProvider";
    public static final String CUMULATIVE_COUNTER_KEY = "isCumulative";
    private static final String TITLE = Objects.requireNonNull(Messages.CounterDataProvider_ChartTitle);

    public static @Nullable CounterDataProvider create(ITmfTrace trace, @Nullable CounterAnalysis module) {
        if (trace instanceof TmfExperiment) {
            throw new UnsupportedOperationException("This data providers does not support experiment");
        }
        if (module != null) {
            module.schedule();
            return new CounterDataProvider(trace, module);
        }
        return null;
    }

    private CounterDataProvider(ITmfTrace trace, CounterAnalysis analysis) {
        super(trace, (TmfStateSystemAnalysisModule)analysis);
    }

    protected TmfTreeModel<TmfTreeDataModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) {
        ArrayList<TmfTreeDataModel> entries = new ArrayList<TmfTreeDataModel>();
        long rootId = this.getId(-1);
        entries.add(new TmfTreeDataModel(rootId, -1L, Collections.singletonList(this.getTrace().getName())));
        this.addTreeViewerBranch(ss, rootId, Collections.singletonList("Grouped"), entries);
        this.addTreeViewerBranch(ss, rootId, Collections.singletonList("Ungrouped"), entries);
        return new TmfTreeModel(Collections.emptyList(), entries);
    }

    private void addTreeViewerBranch(ITmfStateSystem ss, long parentId, List<String> branchName, List<TmfTreeDataModel> entries) {
        int quark = ss.optQuarkAbsolute(new String[]{branchName.get(0)});
        if (quark != -2 && !ss.getSubAttributes(quark, false).isEmpty()) {
            long id = this.getId(quark);
            TmfTreeDataModel branch = new TmfTreeDataModel(id, parentId, branchName);
            entries.add(branch);
            this.addTreeViewerEntries(ss, id, quark, entries);
        }
    }

    private void addTreeViewerEntries(ITmfStateSystem ss, long parentId, int quark, List<TmfTreeDataModel> entries) {
        Iterator iterator = ss.getSubAttributes(quark, false).iterator();
        while (iterator.hasNext()) {
            int childQuark = (Integer)iterator.next();
            long id = this.getId(childQuark);
            TmfTreeDataModel childBranch = new TmfTreeDataModel(id, parentId, Collections.singletonList(ss.getAttributeName(childQuark)));
            entries.add(childBranch);
            this.addTreeViewerEntries(ss, id, childQuark, entries);
        }
    }

    @Deprecated
    protected @Nullable Map<String, IYModel> getYModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        return Maps.uniqueIndex(this.getYSeriesModels(ss, fetchParameters, monitor), IYModel::getName);
    }

    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        if (FetchParametersUtils.createSelectionTimeQuery(fetchParameters) != null) {
            return this.internalFetch(ss, fetchParameters, monitor);
        }
        return Collections.emptyList();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Collection<IYModel> internalFetch(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectedCounterQueryFilter filter = CounterDataProvider.createCounterQuery(fetchParameters);
        if (filter == null) {
            return null;
        }
        long stateSystemEndTime = ss.getCurrentEndTime();
        Collection<Long> times = CounterDataProvider.extractRequestedTimes(ss, filter, stateSystemEndTime);
        Map entries = Maps.filterValues((Map)this.getSelectedEntries((SelectionTimeQueryFilter)filter), q -> ss.getSubAttributes(q.intValue(), false).isEmpty());
        TreeMultimap countersIntervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparingLong(ITmfStateInterval::getStartTime));
        @NonNull Iterable query2d = ss.query2D(entries.values(), times);
        for (ITmfStateInterval interval : query2d) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            countersIntervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        ImmutableList.Builder ySeries = ImmutableList.builder();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            int quark = (Integer)entry.getValue();
            double[] yValues = CounterDataProvider.buildYValues(countersIntervals.get((Object)quark), filter);
            String seriesName = String.valueOf(this.getTrace().getName()) + '/' + ss.getFullAttributePath(quark);
            ySeries.add((Object)new YModel(((Long)entry.getKey()).longValue(), seriesName, yValues));
        }
        return ySeries.build();
    }

    private static @Nullable SelectedCounterQueryFilter createCounterQuery(Map<String, Object> parameters) {
        List timeRequested = DataProviderParameterUtils.extractTimeRequested(parameters);
        List selectedItems = DataProviderParameterUtils.extractSelectedItems(parameters);
        if (timeRequested == null || selectedItems == null) {
            return null;
        }
        Boolean isCumulativeParameter = DataProviderParameterUtils.extractBoolean(parameters, (String)CUMULATIVE_COUNTER_KEY);
        boolean isCumulative = isCumulativeParameter != null && isCumulativeParameter != false;
        return new SelectedCounterQueryFilter(timeRequested, (Collection)selectedItems, isCumulative);
    }

    private static Collection<Long> extractRequestedTimes(ITmfStateSystem ss, SelectedCounterQueryFilter filter, long currentEndTime) {
        long prevTime;
        Collection times = CounterDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)currentEndTime);
        long[] xValues = filter.getTimesRequested();
        long queryStart = filter.getStart();
        long stateSystemStartTime = ss.getStartTime();
        if (!filter.isCumulative() && xValues.length > 1 && (prevTime = Long.max(stateSystemStartTime, 2L * queryStart - xValues[1])) <= currentEndTime) {
            times.add(prevTime);
        }
        return times;
    }

    private static double[] buildYValues(NavigableSet<ITmfStateInterval> countersIntervals, SelectedCounterQueryFilter filter) {
        Object value;
        long[] times = filter.getTimesRequested();
        boolean isCumulative = filter.isCumulative();
        double[] yValues = new double[times.length];
        long prevValue = 0L;
        if (!countersIntervals.isEmpty() && (value = ((ITmfStateInterval)countersIntervals.first()).getValue()) instanceof Number) {
            prevValue = ((Number)value).longValue();
        }
        int to = 0;
        for (ITmfStateInterval interval : countersIntervals) {
            long l;
            int from = Arrays.binarySearch(times, interval.getStartTime());
            from = from >= 0 ? from : -1 - from;
            Number value2 = (Number)interval.getValue();
            long l2 = l = value2 != null ? value2.longValue() : 0L;
            if (isCumulative) {
                to = Arrays.binarySearch(times, interval.getEndTime());
                to = to >= 0 ? to + 1 : -1 - to;
                Arrays.fill(yValues, from, to, (double)l);
            } else {
                yValues[from] = l - prevValue;
            }
            prevValue = l;
        }
        if (isCumulative) {
            Arrays.fill(yValues, to, yValues.length, (double)prevValue);
        }
        return yValues;
    }

    public String getTitle() {
        return TITLE;
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return true;
    }
}

