/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.views.contentoutline;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.sse.ui.views.contentoutline.ContentOutlineFilterProcessor;

public abstract class ContentOutlineConfiguration {
    ImageDescriptor COLLAPSE_D = EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/collapseall.gif");
    ImageDescriptor COLLAPSE_E = EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/collapseall.gif");
    private boolean fIsLinkWithEditor = false;
    private ILabelProvider fLabelProvider;
    private IContributionItem[] fMenuContributions = null;
    private IContributionItem[] fToolbarContributions = null;
    private final String OUTLINE_LINK_PREF = "outline-link-editor";
    private static final String OUTLINE_FILTER_PREF = "org.eclipse.wst.sse.ui.OutlinePage";
    ImageDescriptor SYNCED_D = EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/dlcl16/synced.gif");
    ImageDescriptor SYNCED_E = EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/elcl16/synced.gif");

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        PropertyChangeUpdateActionContributionItem toggleLinkItem = new PropertyChangeUpdateActionContributionItem(new ToggleLinkAction(this.getPreferenceStore(), "outline-link-editor"));
        IContributionItem[] items = new IContributionItem[]{toggleLinkItem};
        return items;
    }

    protected IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        ActionContributionItem collapseAllItem = new ActionContributionItem((IAction)new CollapseTreeAction(viewer));
        IContributionItem[] items = new IContributionItem[]{collapseAllItem};
        return items;
    }

    public abstract IContentProvider getContentProvider(TreeViewer var1);

    public KeyListener[] getKeyListeners(TreeViewer viewer) {
        return null;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new LabelProvider();
        }
        return this.fLabelProvider;
    }

    public final IContributionItem[] getMenuContributions(TreeViewer viewer) {
        if (this.fMenuContributions == null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            this.fMenuContributions = this.createMenuContributions(viewer);
        }
        return this.fMenuContributions;
    }

    public IMenuListener getMenuListener(TreeViewer viewer) {
        return null;
    }

    protected IPreferenceStore getPreferenceStore() {
        return SSEUIPlugin.getInstance().getPreferenceStore();
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        return selection;
    }

    public ILabelProvider getStatusLineLabelProvider(TreeViewer treeViewer) {
        return null;
    }

    public final IContributionItem[] getToolbarContributions(TreeViewer viewer) {
        if (this.fToolbarContributions == null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
            this.fToolbarContributions = this.createToolbarContributions(viewer);
        }
        return this.fToolbarContributions;
    }

    public TransferDragSourceListener[] getTransferDragSourceListeners(TreeViewer treeViewer) {
        return new TransferDragSourceListener[0];
    }

    public TransferDropTargetListener[] getTransferDropTargetListeners(TreeViewer treeViewer) {
        return new TransferDropTargetListener[0];
    }

    public boolean isLinkedWithEditor(TreeViewer treeViewer) {
        return this.fIsLinkWithEditor;
    }

    void setLinkWithEditor(boolean isLinkWithEditor) {
        this.fIsLinkWithEditor = isLinkWithEditor;
    }

    public void unconfigure(TreeViewer viewer) {
        int i;
        if (this.fToolbarContributions != null) {
            i = 0;
            while (i < this.fToolbarContributions.length) {
                if (this.fToolbarContributions[i] instanceof PropertyChangeUpdateActionContributionItem) {
                    ((PropertyChangeUpdateActionContributionItem)this.fToolbarContributions[i]).disconnect();
                }
                ++i;
            }
            this.fToolbarContributions = null;
        }
        if (this.fMenuContributions != null) {
            i = 0;
            while (i < this.fMenuContributions.length) {
                if (this.fMenuContributions[i] instanceof PropertyChangeUpdateActionContributionItem) {
                    ((PropertyChangeUpdateActionContributionItem)this.fMenuContributions[i]).disconnect();
                }
                ++i;
            }
            this.fMenuContributions = null;
        }
    }

    protected String getOutlineFilterTarget() {
        return OUTLINE_FILTER_PREF;
    }

    public ContentOutlineFilterProcessor getOutlineFilterProcessor(TreeViewer viewer) {
        return new ContentOutlineFilterProcessor(this.getPreferenceStore(), this.getOutlineFilterTarget(), (StructuredViewer)viewer);
    }

    private class CollapseTreeAction
    extends Action {
        private TreeViewer fTreeViewer;

        public CollapseTreeAction(TreeViewer viewer) {
            super(SSEUIMessages.ContentOutlineConfiguration_0, 1);
            this.fTreeViewer = null;
            this.setImageDescriptor(ContentOutlineConfiguration.this.COLLAPSE_E);
            this.setDisabledImageDescriptor(ContentOutlineConfiguration.this.COLLAPSE_D);
            this.setToolTipText(this.getText());
            this.fTreeViewer = viewer;
        }

        public void run() {
            super.run();
            this.fTreeViewer.collapseAll();
        }
    }

    private class ToggleLinkAction
    extends PropertyChangeUpdateAction {
        public ToggleLinkAction(IPreferenceStore store, String preference) {
            super(SSEUIMessages.ContentOutlineConfiguration_1, store, preference, true);
            this.setToolTipText(this.getText());
            this.setDisabledImageDescriptor(ContentOutlineConfiguration.this.SYNCED_D);
            this.setImageDescriptor(ContentOutlineConfiguration.this.SYNCED_E);
            this.update();
        }

        @Override
        public void update() {
            super.update();
            ContentOutlineConfiguration.this.setLinkWithEditor(this.isChecked());
        }
    }
}

