/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.viewers.xychart.BaseXYPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.tmf.core.presentation.IYAppearance;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ICheckboxTreeViewerListener;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfXYChartSettings;
import org.swtchart.Chart;

@Deprecated
public class TmfFilteredXYChartViewer
extends TmfCommonXAxisChartViewer
implements ICheckboxTreeViewerListener {
    private static final int DEFAULT_SERIES_WIDTH = 2;
    private @NonNull Collection<@NonNull Long> fSelectedIds = Collections.emptyList();
    private final String fId;
    private final Map<BaseXYPresentationProvider, Boolean> fUseDefaultStyleValues = new HashMap<BaseXYPresentationProvider, Boolean>();

    public TmfFilteredXYChartViewer(Composite parent, TmfXYChartSettings settings, String id) {
        super(parent, settings);
        Chart chart = this.getSwtChart();
        chart.getLegend().setVisible(false);
        this.fId = id;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void handleCheckStateChangedEvent(Collection<ITmfTreeViewerEntry> entries) {
        this.cancelUpdate();
        Iterable counterEntries = Iterables.filter(entries, TmfGenericTreeEntry.class);
        @NonNull HashSet selectedIds = Sets.newHashSet((Iterable)Iterables.transform((Iterable)counterEntries, e -> e.getModel().getId()));
        if (!selectedIds.containsAll(this.fSelectedIds)) {
            this.clearContent();
        }
        this.fSelectedIds = selectedIds;
        BaseXYPresentationProvider presProvider = this.getPresentationProvider2();
        for (ITmfTreeViewerEntry entry : entries) {
            TmfGenericTreeEntry genericEntry;
            TmfTreeDataModel model;
            OutputElementStyle style;
            if (!(entry instanceof TmfGenericTreeEntry) || (style = (model = (TmfTreeDataModel)(genericEntry = (TmfGenericTreeEntry)entry).getModel()).getStyle()) == null) continue;
            presProvider.setStyle(model.getId(), style);
        }
        this.updateContent();
    }

    @Override
    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        this.clearContent();
        this.fSelectedIds.clear();
    }

    @Override
    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        if (signal != null && signal.getTrace().equals(this.getTrace())) {
            this.fSelectedIds.clear();
        }
        this.fUseDefaultStyleValues.remove(this.getPresentationProvider2());
        super.traceClosed(signal);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @NonNull Map<String, Object> createQueryParameters(long start, long end, int nb) {
        @NonNull @NonNull Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(start, end, nb, this.fSelectedIds));
        Multimap<@NonNull Integer, @NonNull String> regexesMap = this.getRegexes();
        if (!regexesMap.isEmpty()) {
            parameters.put("regex_map_filters", regexesMap.asMap());
        }
        return parameters;
    }

    public @NonNull Collection<@NonNull Long> getSelected() {
        return this.fSelectedIds;
    }

    @Override
    public @NonNull IYAppearance getSeriesAppearance(@NonNull String seriesName) {
        return this.getPresentationProvider().getAppearance(seriesName, "line", 2);
    }

    @Override
    public @NonNull OutputElementStyle getSeriesStyle(@NonNull Long seriesId) {
        BaseXYPresentationProvider presentationProvider = this.getPresentationProvider2();
        return this.fUseDefaultStyleValues.getOrDefault(presentationProvider, true) != false ? presentationProvider.getSeriesStyle(seriesId, "line", 2) : presentationProvider.getSeriesStyle(seriesId);
    }

    @Override
    protected ITmfXYDataProvider initializeDataProvider(ITmfTrace trace) {
        ITmfTreeXYDataProvider dataProvider = (ITmfTreeXYDataProvider)DataProviderManager.getInstance().getDataProvider(trace, this.fId, ITmfTreeXYDataProvider.class);
        BaseXYPresentationProvider presentationProvider = this.getPresentationProvider2();
        this.fUseDefaultStyleValues.computeIfAbsent(presentationProvider, pp -> {
            if (dataProvider instanceof IOutputStyleProvider) {
                pp.addProvider(dataProvider);
                return false;
            }
            return true;
        });
        return dataProvider;
    }
}

