/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.event;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface ITmfEventField {
    public static final @NonNull String ROOT_FIELD_ID = ":root:";

    public @NonNull String getName();

    public Object getValue();

    public String getFormattedValue();

    public @NonNull Collection<@NonNull String> getFieldNames();

    public @NonNull Collection<? extends ITmfEventField> getFields();

    public ITmfEventField getField(String ... var1);

    default public <T> @Nullable T getFieldValue(@NonNull Class<T> type, String ... fieldName) {
        ITmfEventField field = this.getField(fieldName);
        if (field == null) {
            return null;
        }
        return field.getFieldValue(type);
    }

    default public <T> @Nullable T getFieldValue(@NonNull Class<T> type) {
        Object value = this.getValue();
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            Object ret = value;
            return (T)ret;
        }
        if (type.equals(String.class)) {
            String ret = String.valueOf(value);
            return (T)ret;
        }
        if (type.equals(Long.class)) {
            if (Number.class.isAssignableFrom(value.getClass())) {
                Long ret = ((Number)value).longValue();
                return (T)ret;
            }
            Long longVal = Longs.tryParse((String)String.valueOf(value));
            if (longVal != null) {
                Long ret = longVal;
                return (T)ret;
            }
            return null;
        }
        if (type.equals(Integer.class)) {
            if (Number.class.isAssignableFrom(value.getClass())) {
                Integer ret = ((Number)value).intValue();
                return (T)ret;
            }
            Integer intVal = Ints.tryParse((String)String.valueOf(value));
            if (intVal != null) {
                Integer ret = intVal;
                return (T)ret;
            }
            return null;
        }
        if (type.equals(Double.class)) {
            if (Number.class.isAssignableFrom(value.getClass())) {
                Double ret = ((Number)value).doubleValue();
                return (T)ret;
            }
            Double dblVal = Doubles.tryParse((String)String.valueOf(value));
            if (dblVal != null) {
                Double ret = dblVal;
                return (T)ret;
            }
            return null;
        }
        return null;
    }
}

