/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.di;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.internal.extensions.EventObjectSupplier;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

@Component(service={ExtendedObjectSupplier.class, EventHandler.class}, property={"dependency.injection.annotation=org.eclipse.e4.ui.di.UIEventTopic", "event.topics=org/eclipse/e4/core/contexts/IEclipseContext/DISPOSE"})
public class UIEventObjectSupplier
extends EventObjectSupplier {
    @Inject
    @Optional
    protected UISynchronize uiSync;
    @Inject
    @Optional
    protected Logger logger;

    @Reference
    public void setEventAdmin(EventAdmin eventAdmin) {
        super.setEventAdmin(eventAdmin);
    }

    protected EventHandler makeHandler(String topic, IRequestor requestor) {
        return new UIEventHandler(topic, requestor);
    }

    protected String getTopic(IObjectDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        UIEventTopic qualifier = (UIEventTopic)descriptor.getQualifier(UIEventTopic.class);
        return qualifier.value();
    }

    class UIEventHandler
    implements EventHandler {
        protected final IRequestor requestor;
        private final String topic;

        public UIEventHandler(String topic, IRequestor requestor) {
            this.topic = topic;
            this.requestor = requestor;
        }

        public void handleEvent(Event event) {
            if (!this.requestor.isValid()) {
                UIEventObjectSupplier.this.unsubscribe(this.requestor);
                return;
            }
            UIEventObjectSupplier.this.addCurrentEvent(this.topic, event);
            this.requestor.resolveArguments(false);
            UIEventObjectSupplier.this.removeCurrentEvent(this.topic);
            if (UIEventObjectSupplier.this.uiSync == null) {
                if (UIEventObjectSupplier.this.logger != null) {
                    UIEventObjectSupplier.this.logger.log(Level.WARNING, "No realm found to process UI event " + event);
                }
                return;
            }
            UIEventObjectSupplier.this.uiSync.syncExec(new Runnable(){

                @Override
                public void run() {
                    UIEventHandler.this.requestor.execute();
                }
            });
        }
    }
}

