/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model;

import java.io.StringWriter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTraceGroupElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RemoteImportProfilesWriter {
    private RemoteImportProfilesWriter() {
    }

    public static String writeProfilesToXML(TracePackageElement[] profiles) throws ParserConfigurationException, TransformerException {
        Document doc = XmlUtils.newSafeDocumentBuilderFactory().newDocumentBuilder().newDocument();
        Element profilesElement = doc.createElement("profiles");
        doc.appendChild(profilesElement);
        Element versionElement = doc.createElement("version");
        versionElement.setTextContent("0.1");
        profilesElement.appendChild(versionElement);
        TracePackageElement[] tracePackageElementArray = profiles;
        int n = profiles.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement profile = tracePackageElementArray[n2];
            if (profile instanceof RemoteImportProfileElement) {
                RemoteImportProfilesWriter.exportProfile(profilesElement, (RemoteImportProfileElement)profile);
            }
            ++n2;
        }
        Transformer transformer = XmlUtils.newSecureTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        StringWriter buffer = new StringWriter();
        StreamResult result = new StreamResult(buffer);
        transformer.transform(source, result);
        String content = buffer.getBuffer().toString();
        return content;
    }

    private static void exportProfile(Node profilesNode, RemoteImportProfileElement profile) {
        Element profileElement = profilesNode.getOwnerDocument().createElement("profile");
        profileElement.setAttribute("name", profile.getProfileName());
        TracePackageElement[] tracePackageElementArray = profile.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement connectionNode = tracePackageElementArray[n2];
            if (connectionNode instanceof RemoteImportConnectionNodeElement) {
                RemoteImportProfilesWriter.exportConnectionNode(profileElement, (RemoteImportConnectionNodeElement)connectionNode);
            }
            ++n2;
        }
        profilesNode.appendChild(profileElement);
    }

    private static void exportConnectionNode(Node profileNode, RemoteImportConnectionNodeElement connectionNode) {
        Element nodeElement = profileNode.getOwnerDocument().createElement("node");
        nodeElement.setAttribute("name", connectionNode.getName());
        profileNode.appendChild(nodeElement);
        Element uriElement = profileNode.getOwnerDocument().createElement("uri");
        uriElement.setTextContent(connectionNode.getURI());
        nodeElement.appendChild(uriElement);
        TracePackageElement[] tracePackageElementArray = connectionNode.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement traceGroup = tracePackageElementArray[n2];
            if (traceGroup instanceof RemoteImportTraceGroupElement) {
                RemoteImportProfilesWriter.exportTraceGroup(nodeElement, (RemoteImportTraceGroupElement)traceGroup);
            }
            ++n2;
        }
    }

    private static void exportTraceGroup(Node nodeNode, RemoteImportTraceGroupElement traceGroup) {
        Element traceGroupElement = nodeNode.getOwnerDocument().createElement("traceGroup");
        traceGroupElement.setAttribute("root", traceGroup.getRootImportPath());
        traceGroupElement.setAttribute("recursive", Boolean.toString(traceGroup.isRecursive()));
        TracePackageElement[] tracePackageElementArray = traceGroup.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement trace = tracePackageElementArray[n2];
            if (trace instanceof TracePackageTraceElement) {
                RemoteImportProfilesWriter.exportTrace(traceGroupElement, (TracePackageTraceElement)trace);
            }
            ++n2;
        }
        nodeNode.appendChild(traceGroupElement);
    }

    private static void exportTrace(Node traceGroupNode, TracePackageTraceElement trace) {
        Element traceElement = traceGroupNode.getOwnerDocument().createElement("trace");
        traceElement.setAttribute("name", trace.getImportName());
        traceElement.setAttribute("type", trace.getTraceType());
        TracePackageElement[] tracePackageElementArray = trace.getChildren();
        int n = tracePackageElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            TracePackageElement files = tracePackageElementArray[n2];
            if (files instanceof TracePackageFilesElement) {
                RemoteImportProfilesWriter.exportTraceFiles(traceElement, (TracePackageFilesElement)files);
                break;
            }
            ++n2;
        }
        traceGroupNode.appendChild(traceElement);
    }

    private static void exportTraceFiles(Node traceNode, TracePackageFilesElement files) {
        Element fileElement = traceNode.getOwnerDocument().createElement("file");
        fileElement.setAttribute("name", files.getFileName());
        traceNode.appendChild(fileElement);
    }
}

