/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.lang.constant.Constable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation2;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStateUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;

public class InternalTreeModelViewer
extends TreeViewer
implements IInternalTreeModelViewer,
ITreeModelViewer {
    private final IPresentationContext fContext;
    private IColumnPresentation fColumnPresentation = null;
    private final Map<String, String[]> fVisibleColumns = new HashMap<String, String[]>();
    private final Map<Object, Integer> fColumnSizes = new HashMap<Object, Integer>();
    private final Map<String, int[]> fColumnOrder = new HashMap<String, int[]>();
    private final Map<String, Boolean> fShowColumns = new HashMap<String, Boolean>();
    private static final String TREE_PATH_KEY = "TREE_PATH_KEY";
    private static final String COLUMN_SIZES = "COLUMN_SIZES";
    private static final String COLUMN_ORDER = "COLUMN_ORDER";
    private static final String VISIBLE_COLUMNS = "VISIBLE_COLUMNS";
    private static final String SHOW_COLUMNS = "SHOW_COLUMNS";
    private static final String SIZE = "SIZE";
    private static final String COLUMN = "COLUMN";
    private boolean fInserting = false;
    private boolean fNotifyUnmap = true;
    private final ColumnListener fListener = new ColumnListener();
    private final CellModifierProxy fCellModifier;
    protected static final String[] STATE_PROPERTIES = new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"};
    static String PREV_LABEL_KEY = "PREV_LABEL_KEY";
    static String PREV_IMAGE_KEY = "PREV_IMAGE_KEY";
    static String PREV_FONT_KEY = "PREV_FONT_KEY";
    static String PREV_FOREGROUND_KEY = "PREV_FOREGROUND_KEY";
    static String PREV_BACKGROUND_KEY = "PREV_BACKGROUND_KEY";
    static String PREV_CHECKED_KEY = "PREV_CHECKED_KEY";
    static String PREV_GRAYED_KEY = "PREV_GRAYED_KEY";

    public InternalTreeModelViewer(Composite parent, int style, IPresentationContext context) {
        super(parent, style);
        if ((style & 0x10000000) == 0) {
            throw new IllegalArgumentException("style must include SWT.VIRTUAL");
        }
        this.setUseHashlookup(true);
        this.fCellModifier = new CellModifierProxy();
        this.fContext = context;
        this.setContentProvider((IContentProvider)this.createContentProvider());
        this.setLabelProvider(this.createLabelProvider());
        if ((style & 8) != 0) {
            ((ITreeModelContentProvider)this.getContentProvider()).setModelDeltaMask(-120586241);
        }
        if ((style & 0x20) != 0) {
            context.setProperty("org.eclipse.debug.ui.check", Boolean.TRUE);
        }
    }

    protected ITreeModelContentProvider createContentProvider() {
        return new TreeModelContentProvider();
    }

    protected ITreeModelLabelProvider createLabelProvider() {
        return new TreeModelLabelProvider(this);
    }

    protected void hookControl(Control control) {
        Tree treeControl = (Tree)control;
        treeControl.addListener(36, event -> {
            TreeItem item = (TreeItem)event.item;
            this.preserveItem(item);
        });
        super.hookControl(control);
    }

    private void preserveItem(TreeItem item) {
        Boolean grayed;
        Boolean checked;
        Object[] backgrounds;
        Object[] foregrounds;
        Object[] fonts;
        Object[] images;
        Object[] labels = (Object[])item.getData(PREV_LABEL_KEY);
        if (labels != null) {
            int i = 0;
            while (i < labels.length) {
                if (labels[i] != null) {
                    item.setText(i, (String)labels[i]);
                }
                ++i;
            }
        }
        if ((images = (Object[])item.getData(PREV_IMAGE_KEY)) != null) {
            int i = 0;
            while (i < images.length) {
                item.setImage(i, (Image)images[i]);
                ++i;
            }
        }
        if ((fonts = (Object[])item.getData(PREV_FONT_KEY)) != null) {
            int i = 0;
            while (i < fonts.length) {
                item.setFont(i, (Font)fonts[i]);
                ++i;
            }
        }
        if ((foregrounds = (Object[])item.getData(PREV_FOREGROUND_KEY)) != null) {
            int i = 0;
            while (i < foregrounds.length) {
                item.setForeground(i, (Color)foregrounds[i]);
                ++i;
            }
        }
        if ((backgrounds = (Object[])item.getData(PREV_BACKGROUND_KEY)) != null) {
            int i = 0;
            while (i < backgrounds.length) {
                item.setBackground(i, (Color)backgrounds[i]);
                ++i;
            }
        }
        if ((checked = (Boolean)item.getData(PREV_CHECKED_KEY)) != null) {
            item.setChecked(checked.booleanValue());
        }
        if ((grayed = (Boolean)item.getData(PREV_GRAYED_KEY)) != null) {
            item.setGrayed(grayed.booleanValue());
        }
    }

    protected void handleInvalidSelection(ISelection selection, ISelection newSelection) {
        IModelSelectionPolicy selectionPolicy = ViewerAdapterService.getSelectionPolicy(selection, this.getPresentationContext());
        if (selectionPolicy != null) {
            while (!selection.equals(newSelection)) {
                ISelection temp = newSelection;
                if ((selection = selectionPolicy.replaceInvalidSelection(selection, newSelection)) == null) {
                    selection = TreeSelection.EMPTY;
                }
                if (temp.equals(selection)) break;
                this.setSelectionToWidget(selection, false);
                newSelection = this.getSelection();
            }
        }
        super.handleInvalidSelection(selection, newSelection);
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fColumnPresentation != null) {
            this.fColumnPresentation.dispose();
        }
        this.fCellModifier.clear();
        super.handleDispose(event);
    }

    @Override
    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    protected void unmapElement(Object element, Widget widget) {
        if (this.fNotifyUnmap) {
            ((ITreeModelContentProvider)this.getContentProvider()).unmapPath((TreePath)widget.getData(TREE_PATH_KEY));
        }
        super.unmapElement(element, widget);
    }

    protected void associate(Object element, Item item) {
        Object data = item.getData();
        if (data != null && data != element && this.equals(data, element)) {
            try {
                this.fNotifyUnmap = false;
                super.associate(element, item);
            }
            finally {
                this.fNotifyUnmap = true;
            }
        } else {
            super.associate(element, item);
        }
    }

    protected void mapElement(Object element, Widget widget) {
        super.mapElement(element, widget);
        if (widget instanceof Item) {
            widget.setData(TREE_PATH_KEY, (Object)this.getTreePathFromItem((Item)widget));
        } else {
            widget.setData(TREE_PATH_KEY, (Object)TreeModelContentProvider.EMPTY_TREE_PATH);
        }
    }

    @Override
    public void insert(Object parentElementOrTreePath, Object element, int position) {
        try {
            this.fInserting = true;
            super.insert(parentElementOrTreePath, element, position);
        }
        finally {
            this.fInserting = false;
        }
    }

    protected boolean hasFilters() {
        if (this.fInserting) {
            return false;
        }
        return super.hasFilters();
    }

    protected void unmapAllElements() {
        if (this.getControl().isDisposed()) {
            this.unmapAllElements();
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.fCellModifier.clear();
        super.unmapAllElements();
        ((ITreeModelContentProvider)this.getContentProvider()).postInputChanged(this, oldInput, input);
        super.inputChanged(input, oldInput);
        this.resetColumns(input);
    }

    protected void resetColumns(Object input) {
        if (input != null) {
            IColumnPresentationFactory factory = ViewerAdapterService.getColumnPresentationFactory(input);
            PresentationContext context = (PresentationContext)this.getPresentationContext();
            String type = null;
            if (factory != null) {
                type = factory.getColumnPresentationId(context, input);
            }
            if (type != null && factory != null) {
                if (this.fColumnPresentation != null && !this.fColumnPresentation.getId().equals(type)) {
                    this.fColumnPresentation.dispose();
                    this.fColumnPresentation = null;
                }
                if (this.fColumnPresentation == null) {
                    this.fColumnPresentation = factory.createColumnPresentation(context, input);
                    if (this.fColumnPresentation != null) {
                        this.fColumnPresentation.init(context);
                        this.configureColumns();
                    }
                }
            } else if (this.fColumnPresentation != null) {
                this.fColumnPresentation.dispose();
                this.fColumnPresentation = null;
                this.configureColumns();
            }
        }
    }

    protected void configureColumns() {
        if (this.fColumnPresentation != null) {
            IColumnPresentation build = null;
            if (this.isShowColumns(this.fColumnPresentation.getId())) {
                build = this.fColumnPresentation;
            }
            this.buildColumns(build);
        } else {
            this.buildColumns(null);
        }
    }

    public void setShowColumns(boolean show) {
        if (show) {
            if (!this.isShowColumns()) {
                this.fShowColumns.remove(this.fColumnPresentation.getId());
            }
        } else if (this.isShowColumns()) {
            this.fShowColumns.put(this.fColumnPresentation.getId(), Boolean.FALSE);
        }
        this.refreshColumns();
    }

    public void resetColumnSizes(String[] columnIds) {
        int i = 0;
        while (i < columnIds.length) {
            this.fColumnSizes.remove(columnIds[i]);
            ++i;
        }
    }

    public void setVisibleColumns(String[] ids) {
        IColumnPresentation presentation;
        if (ids != null && ids.length == 0) {
            ids = null;
        }
        if ((presentation = this.getColumnPresentation()) != null) {
            this.fColumnOrder.remove(presentation.getId());
            this.fVisibleColumns.remove(presentation.getId());
            if (ids != null) {
                String[] columns = presentation.getInitialColumns();
                if (columns.length == ids.length) {
                    int i = 0;
                    while (i < columns.length) {
                        if (!ids[i].equals(columns[i])) {
                            this.fVisibleColumns.put(presentation.getId(), ids);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.fVisibleColumns.put(presentation.getId(), ids);
                }
            }
            PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
            presentationContext.setColumns(this.getVisibleColumns());
            this.refreshColumns();
        }
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        ITreeModelContentProvider contentProvider = (ITreeModelContentProvider)this.getContentProvider();
        if (element == null) {
            this.internalRefresh((Widget)this.getControl(), this.getRoot(), true, updateLabels);
            contentProvider.preserveState(TreePath.EMPTY);
        } else {
            Widget[] items = this.findItems(element);
            if (items.length != 0) {
                int i = 0;
                while (i < items.length) {
                    if (items[i] instanceof TreeItem) {
                        contentProvider.preserveState(this.getTreePathFromItem((Item)((TreeItem)items[i])));
                    } else {
                        contentProvider.preserveState(TreePath.EMPTY);
                    }
                    ++i;
                }
            }
        }
        super.internalRefresh(element, updateLabels);
    }

    protected void refreshColumns() {
        this.configureColumns();
        this.refresh();
    }

    public boolean isShowColumns() {
        if (this.fColumnPresentation != null) {
            return this.isShowColumns(this.fColumnPresentation.getId());
        }
        return false;
    }

    public boolean canToggleColumns() {
        return this.fColumnPresentation != null && this.fColumnPresentation.isOptional();
    }

    protected boolean isShowColumns(String columnPresentationId) {
        Boolean bool = this.fShowColumns.get(columnPresentationId);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    protected void buildColumns(IColumnPresentation presentation) {
        int treeWidgetWidth;
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        String[] visibleColumnIds = this.getVisibleColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].removeControlListener((ControlListener)this.fListener);
            ++i;
        }
        i = 0;
        while (i < columns.length) {
            columns[i].dispose();
            ++i;
        }
        PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
        if (presentation != null) {
            int i2 = 0;
            while (i2 < visibleColumnIds.length) {
                String id = visibleColumnIds[i2];
                String header = presentation.getHeader(id);
                TreeColumn column = new TreeColumn(tree, 16384, i2);
                column.setMoveable(true);
                column.setText(header);
                column.setWidth(1);
                ImageDescriptor image = presentation.getImageDescriptor(id);
                if (image != null) {
                    column.setImage(((ITreeModelLabelProvider)this.getLabelProvider()).getImage(image));
                }
                column.setData((Object)id);
                ++i2;
            }
            int[] order = this.fColumnOrder.get(presentation.getId());
            if (order != null) {
                tree.setColumnOrder(order);
            }
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            presentationContext.setColumns(visibleColumnIds);
            this.setColumnProperties(visibleColumnIds);
            this.setCellModifier(this.fCellModifier);
        } else {
            tree.setHeaderVisible(false);
            tree.setLinesVisible(false);
            presentationContext.setColumns(null);
            this.setCellModifier(null);
            this.setColumnProperties(null);
        }
        int avg = treeWidgetWidth = tree.getSize().x;
        if (visibleColumnIds != null) {
            avg /= visibleColumnIds.length;
        }
        if (avg == 0) {
            tree.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    Tree tree2 = InternalTreeModelViewer.this.getTree();
                    String[] visibleColumns = InternalTreeModelViewer.this.getVisibleColumns();
                    if (visibleColumns != null) {
                        int treeWidgetWidth1 = tree2.getSize().x;
                        int avg1 = treeWidgetWidth1 / visibleColumns.length;
                        InternalTreeModelViewer.this.initColumns(avg1, treeWidgetWidth1, visibleColumns);
                    }
                    tree2.removePaintListener((PaintListener)this);
                }
            });
        } else {
            this.initColumns(avg, treeWidgetWidth, visibleColumnIds);
        }
    }

    private void initColumns(int widthHint, int treeWidgetWidth, String[] visibleColumnIds) {
        TreeColumn[] columns = this.getTree().getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            Object colData = treeColumn.getData();
            String columnId = colData instanceof String ? (String)colData : null;
            Integer width = this.fColumnSizes.get(colData);
            if (width == null) {
                int ans = this.getInitialColumnWidth(columnId, treeWidgetWidth, visibleColumnIds);
                if (ans == -1) {
                    treeColumn.setWidth(widthHint);
                } else {
                    treeColumn.setWidth(ans);
                }
            } else {
                treeColumn.setWidth(width.intValue());
            }
            treeColumn.addControlListener((ControlListener)this.fListener);
            ++i;
        }
    }

    public IColumnPresentation getColumnPresentation() {
        return this.fColumnPresentation;
    }

    @Override
    public String[] getVisibleColumns() {
        IColumnPresentation presentation;
        if (this.isShowColumns() && (presentation = this.getColumnPresentation()) != null) {
            String[] columns = this.fVisibleColumns.get(presentation.getId());
            if (columns == null) {
                return presentation.getInitialColumns();
            }
            String[] available = presentation.getAvailableColumns();
            int i = 0;
            while (i < columns.length) {
                boolean columnAvailable = false;
                int j = 0;
                while (j < available.length) {
                    if (columns[i].equals(available[j])) {
                        columnAvailable = true;
                    }
                    ++j;
                }
                if (!columnAvailable || presentation.getHeader(columns[i]) == null) {
                    this.fVisibleColumns.remove(presentation.getId());
                    this.fColumnOrder.remove(presentation.getId());
                    this.fColumnSizes.remove(presentation.getId());
                    return presentation.getInitialColumns();
                }
                ++i;
            }
            return columns;
        }
        return null;
    }

    public int getInitialColumnWidth(String columnId, int treeWidgetWidth, String[] visibleColumnIds) {
        IColumnPresentation presentation;
        if (this.isShowColumns() && (presentation = this.getColumnPresentation()) instanceof IColumnPresentation2) {
            int ans = ((IColumnPresentation2)presentation).getInitialColumnWidth(columnId, treeWidgetWidth, visibleColumnIds);
            return ans;
        }
        return -1;
    }

    protected void persistColumnSizes() {
        Tree tree = this.getTree();
        TreeColumn[] columns = tree.getColumns();
        int i = 0;
        while (i < columns.length) {
            TreeColumn treeColumn = columns[i];
            Object id = treeColumn.getData();
            this.fColumnSizes.put(id, treeColumn.getWidth());
            ++i;
        }
    }

    protected void persistColumnOrder() {
        IColumnPresentation presentation = this.getColumnPresentation();
        if (presentation != null) {
            Tree tree = this.getTree();
            int[] order = tree.getColumnOrder();
            if (order.length > 0) {
                int i = 0;
                while (i < order.length) {
                    if (i != order[i]) {
                        this.fColumnOrder.put(presentation.getId(), order);
                        return;
                    }
                    ++i;
                }
            }
            this.fColumnOrder.remove(presentation.getId());
        }
    }

    public void saveState(IMemento memento) {
        IPresentationContext iPresentationContext;
        int i;
        String id;
        IMemento sizes;
        if (!this.fColumnSizes.isEmpty()) {
            for (Map.Entry<Object, Constable> entry : this.fColumnSizes.entrySet()) {
                sizes = memento.createChild(COLUMN_SIZES, (String)entry.getKey());
                sizes.putInteger(SIZE, ((Integer)entry.getValue()).intValue());
            }
        }
        if (!this.fShowColumns.isEmpty()) {
            for (Map.Entry<Object, Constable> entry : this.fShowColumns.entrySet()) {
                sizes = memento.createChild(SHOW_COLUMNS, (String)entry.getKey());
                sizes.putString(SHOW_COLUMNS, ((Boolean)entry.getValue()).toString());
            }
        }
        if (!this.fVisibleColumns.isEmpty()) {
            for (Map.Entry<Object, Constable> entry : this.fVisibleColumns.entrySet()) {
                id = (String)entry.getKey();
                IMemento visible = memento.createChild(VISIBLE_COLUMNS, id);
                String[] columns = (String[])entry.getValue();
                visible.putInteger(SIZE, columns.length);
                i = 0;
                while (i < columns.length) {
                    visible.putString(COLUMN + Integer.toString(i), columns[i]);
                    ++i;
                }
            }
        }
        if (!this.fColumnOrder.isEmpty()) {
            for (Map.Entry<Object, Constable> entry : this.fColumnOrder.entrySet()) {
                id = (String)entry.getKey();
                IMemento orderMemento = memento.createChild(COLUMN_ORDER, id);
                int[] order = (int[])entry.getValue();
                orderMemento.putInteger(SIZE, order.length);
                i = 0;
                while (i < order.length) {
                    orderMemento.putInteger(COLUMN + Integer.toString(i), order[i]);
                    ++i;
                }
            }
        }
        if ((iPresentationContext = this.getPresentationContext()) instanceof PresentationContext) {
            PresentationContext pc = (PresentationContext)iPresentationContext;
            pc.saveProperites(memento);
        }
    }

    public void initState(IMemento memento) {
        int j;
        int length;
        Integer integer;
        String id;
        IMemento child;
        IMemento[] mementos = memento.getChildren(COLUMN_SIZES);
        int i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Integer size = child.getInteger(SIZE);
            if (size != null) {
                this.fColumnSizes.put(id, size);
            }
            ++i;
        }
        mementos = memento.getChildren(SHOW_COLUMNS);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            Boolean bool = Boolean.valueOf(child.getString(SHOW_COLUMNS));
            if (!bool.booleanValue()) {
                this.fShowColumns.put(id, bool);
            }
            ++i;
        }
        mementos = memento.getChildren(VISIBLE_COLUMNS);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            integer = child.getInteger(SIZE);
            if (integer != null) {
                length = integer;
                String[] columns = new String[length];
                j = 0;
                while (j < length) {
                    columns[j] = child.getString(COLUMN + Integer.toString(j));
                    ++j;
                }
                this.fVisibleColumns.put(id, columns);
            }
            ++i;
        }
        mementos = memento.getChildren(COLUMN_ORDER);
        i = 0;
        while (i < mementos.length) {
            child = mementos[i];
            id = child.getID();
            integer = child.getInteger(SIZE);
            if (integer != null) {
                length = integer;
                int[] order = new int[length];
                j = 0;
                while (j < length) {
                    order[j] = child.getInteger(COLUMN + Integer.toString(j));
                    ++j;
                }
                this.fColumnOrder.put(id, order);
            }
            ++i;
        }
        IPresentationContext context = this.getPresentationContext();
        if (context instanceof PresentationContext) {
            PresentationContext pc = (PresentationContext)context;
            pc.initProperties(memento);
        }
    }

    @Override
    public boolean overrideSelection(ISelection current, ISelection candidate) {
        IModelSelectionPolicy selectionPolicy = ViewerAdapterService.getSelectionPolicy(current, this.getPresentationContext());
        if (selectionPolicy == null) {
            return true;
        }
        if (selectionPolicy.contains(candidate, this.getPresentationContext())) {
            return selectionPolicy.overrides(current, candidate, this.getPresentationContext());
        }
        return !selectionPolicy.isSticky(current, this.getPresentationContext());
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (!this.overrideSelection(this.getSelection(), selection)) {
            return;
        }
        super.setSelection(selection, reveal);
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal, boolean force) {
        this.trySelection(selection, reveal, force);
    }

    @Override
    public boolean trySelection(ISelection selection, boolean reveal, boolean force) {
        if (force || this.overrideSelection(this.getSelection(), selection)) {
            super.setSelection(selection, reveal);
            return true;
        }
        return false;
    }

    @Override
    public void addViewerUpdateListener(IViewerUpdateListener listener) {
        ((ITreeModelContentProvider)this.getContentProvider()).addViewerUpdateListener(listener);
    }

    @Override
    public void removeViewerUpdateListener(IViewerUpdateListener listener) {
        ITreeModelContentProvider cp = (ITreeModelContentProvider)this.getContentProvider();
        if (cp != null) {
            cp.removeViewerUpdateListener(listener);
        }
    }

    @Override
    public void addModelChangedListener(IModelChangedListener listener) {
        ((ITreeModelContentProvider)this.getContentProvider()).addModelChangedListener(listener);
    }

    @Override
    public void removeModelChangedListener(IModelChangedListener listener) {
        ITreeModelContentProvider cp = (ITreeModelContentProvider)this.getContentProvider();
        if (cp != null) {
            cp.removeModelChangedListener(listener);
        }
    }

    @Override
    public void addStateUpdateListener(IStateUpdateListener listener) {
        ((ITreeModelContentProvider)this.getContentProvider()).addStateUpdateListener(listener);
    }

    @Override
    public void removeStateUpdateListener(IStateUpdateListener listener) {
        ITreeModelContentProvider cp = (ITreeModelContentProvider)this.getContentProvider();
        if (cp != null) {
            cp.removeStateUpdateListener(listener);
        }
    }

    protected void doUpdateItem(Item item, Object element) {
        if (!(item instanceof TreeItem)) {
            return;
        }
        TreeItem treeItem = (TreeItem)item;
        if (treeItem.isDisposed()) {
            this.unmapElement(element, (Widget)treeItem);
            return;
        }
        if (!((ITreeModelLabelProvider)this.getLabelProvider()).update(this.getTreePathFromItem(item)) && element instanceof String) {
            item.setData(PREV_LABEL_KEY, (Object)new String[]{(String)element});
        }
        if (item.isDisposed()) {
            this.unmapElement(element, (Widget)item);
        }
    }

    @Override
    public void addLabelUpdateListener(ILabelUpdateListener listener) {
        ((ITreeModelLabelProvider)this.getLabelProvider()).addLabelUpdateListener(listener);
    }

    @Override
    public void removeLabelUpdateListener(ILabelUpdateListener listener) {
        if (!this.getControl().isDisposed()) {
            ((ITreeModelLabelProvider)this.getLabelProvider()).removeLabelUpdateListener(listener);
        }
    }

    public Widget findItem(TreePath path) {
        if (path.getSegmentCount() == 0) {
            return this.getTree();
        }
        Widget[] items = super.findItems(path.getLastSegment());
        if (items.length == 1) {
            return items[0];
        }
        int i = 0;
        while (i < items.length) {
            if (this.getTreePathFromItem((Item)items[i]).equals((Object)path)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public Item[] getChildren(Widget widget) {
        return super.getChildren(widget);
    }

    protected TreePath getTreePathFromItem(Item item) {
        return super.getTreePathFromItem(item);
    }

    protected void internalRefreshStruct(Widget widget, Object element, boolean updateLabels) {
        if (widget instanceof Tree) {
            ((Tree)widget).clearAll(true);
        } else if (widget instanceof TreeItem) {
            ((TreeItem)widget).clearAll(true);
        }
        int index = 0;
        TreeItem parent = null;
        if (widget instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)widget;
            parent = treeItem.getParentItem();
            if (parent == null) {
                parent = treeItem.getParent();
            }
            index = parent instanceof Tree ? ((Tree)parent).indexOf(treeItem) : parent.indexOf(treeItem);
        }
        this.virtualRefreshExpandedItems((Widget)parent, widget, element, index);
    }

    private void virtualRefreshExpandedItems(Widget parent, Widget widget, Object element, int index) {
        if (widget instanceof Tree) {
            if (element == null) {
                ((Tree)widget).setItemCount(0);
                return;
            }
            this.virtualLazyUpdateChildCount(widget, this.getChildren(widget).length);
        } else if (((TreeItem)widget).getExpanded()) {
            this.preserveItem((TreeItem)widget);
            this.virtualLazyUpdateWidget(parent, index);
        } else {
            return;
        }
        Item[] items = this.getChildren(widget);
        int i = 0;
        while (i < items.length) {
            Item item = items[i];
            Object data = item.getData();
            this.virtualRefreshExpandedItems(widget, (Widget)item, data, i);
            ++i;
        }
    }

    private void virtualLazyUpdateChildCount(Widget widget, int currentChildCount) {
        TreePath treePath = widget instanceof Item ? this.getTreePathFromItem((Item)widget) : TreePath.EMPTY;
        ((ILazyTreePathContentProvider)this.getContentProvider()).updateChildCount(treePath, currentChildCount);
    }

    private void virtualLazyUpdateWidget(Widget widget, int index) {
        TreePath treePath;
        if (widget instanceof Item) {
            if (widget.getData() == null) {
                return;
            }
            treePath = this.getTreePathFromItem((Item)widget);
        } else {
            treePath = TreePath.EMPTY;
        }
        ((ILazyTreePathContentProvider)this.getContentProvider()).updateElement(treePath, index);
    }

    protected void createChildren(Widget widget) {
        Object element = widget.getData();
        if (element == null && widget instanceof TreeItem) {
            this.virtualMaterializeItem((TreeItem)widget);
            element = widget.getData();
        }
        if (element == null) {
            return;
        }
        Item[] children = this.getChildren(widget);
        if (children.length == 1 && children[0].getData() == null) {
            this.virtualLazyUpdateChildCount(widget, children.length);
            children = this.getChildren(widget);
        }
    }

    private void virtualMaterializeItem(TreeItem treeItem) {
        Object parentElement;
        if (treeItem.getData() != null) {
            return;
        }
        TreeItem parent = treeItem.getParentItem();
        if (parent == null) {
            parent = treeItem.getParent();
        }
        if ((parentElement = parent.getData()) != null) {
            int index = parent instanceof Tree ? ((Tree)parent).indexOf(treeItem) : parent.indexOf(treeItem);
            this.virtualLazyUpdateWidget((Widget)parent, index);
        }
    }

    @Override
    public void autoExpand(TreePath elementPath) {
        int level = this.getAutoExpandLevel();
        if (!(level <= 0 && level != -1 || level != -1 && level < elementPath.getSegmentCount())) {
            this.expandToLevel(elementPath, 1);
        }
    }

    @Override
    public int findElementIndex(TreePath parentPath, Object element) {
        Widget parentItem = this.findItem(parentPath);
        if (parentItem != null) {
            Item[] children = this.getChildren(parentItem);
            int i = 0;
            while (i < children.length) {
                Item item = children[i];
                Object data = item.getData();
                if (element != null && element.equals(data) || element == null && data == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    @Override
    public boolean getElementChildrenRealized(TreePath parentPath) {
        Widget parentItem = this.findItem(parentPath);
        if (parentItem != null) {
            Item[] children = this.getChildren(parentItem);
            int i = 0;
            while (i < children.length) {
                if (children[i].getData() == null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public Display getDisplay() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            return control.getDisplay();
        }
        return null;
    }

    @Override
    public void update(Object element) {
        this.update(element, STATE_PROPERTIES);
    }

    @Override
    public void setElementData(TreePath path, int numColumns, String[] labels, ImageDescriptor[] imageDescriptors, FontData[] fontDatas, RGB[] _foregrounds, RGB[] _backgrounds) {
        Widget widget = this.findItem(path);
        String[] columnIds = this.getVisibleColumns();
        if (widget != null && widget instanceof TreeItem && !widget.isDisposed()) {
            int i;
            TreeItem item = (TreeItem)widget;
            int i2 = 0;
            while (i2 < numColumns) {
                item.setText(i2, labels[i2] == null ? "" : labels[i2]);
                ++i2;
            }
            item.setData(PREV_LABEL_KEY, (Object)labels);
            if (imageDescriptors == null) {
                i2 = 0;
                while (i2 < numColumns) {
                    item.setImage(i2, null);
                    ++i2;
                }
                item.setData(PREV_IMAGE_KEY, null);
            } else {
                Image[] images = new Image[imageDescriptors.length];
                i = 0;
                while (i < imageDescriptors.length) {
                    images[i] = ((ITreeModelLabelProvider)this.getLabelProvider()).getImage(imageDescriptors[i]);
                    ++i;
                }
                if (columnIds == null) {
                    item.setImage(images[0]);
                } else {
                    item.setImage(images);
                }
                item.setData(PREV_IMAGE_KEY, (Object)images);
            }
            if (_foregrounds == null) {
                i = 0;
                while (i < numColumns) {
                    item.setForeground(i, null);
                    ++i;
                }
                item.setData(PREV_FOREGROUND_KEY, null);
            } else {
                Color[] foregrounds = new Color[_foregrounds.length];
                i = 0;
                while (i < foregrounds.length) {
                    foregrounds[i] = ((ITreeModelLabelProvider)this.getLabelProvider()).getColor(_foregrounds[i]);
                    ++i;
                }
                if (columnIds == null) {
                    item.setForeground(0, foregrounds[0]);
                } else {
                    i = 0;
                    while (i < foregrounds.length) {
                        item.setForeground(i, foregrounds[i]);
                        ++i;
                    }
                }
                item.setData(PREV_FOREGROUND_KEY, (Object)foregrounds);
            }
            if (_backgrounds == null) {
                i = 0;
                while (i < numColumns) {
                    item.setBackground(i, null);
                    ++i;
                }
                item.setData(PREV_BACKGROUND_KEY, null);
            } else {
                Color[] backgrounds = new Color[_backgrounds.length];
                i = 0;
                while (i < backgrounds.length) {
                    backgrounds[i] = ((ITreeModelLabelProvider)this.getLabelProvider()).getColor(_backgrounds[i]);
                    ++i;
                }
                if (columnIds == null) {
                    item.setBackground(0, backgrounds[0]);
                } else {
                    i = 0;
                    while (i < backgrounds.length) {
                        item.setBackground(i, backgrounds[i]);
                        ++i;
                    }
                }
                item.setData(PREV_BACKGROUND_KEY, (Object)backgrounds);
            }
            if (fontDatas == null) {
                i = 0;
                while (i < numColumns) {
                    item.setFont(i, null);
                    ++i;
                }
                item.setData(PREV_FONT_KEY, null);
            } else {
                Font[] fonts = new Font[fontDatas.length];
                i = 0;
                while (i < fontDatas.length) {
                    fonts[i] = ((ITreeModelLabelProvider)this.getLabelProvider()).getFont(fontDatas[i]);
                    ++i;
                }
                if (columnIds == null) {
                    item.setFont(0, fonts[0]);
                } else {
                    i = 0;
                    while (i < fonts.length) {
                        item.setFont(i, fonts[i]);
                        ++i;
                    }
                }
                item.setData(PREV_FONT_KEY, (Object)fonts);
            }
        }
    }

    @Override
    public ViewerLabel getElementLabel(TreePath path, String columnId) {
        TreeItem item;
        if (path.getSegmentCount() == 0) {
            return null;
        }
        int columnIdx = -1;
        String[] visibleColumns = this.getVisibleColumns();
        if (columnId != null && visibleColumns != null) {
            int i = 0;
            i = 0;
            while (i < visibleColumns.length) {
                if (columnId.equals(this.getVisibleColumns()[i])) {
                    columnIdx = i;
                    break;
                }
                ++i;
            }
            if (i == visibleColumns.length) {
                return null;
            }
        } else {
            columnIdx = 0;
        }
        if ((item = (TreeItem)this.findItem(path)) != null) {
            ViewerLabel label = new ViewerLabel(item.getText(columnIdx), item.getImage(columnIdx));
            label.setFont(item.getFont(columnIdx));
            label.setBackground(item.getBackground(columnIdx));
            label.setForeground(item.getForeground(columnIdx));
            return label;
        }
        return null;
    }

    @Override
    public void reveal(TreePath path, int index) {
        Widget item = this.findItem(path);
        TreeItem[] children = null;
        if (item instanceof TreeItem) {
            children = ((TreeItem)item).getItems();
        } else if (item instanceof Tree) {
            children = ((Tree)item).getItems();
        }
        if (children != null && index < children.length) {
            this.getTree().setTopItem(children[index]);
        }
    }

    @Override
    public int getChildCount(TreePath path) {
        if (path.getSegmentCount() == 0) {
            return ((Tree)this.getControl()).getItemCount();
        }
        Widget[] items = this.internalFindItems(path);
        if (items.length > 0 && items[0] instanceof TreeItem) {
            return ((TreeItem)items[0]).getItemCount();
        }
        return -1;
    }

    @Override
    public Object getChildElement(TreePath path, int index) {
        TreeItem childItem = null;
        if (path.getSegmentCount() == 0) {
            Tree tree = (Tree)this.getControl();
            try {
                childItem = tree.getItem(index);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            try {
                Widget[] items = this.internalFindItems(path);
                if (items.length > 0 && items[0] instanceof TreeItem) {
                    childItem = ((TreeItem)items[0]).getItem(index);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (childItem != null) {
            return childItem.getData();
        }
        return null;
    }

    @Override
    public TreePath getTopElementPath() {
        TreeItem topItem = ((Tree)this.getControl()).getTopItem();
        if (topItem != null && !topItem.isDisposed() && topItem.getData() != null) {
            return this.getTreePathFromItem((Item)topItem);
        }
        return null;
    }

    @Override
    public boolean saveElementState(TreePath path, ModelDelta delta, int flagsToSave) {
        Tree tree = (Tree)this.getControl();
        TreeItem[] selection = tree.getSelection();
        HashSet<TreeItem> set = new HashSet<TreeItem>();
        int i = 0;
        while (i < selection.length) {
            set.add(selection[i]);
            ++i;
        }
        TreeItem[] items = null;
        Widget w = this.internalGetWidgetToSelect(path);
        if (w instanceof Tree) {
            delta.setChildCount(((ITreeModelContentProvider)this.getContentProvider()).viewToModelCount(path, tree.getItemCount()));
            if ((flagsToSave & 0x100000) != 0) {
                delta.setFlags(delta.getFlags() | 0x100000);
            }
            items = tree.getItems();
        } else if (w instanceof TreeItem) {
            TreeItem item = (TreeItem)w;
            if (item.getExpanded()) {
                int itemCount = item.getData() != null ? item.getItemCount() : -1;
                delta.setChildCount(((ITreeModelContentProvider)this.getContentProvider()).viewToModelCount(path, itemCount));
                if ((flagsToSave & 0x100000) != 0) {
                    delta.setFlags(delta.getFlags() | 0x100000);
                }
            } else if ((flagsToSave & 0x2000000) != 0) {
                delta.setFlags(delta.getFlags() | 0x2000000);
            }
            if (set.contains(item) && (flagsToSave & 0x200000) != 0) {
                delta.setFlags(delta.getFlags() | 0x200000);
            }
            items = ((TreeItem)w).getItems();
        }
        if (items != null && items.length != 0) {
            int i2 = 0;
            while (i2 < items.length) {
                this.doSaveElementState(path, delta, items[i2], set, i2, flagsToSave);
                ++i2;
            }
            return true;
        }
        return false;
    }

    private void doSaveElementState(TreePath parentPath, ModelDelta delta, TreeItem item, Collection<TreeItem> set, int index, int flagsToSave) {
        Object element = item.getData();
        if (element != null) {
            boolean expanded = item.getExpanded();
            boolean selected = set.contains(item);
            int flags = 0;
            if (expanded && (flagsToSave & 0x100000) != 0) {
                flags |= 0x100000;
            }
            if (!expanded && (flagsToSave & 0x2000000) != 0) {
                flags |= 0x2000000;
            }
            if (selected && (flagsToSave & 0x200000) != 0) {
                flags |= 0x200000;
            }
            if (expanded || flags != 0) {
                int modelIndex = ((ITreeModelContentProvider)this.getContentProvider()).viewToModelIndex(parentPath, index);
                TreePath elementPath = parentPath.createChildPath(element);
                ModelDelta childDelta = delta.addNode(element, modelIndex, flags, -1);
                if (expanded) {
                    int itemCount = item.getItemCount();
                    int numChildren = ((ITreeModelContentProvider)this.getContentProvider()).viewToModelCount(elementPath, itemCount);
                    childDelta.setChildCount(numChildren);
                    TreeItem[] items = item.getItems();
                    int i = 0;
                    while (i < items.length) {
                        this.doSaveElementState(elementPath, childDelta, items[i], set, i, flagsToSave);
                        ++i;
                    }
                }
            }
        }
    }

    @Override
    public void updateViewer(IModelDelta delta) {
        ((ITreeModelContentProvider)this.getContentProvider()).updateModel(delta, -1);
    }

    @Override
    public void setElementChecked(TreePath path, boolean checked, boolean grayed) {
        Widget widget = this.findItem(path);
        if (widget != null && widget instanceof TreeItem && !widget.isDisposed()) {
            TreeItem item = (TreeItem)widget;
            item.setChecked(checked);
            item.setGrayed(grayed);
            item.setData(PREV_CHECKED_KEY, (Object)(checked ? Boolean.TRUE : Boolean.FALSE));
            item.setData(PREV_GRAYED_KEY, (Object)(grayed ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    @Override
    public boolean getElementChecked(TreePath path) {
        Widget widget = this.findItem(path);
        if (widget != null && widget instanceof TreeItem && !widget.isDisposed()) {
            TreeItem item = (TreeItem)widget;
            return item.getChecked();
        }
        return false;
    }

    @Override
    public boolean getElementGrayed(TreePath path) {
        Widget widget = this.findItem(path);
        if (widget != null && widget instanceof TreeItem && !widget.isDisposed()) {
            TreeItem item = (TreeItem)widget;
            return item.getGrayed();
        }
        return false;
    }

    @Override
    public boolean getHasChildren(Object elementOrTreePath) {
        if (elementOrTreePath instanceof TreePath && ((TreePath)elementOrTreePath).getSegmentCount() == 0) {
            return this.getTree().getItemCount() > 0;
        }
        Widget[] items = this.internalFindItems(elementOrTreePath);
        if (items != null && items.length > 0) {
            if (items[0] instanceof TreeItem) {
                return ((TreeItem)items[0]).getItemCount() > 0;
            }
            return ((Tree)items[0]).getItemCount() > 0;
        }
        return false;
    }

    @Override
    public TreePath[] getElementPaths(Object element) {
        Widget[] items = this.internalFindItems(element);
        TreePath[] paths = new TreePath[items.length];
        int i = 0;
        while (i < items.length) {
            paths[i] = items[i] instanceof Tree ? TreePath.EMPTY : this.getTreePathFromItem((Item)items[i]);
            ++i;
        }
        return paths;
    }

    protected void handleSelect(SelectionEvent event) {
        super.handleSelect(event);
        TreeItem item = (TreeItem)event.item;
        if (item != null) {
            Object element = item.getData();
            IContentProvider contentProvider = this.getContentProvider();
            if (element != null && contentProvider instanceof TreeModelContentProvider) {
                TreePath path = this.getTreePathFromItem((Item)item);
                if (event.detail == 32) {
                    boolean checked = item.getChecked();
                    boolean accepted = ((ITreeModelContentProvider)contentProvider).setChecked(path, checked);
                    if (!accepted) {
                        item.setChecked(!checked);
                    } else {
                        item.setData(PREV_CHECKED_KEY, (Object)checked);
                    }
                } else {
                    ((TreeModelContentProvider)contentProvider).cancelRestore(path, 0x1200000);
                }
            }
        }
    }

    protected void handleTreeExpand(TreeEvent event) {
        super.handleTreeExpand(event);
        IContentProvider contentProvider = this.getContentProvider();
        if (contentProvider instanceof TreeModelContentProvider && event.item.getData() != null) {
            TreePath path = this.getTreePathFromItem((Item)((TreeItem)event.item));
            ((TreeModelContentProvider)contentProvider).cancelRestore(path, 0x2000000);
        }
    }

    protected void handleTreeCollapse(TreeEvent event) {
        super.handleTreeCollapse(event);
        IContentProvider contentProvider = this.getContentProvider();
        if (contentProvider instanceof TreeModelContentProvider && event.item.getData() != null) {
            TreePath path = this.getTreePathFromItem((Item)((TreeItem)event.item));
            ((TreeModelContentProvider)contentProvider).cancelRestore(path, 0x100000);
        }
    }

    @Override
    public void clearSelectionQuiet() {
        this.getTree().setSelection(new TreeItem[0]);
    }

    class CellModifierProxy
    implements ICellModifier {
        private ICellModifier fModifier;

        CellModifierProxy() {
        }

        public boolean canModify(Object element, String property) {
            IElementEditor editor = ViewerAdapterService.getElementEditor(element);
            if (editor != null) {
                CellEditor cellEditor;
                this.fModifier = editor.getCellModifier(InternalTreeModelViewer.this.getPresentationContext(), element);
                if (this.fModifier != null && this.fModifier.canModify(element, property) && (cellEditor = editor.getCellEditor(InternalTreeModelViewer.this.getPresentationContext(), property, element, (Composite)InternalTreeModelViewer.this.getControl())) != null) {
                    this.disposeCellEditors();
                    CellEditor[] newEditors = new CellEditor[InternalTreeModelViewer.this.getVisibleColumns().length];
                    int i = 0;
                    while (i < newEditors.length) {
                        newEditors[i] = cellEditor;
                        ++i;
                    }
                    InternalTreeModelViewer.this.setCellEditors(newEditors);
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (this.fModifier != null) {
                return this.fModifier.getValue(element, property);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (this.fModifier != null) {
                if (element instanceof Item) {
                    element = ((Item)element).getData();
                }
                this.fModifier.modify(element, property, value);
            }
        }

        protected void clear() {
            this.fModifier = null;
            this.disposeCellEditors();
            InternalTreeModelViewer.this.setCellEditors(null);
        }

        protected void disposeCellEditors() {
            CellEditor[] cellEditors = InternalTreeModelViewer.this.getCellEditors();
            if (cellEditors != null) {
                int i = 0;
                while (i < cellEditors.length) {
                    CellEditor editor = cellEditors[i];
                    if (editor != null) {
                        editor.dispose();
                    }
                    ++i;
                }
            }
        }
    }

    class ColumnListener
    implements ControlListener {
        ColumnListener() {
        }

        public void controlMoved(ControlEvent e) {
            InternalTreeModelViewer.this.persistColumnOrder();
        }

        public void controlResized(ControlEvent e) {
            InternalTreeModelViewer.this.persistColumnSizes();
        }
    }
}

