/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.stringsubstitution;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;

public class SelectedResourceManager {
    private static SelectedResourceManager fgDefault;

    public static SelectedResourceManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SelectedResourceManager();
        }
        return fgDefault;
    }

    public IStructuredSelection getCurrentSelection() {
        if (DebugUIPlugin.getStandardDisplay().getThread().equals(Thread.currentThread())) {
            return this.getCurrentSelection0();
        }
        IStructuredSelection[] selection = new IStructuredSelection[1];
        DebugUIPlugin.getStandardDisplay().syncExec(() -> {
            IStructuredSelection iStructuredSelection = this.getCurrentSelection0();
        });
        return selection[0];
    }

    private IStructuredSelection getCurrentSelection0() {
        IWorkbenchPage page;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            ISelection selection;
            ISelectionProvider provider;
            IWorkbenchPartSite site;
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IEditorPart) {
                return new StructuredSelection((Object)part);
            }
            if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
                return (IStructuredSelection)provider.getSelection();
            }
        }
        return StructuredSelection.EMPTY;
    }

    public IResource getSelectedResource() {
        if (DebugUIPlugin.getStandardDisplay().getThread().equals(Thread.currentThread())) {
            return this.getSelectedResource0();
        }
        IResource[] resource = new IResource[1];
        DebugUIPlugin.getStandardDisplay().syncExec(() -> {
            IResource iResource = this.getSelectedResource0();
        });
        return resource[0];
    }

    protected IResource getSelectedResource0() {
        IWorkbenchPage page;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        IResource resource = null;
        if (window != null && (page = window.getActivePage()) != null) {
            IStructuredSelection ss;
            ISelection selection;
            ISelectionProvider provider;
            IWorkbenchPartSite site;
            IWorkbenchPart part = page.getActivePart();
            if (part instanceof IEditorPart) {
                IEditorPart epart = (IEditorPart)part;
                resource = (IResource)epart.getEditorInput().getAdapter(IResource.class);
            } else if (part != null && (site = part.getSite()) != null && (provider = site.getSelectionProvider()) != null && (selection = provider.getSelection()) instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Iterator iterator = ss.iterator();
                while (iterator.hasNext() && resource == null) {
                    Object next = iterator.next();
                    resource = (IResource)Platform.getAdapterManager().getAdapter(next, IResource.class);
                }
            }
        }
        return resource;
    }

    public String getSelectedText() {
        if (DebugUIPlugin.getStandardDisplay().getThread().equals(Thread.currentThread())) {
            return this.getSelectedText0();
        }
        String[] text = new String[1];
        DebugUIPlugin.getStandardDisplay().syncExec(() -> {
            String string = this.getSelectedText0();
        });
        return text[0];
    }

    protected String getSelectedText0() {
        ISelection selection;
        ISelectionProvider sprovider;
        IEditorSite esite;
        IEditorPart epart;
        IWorkbenchPage page;
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (epart = page.getActiveEditor()) != null && (esite = epart.getEditorSite()) != null && (sprovider = esite.getSelectionProvider()) != null && (selection = sprovider.getSelection()) instanceof ITextSelection) {
            return ((ITextSelection)selection).getText();
        }
        return null;
    }

    public IWorkbenchWindow getActiveWindow() {
        if (DebugUIPlugin.getStandardDisplay().getThread().equals(Thread.currentThread())) {
            return DebugUIPlugin.getActiveWorkbenchWindow();
        }
        IWorkbenchWindow[] window = new IWorkbenchWindow[1];
        DebugUIPlugin.getStandardDisplay().syncExec(() -> {
            IWorkbenchWindow iWorkbenchWindow = DebugUIPlugin.getActiveWorkbenchWindow();
        });
        return window[0];
    }
}

