/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.event;

import java.security.PrivilegedAction;
import org.eclipse.equinox.internal.util.UtilActivator;

class PrivilegedActionImpl
implements PrivilegedAction<Thread> {
    private ThreadGroup group;
    private Runnable runnable;
    private String name;
    private boolean locked = false;
    private int waiting = 0;

    PrivilegedActionImpl() {
    }

    void set(ThreadGroup group, Runnable runnable, String name) {
        this.lock();
        this.group = group;
        this.runnable = runnable;
        this.name = name;
    }

    @Override
    public Thread run() {
        ThreadGroup group1 = this.group;
        Runnable runnable1 = this.runnable;
        String name1 = this.name;
        this.unlock();
        Thread th = new Thread(group1, runnable1, name1);
        if (!UtilActivator.getBoolean("equinox.disableContextClassLoader")) {
            th.setContextClassLoader(null);
        }
        th.setDaemon(false);
        return th;
    }

    private synchronized void lock() {
        while (this.locked) {
            try {
                ++this.waiting;
                this.wait();
                --this.waiting;
            }
            catch (Exception exception) {}
        }
        this.locked = true;
    }

    private synchronized void unlock() {
        this.locked = false;
        this.group = null;
        this.runnable = null;
        this.name = null;
        if (this.waiting > 0) {
            this.notifyAll();
        }
    }
}

