/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.trace;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAnalysisEventRequirement;

public class KernelEventLayoutRequirement {
    private final Set<ILayoutToEventName> fEventNames;
    private final TmfAbstractAnalysisRequirement.PriorityLevel fLevel;

    public KernelEventLayoutRequirement(Set<ILayoutToEventName> layoutReqs, TmfAbstractAnalysisRequirement.PriorityLevel level) {
        this.fEventNames = layoutReqs;
        this.fLevel = level;
    }

    public TmfAbstractAnalysisRequirement instanciateRequirements(IKernelAnalysisEventLayout layout) {
        ImmutableList.Builder events = new ImmutableList.Builder();
        for (ILayoutToEventName eventNameLayout : this.fEventNames) {
            String eventName = eventNameLayout.getEventName(layout);
            if (eventName == null) continue;
            events.add((Object)eventName);
        }
        return new TmfAnalysisEventRequirement((Collection)events.build(), this.fLevel);
    }

    @FunctionalInterface
    public static interface ILayoutToEventName {
        public @Nullable String getEventName(IKernelAnalysisEventLayout var1);
    }
}

